package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.*;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 乡村建设红线
 * Created by licong on 2021/4/30.
 */
@Service("CloudAnalyzeCQXcjshxService")
@Primary
public class CloudAnalyzeCQXcjshxService extends CloudAnalyzeCQBysxzService {
    private GiLoger logger = GwLoger.getLoger(CloudAnalyzeCQXcjshxService.class);
    Font italic;
    public CloudAnalyzeCQXcjshxService() throws IOException, DocumentException {
      /*  String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String rootPath = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        ClassPathResource classPathResource = new ClassPathResource("/data/simkai.ttf");*/
        ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
        if (simkai.exists()) {
            InputStream simkaiinputStream = simkai.getInputStream();
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");
            try {
                FileUtils.copyInputStreamToFile(simkaiinputStream, simkaiFile);
            } finally {
                IOUtils.closeQuietly(simkaiinputStream);
            }
            // 定义字体
            italic = new Font(BaseFont.createFont(simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.EMBEDDED), 12, Font.ITALIC);
            italic.setColor(255, 0, 0);
        }

    }

    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document=  this.createPdf(info);

            document.addTitle("“乡村建设有红线，调查云中看一看”分析报告");
            this.addTitle(info.projectName + "“乡村建设有红线，调查云中看一看”分析报告", titleFont,document);
            this.addContent(document);
            ResultInfo result = new ResultInfo();
            this.BaseInfo(infoList, result,document);
            this.secondPart(infoList, result,document);
            this.thirdPart(infoList, result,document);
            this.fourthPart(infoList, result,document);
//            this.fifthPart(infoList, result);
            this.SummarizeAnalysis(info, result,document);
            this.AddSign(info,document);
            this.addDescribeXcjshx(document);

            document.close();
            return true;
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void addContent( Document document) throws DocumentException {
        String content1 = "按照您勾绘的项目范围，依据国土调查云后台数据，生成的“乡村建设有红线，调查云中看一看”分析报告如下。";
        String content2 = "受数据齐全性、时效性和精度限制，本分析报告仅用于辅助参考，不具有法律效应。";
        Chunk chunk1 = new Chunk(content1, this.normalFont);
        Chunk chunk2 = new Chunk(content2, this.italic);
        Paragraph paragraph = new Paragraph();
        paragraph.add(chunk1);
        paragraph.add(chunk2);
        paragraph.setFirstLineIndent(firstLineIndent);
        this.addContentTxtFormat(paragraph,document);
    }

    protected void BaseInfo(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("一、基本情况",document);
        String content ="%s项目位于%s%s%s%s（东经：%s°，北纬：%s°），项目地块面积%s平方米。";
        if (StringUtils.isEmpty(info.location)) {
            content = String.format(content,info.projectName,info.provinceName,(info.logicCity?"": info.cityName),info.countyName,info.villageName,info.lontitude,info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area,2)));
        } else {
            content ="%s项目位于%s%s（东经：%s°，北纬：%s°），项目地块面积%s平方米。";
            content = String.format(content,info.projectName,info.provinceName,info.location,info.lontitude,info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area,2)));
        }
        this.addContent(content,document);
    }

    protected void secondPart(List<ProjectInfo> infoList,ResultInfo result, Document document) throws DocumentException {
        ProjectInfo info = null;
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("二、生态保护红线分析",document);
        this.addSthxMessage(result, info, other, null,document);
    }

    /**
     * 村镇国土空间规划
     * @param infoList
     * @param result
     * @throws DocumentException
     * 1，有村规，符合村规就结束
     */
    protected void fourthPart(List<ProjectInfo> infoList,ResultInfo result, Document document) throws DocumentException {
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("四、城镇开发边界",document);
        this.addCzkfbjMessage(result, other, null,document);
//        this.addSencondTitle("(二)镇村国土空间规划");
//        this.addCghContent(result, other);
    }
//
//    protected void addCghContent(ResultInfo result, ProjectInfo info) throws DocumentException {
//        String resultMessage = "基于重庆村规划数据分析：";
//        Boolean cantBuild = true;
//        String desc ="";
//        if(info.cghInfos != null) {
//            resultMessage += "拟建项目区村规划中规划地类为";
//            for(int i =0; i < info.cghInfos.size(); i++) {
//                CommonInfoCQ item = info.cghInfos.get(i);
//                String type = item.type;
//                Double typeArea = item.area;
//                desc += type + ":" + Round(typeArea,2) + "平方米";
//                if (i != info.cghInfos.size() - 1)
//                    desc += "，";
//                if (!("村居住用地").equals(type) && !"村居住用地(宅基地)".equals(type) && !"村居住用地（宅基地）".equals(type) && !"农村居民点用地".equals(type)
//                        && !"宅基地".equals(type) && !"宅基地(村居住用地)".equals(type) && !"宅基地(村居住用地）".equals(type)
//                        && !"宅基地（村居住用地）".equals(type) && !"宅基地（村居住用地)".equals(type) && typeArea > 0){
//                    cantBuild = false;
//                }
//            }
//            resultMessage += desc + "。";
//        }
//        if (info.cghInfos == null) {
//            result.passCgh = EnumAnalyzeResult.NoPass;
//            resultMessage +="拟建设项目区无村庄规划信息。";
//        } else if(!cantBuild) {
//            result.passCgh = EnumAnalyzeResult.NoPass;
//            resultMessage +="拟建设项目区不符合村庄规划。";
//        } else {
//            result.passCgh=EnumAnalyzeResult.AllPass;
//            resultMessage +="拟建设项目区符合村庄规划。";
//        }
//        this.addContent(resultMessage);
//        if(info.cghImg != null) {
//            AddImg("村规划",info.cghImg,desc);
//        }
//    }

    protected void SummarizeAnalysis(ProjectInfo info,ResultInfo result, Document document) throws DocumentException {
        this.addFirstTitle("五、总体分析",document);

        String content = "根据已有数据分析结果，拟建设项目区";
        boolean legal = result.passSthx == EnumAnalyzeResult.AllPass
                && result.passJbnt == EnumAnalyzeResult.AllPass ;
        boolean unlegal = result.passSthx == EnumAnalyzeResult.NoPass
                || result.passJbnt == EnumAnalyzeResult.NoPass;

        boolean allPass = legal;
        if (allPass) {
            content += "合法。";
            content += "不涉及生态红线、";
            content += "不涉及占用永久基本农田。";
        } else if (unlegal) {
            content += "不合法。";
            switch (result.passSthx) {
                case NoPass:
                    content += "涉及生态红线、";
                    break;
                case PartPass:
                    content += "部分区域涉及生态红线、";
                    break;
            }
            switch (result.passJbnt) {
                case NoPass:
                    content += "涉及占用永久基本农田、";
                    break;
                case PartPass:
                    content += "部分区域涉及占用永久基本农田、";
                    break;
            }
            content = content.substring(0, content.length() - 1) + "。";
        } else {
            boolean partlegal = false;
            String tmp = "";
            if (result.passSthx == EnumAnalyzeResult.PartPass) {
                tmp += "涉及生态红线、";
                partlegal = true;
            }
            if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                tmp += "涉及占用永久基本农田、";
                partlegal = true;
            }
            if (!StringUtils.isEmpty(tmp))
                tmp = tmp.substring(0, tmp.length() - 1) + "。";
            if (partlegal) {
                content += "存在不符合法律法规的情况。比如部分地区";
            }
            content += tmp;
        }
        this.addContent(content,document);
    }

    protected void AddSign(ProjectInfo info, Document document) throws DocumentException {
        String sign="查询人员： "+info.userName;
        this.addSignContent(info.narrow, sign,document);
        String timeStr = "时  间： "+ new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr,document);
    }

    protected void addDescribeXcjshx( Document document) throws DocumentException, IOException {
        document.newPage();
        this.addFirstTitle("附：涉及政策解读",document);
        this.addSthxDescribe("1、关于生态保护红线",document);
        this.addDescribeImage("1.png",document);
        this.addJbntDescribe("2、关于永久基本农田",document);
        this.addDescribeImage("2.png",document);
        this.addCzkfbjDescribe("3、关于城镇开发边界",document);
        this.addDescribeImage("3.png",document);
    }

    protected void addSthxDescribe(String role, Document document) throws DocumentException {
        AddRoleDesc("《关于划定并严守生态保护红线的若干意见》第八条 生态保护红线划定后，相关规划要符合生态保护红线空间管控要求，不符合的要及时进行调整。",role,document);
        AddRoleDesc("《关于划定并严守生态保护红线的若干意见》第九条 生态保护红线原则上按禁止开发区域的要求进行管理。严禁不符合主体功能定位的各类开发活动，严禁任意改变用途。",null,document);
    }

    protected void addCzkfbjDescribe(String role, Document document) throws DocumentException {
        AddRoleDesc("《关于在国土空间规划中统筹划定落实三条控制线的指导意见》第六条 按照集约适度、绿色发展要求划定城镇开发边界。" +
                "城镇开发边界划定以城镇开发建设现状为基础，综合考虑资源承载能力、人口分布、经济布局、城乡统筹、城镇发展阶段和发展潜力，" +
                "框定总量，限定容量，防止城镇无序蔓延。科学预留一定比例的留白区，为未来发展留有开发空间。城镇建设和发展不得违法违规侵占河道、" +
                "湖面、滩地。",role,document);
    }

    protected void addDescribeImage(String file, Document document) throws IOException, DocumentException {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String rootPath = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        Image image = Image.getInstance( rootPath + "data/xcjshx/" + file);
        PdfPCell cell =  this.creaeteImgCell(image);

        PdfPTable t = new PdfPTable(1);
        t.setKeepTogether(true);
        t.setSpacingBefore(pgSpace);//设置上边距
        t.setSpacingAfter(pgSpace);//设置下边距
        t.setWidthPercentage(80);
        t.addCell(cell);

        document.add(t);
    }
}
