package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.CommonInfoCQ;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 乡村建设红线版本2
 * Created by licong on 2021/6/10.
 */
@Service("CloudAnalyzeCQXcjshxService2")
@Primary
public class CloudAnalyzeCQXcjshxService2 extends CloudAnalyzeCQBysxzService {
    private GiLoger logger = GwLoger.getLoger(CloudAnalyzeCQXcjshxService2.class);
    Font italic;
    Font tableTitle;
    Font tableContent;
    public CloudAnalyzeCQXcjshxService2() throws IOException, DocumentException {
        ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
        if (simkai.exists()) {
            InputStream simkaiinputStream = simkai.getInputStream();
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");

            ClassPathResource STSONG = new ClassPathResource("/static/STSONG.TTF");
            InputStream STSONGinputStream = STSONG.getInputStream();
            File STSONGFile = File.createTempFile("template_STSONG_copy", ".TTF");
            try {
                FileUtils.copyInputStreamToFile(STSONGinputStream, STSONGFile);
                FileUtils.copyInputStreamToFile(simkaiinputStream, simkaiFile);
            } finally {
                IOUtils.closeQuietly(STSONGinputStream,simkaiinputStream);
            }
            // 定义字体
            italic = new Font(BaseFont.createFont(simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.EMBEDDED), 10, Font.ITALIC);
            italic.setColor(255, 0, 0);

            normalFont = new Font(BaseFont.createFont(STSONGFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.EMBEDDED), 10);

            tableTitle = new Font(BaseFont.createFont(simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.EMBEDDED), 8);
            tableTitle.setStyle(Font.BOLD);

            tableContent = new Font(BaseFont.createFont(STSONGFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.EMBEDDED), 8);
        }

    }

    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);

            document.addTitle("“乡村建设有红线，调查云中看一看”查询结果");
            this.addTitle("“乡村建设有红线，调查云中看一看”查询结果", titleFont,document);
            this.addContent(info,document);

            PdfPTable table = this.createTable(10, 20);

            if (null != info.tdlyxzImg) {
                PdfPCell img = this.creaeteImgCell(info.tdlyxzImg);
                table.addCell(img);
            }else {
                PdfPCell img = this.getDefaultImage("4.png");
                table.addCell(img);
            }

            if (null != info.sthxImg) {
                PdfPCell img = this.creaeteImgCell(info.sthxImg);
                table.addCell(img);

            } else {
                PdfPCell img = this.getDefaultImage("5.png");
                table.addCell(img);

            }

            if (null != info.tdlyxzImg) {
                List<String> data = new ArrayList<>();
                BigDecimal gd = new BigDecimal(0);
                BigDecimal ld = new BigDecimal(0);
                BigDecimal other = new BigDecimal(0);
                for (int i = 0; i < info.tdlyxzInfos.size(); i++) {
                    CommonInfoCQ obj = info.tdlyxzInfos.get(i);
                    if (obj.type.startsWith("01")) {
                        gd = gd.add(new BigDecimal(obj.area));
                    } else if (obj.type.startsWith("03")) {
                        ld = ld.add(new BigDecimal(obj.area));
                    } else {
                        other = other.add(new BigDecimal(obj.area));
                    }
                }
                data.add("耕地");
                data.add(gd.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
                data.add("林地");
                data.add(ld.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
                data.add("其他");
                data.add(other.setScale(2, BigDecimal.ROUND_HALF_UP).toString());
                PdfPTable txtTable = this.addTable(data);
//                table.addCell(txtTable);

                PdfPCell cell = new PdfPCell();
                cell.setRowspan(2);
                cell.setHorizontalAlignment(Element.ALIGN_CENTER);
                cell.setVerticalAlignment(Element.ALIGN_MIDDLE);

                PdfPCell cellBox = new PdfPCell(txtTable, cell);
                cellBox.setBorder(Rectangle.NO_BORDER);
                table.addCell(cellBox);
            } else {
                List<String> data = new ArrayList<>();
                data.add("土地利用现状");
                data.add("0");
                PdfPTable txtTable = this.addTable(data);
                PdfPCell cell = new PdfPCell();
                cell.setRowspan(2);
                cell.setHorizontalAlignment(Element.ALIGN_CENTER);
                cell.setVerticalAlignment(Element.ALIGN_MIDDLE);

                PdfPCell cellBox = new PdfPCell(txtTable, cell);
                cellBox.setBorder(Rectangle.NO_BORDER);
                table.addCell(cellBox);
            }
            PdfPTable table6 = null;
            if (null != info.sthxImg) {
                table6 = this.addTable("生态红线", "是", String.valueOf(PdfAnalyzeUtil.Round(info.sthxArea,2)), "是否压占");
            } else {
                table6 = this.addTable("生态红线", "否", "0", "是否压占");
            }
            PdfPCell cell = new PdfPCell();
            cell.setRowspan(1);
            cell.setHorizontalAlignment(Element.ALIGN_CENTER);
            cell.setVerticalAlignment(Element.ALIGN_MIDDLE);

            PdfPCell cellBox = new PdfPCell(table6, cell);
            cellBox.setBorder(Rectangle.NO_BORDER);
            table.addCell(cellBox);

            PdfPCell cell2 = new PdfPCell();//补全
            cell2.setBorder(Rectangle.NO_BORDER);
            table.addCell(cell2);


            PdfPTable table2 = this.createTable(0, 0);
            if (null != info.jbntImg) {
                PdfPCell cimg1 = this.creaeteImgCell(info.jbntImg);
                table2.addCell(cimg1);
            } else {
                PdfPCell img = this.getDefaultImage("6.png");
                table2.addCell(img);
            }
            if (null != info.czkfImg) {
                PdfPCell cimg1 = this.creaeteImgCell(info.czkfImg);
                table2.addCell(cimg1);
            } else {
                PdfPCell img = this.getDefaultImage("7.png");
                table2.addCell(img);
            }

            if (null != info.jbntImg) {
                PdfPTable table3 = this.addTable("永久基本农田", "是", String.valueOf(PdfAnalyzeUtil.Round(info.jbntArea,2)), "是否压占");
                table2.addCell(table3);
            } else {
                PdfPTable table3 = this.addTable("永久基本农田", "否", "0","是否压占");
                table2.addCell(table3);
            }

            if (null != info.czkfImg) {
                PdfPTable table4 = this.addTable("城镇开发边界", "是", String.valueOf(PdfAnalyzeUtil.Round(info.czkfArea,2)), "是否逾越");
                table2.addCell(table4);
            } else {
                PdfPTable table4 = this.addTable("城镇开发边界", "否", "0", "是否逾越");
                table2.addCell(table4);
            }
            document.add(table);
            document.add(table2);
            document.close();
            return true;
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    private PdfPTable addTable(List<String> data) throws DocumentException {
        int[] tableWidth = { 15, 25};
        PdfPTable table = this.getPdfPTable(2, tableWidth, 0, 0);
        table.addCell(this.createTableTitleCell("地类"));
        table.addCell(this.createTableTitleCell("面积"));
        for (int i = 0; i < data.size(); i++) {
            table.addCell(this.createTableContent(data.get(i)));
        }
        return table;
    }

    private PdfPTable addTable(String value1, String value2, String value3, String secondName) throws DocumentException {
        int[] tableWidth = { 15, 15, 15};
        PdfPTable table = this.getPdfPTable(3, tableWidth, 0, 0);
        table.addCell(this.createTableTitleCell("图层名称"));
        table.addCell(this.createTableTitleCell(secondName));
        table.addCell(this.createTableTitleCell("覆盖面积"));
        table.addCell(this.createTableContent(value1));
        table.addCell(this.createTableContent(value2));
        table.addCell(this.createTableContent(value3));
        return table;
    }

    private PdfPCell createTableTitleCell(String content){
        PdfPCell cell = new PdfPCell(new Phrase(content, tableTitle));
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setPaddingTop(5);
        cell.setPaddingBottom(5);
        return cell;
    }

    private PdfPTable createTable(Integer before, Integer after) throws DocumentException {
        int[] tableWidth = { 50, 50};
        PdfPTable table = this.getPdfPTable(2, tableWidth, before, after);
        return table;
    }

    protected void addContent(ProjectInfo info, Document document) throws DocumentException {
        String content1 = "根据已有数据分析结果，该查询区域";
        if (null == info.sthxImg) {
            content1 += "不";
        }
        content1 += "占用生态保护红线、";
        if (null == info.jbntImg) {
            content1 += "不";
        }
        content1 += "占用永久基本农田、";
        if (null == info.czkfImg) {
            content1 += "未";
        }
        content1 += "逾越城镇开发边界。";

        String content2 = "受数据齐全性、时效性和精度限制，本结果仅用于辅助参考，不具有法律效应。如有疑问请联系当地规划和自然资源管理部门。";
        Chunk chunk1 = new Chunk(content1, this.normalFont);
        Chunk chunk2 = new Chunk(content2, this.italic);
        Paragraph paragraph = new Paragraph();
        paragraph.add(chunk1);
        paragraph.add(chunk2);
        paragraph.setFirstLineIndent(firstLineIndent);
        this.addContentTxtFormat(paragraph,document);
    }

    protected PdfPCell creaeteImgCell(Image img) {
        PdfPCell cimg = null;
        if (null == img) {
            cimg = new PdfPCell();
        } else {
            float width = 120;
            float heigth = img.getHeight() / (img.getWidth() / width);
            img.scaleToFit(width, heigth);
            cimg = new PdfPCell(img);
        }
        cimg.setVerticalAlignment(Element.ALIGN_CENTER);
        cimg.setHorizontalAlignment(Element.ALIGN_CENTER);
        cimg.setPaddingTop(5);
        cimg.setPaddingBottom(5);
        cimg.setPaddingLeft(5);
        cimg.setPaddingRight(5);
        return cimg;
    }

    protected PdfPCell getDefaultImage(String file) throws IOException, DocumentException {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String rootPath = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        Image image = Image.getInstance( rootPath + "data/xcjshx/" + file);
        PdfPCell cell =  this.creaeteImgCell(image);
        return cell;
    }

    protected PdfPCell createTableContent(String title) {
        PdfPCell cell = new PdfPCell(new Phrase(title, tableContent));
        this.addImgTxtFormat(cell);
        return cell;
    }

    protected PdfPTable getPdfPTable(int column, int[] tableWidth, Integer before, Integer after) throws DocumentException {
        PdfPTable table = new PdfPTable(column);
        table.setWidths(tableWidth);
        table.setSpacingBefore(before);//设置上边距
        table.setSpacingAfter(after);//设置下边距
        table.getDefaultCell().setBorder(0);
        table.setWidthPercentage(90);
        return table;
    }
}
