package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfPTable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by licong on 2021/9/21.
 */
@Service("CloudAnalyzeGdbhApplyService")
@Primary
public class CloudAnalyzeGdbhApplyService extends CloudAnalyzeCQBysxzService {

    public CloudAnalyzeGdbhApplyService() throws IOException, DocumentException {
    }

    public boolean ExportReport(List<ProjectInfo> infoList, Integer type) throws DocumentException, IOException {
        Document document = null;
        try {
//            this.init();
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);

            document.addTitle(this.getName(type) + "申请云分析报告");
            this.addTitle(this.getName(type) + "申请云分析报告", titleFont,document);//info.projectName +
            String content = "按照您勾绘的" + this.getName(type) + "申请范围，依据渝耕保后台数据，生成的" + this.getName(type) +
                    "申请云分析报告如下。";
            this.addContent(content, 1,document);

            this.addContentItalicRed("受数据齐全性、时效性和精度限制，本分析报告仅用于辅助参考，不具有法律效应。",document);

            ResultInfo result = new ResultInfo();
            this.BaseInfo(infoList, type,document);

            this.secondPart(infoList, result,document);

            this.thirdPart(infoList, result,document);

            this.fourthPart(infoList, result,document);

            this.fifthPart(infoList, result,document);
//            result.passDzfx = EnumAnalyzeResult.AllPass;

            this.SummarizeAnalysis(info, result,document);

            this.AddSign(info,document);

            this.addDescribe(type,document);

            document.close();
//            this.destory();
            return true;
        } catch (Exception ex) {
            ex.printStackTrace();
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    /**
     * 一、基本情况
     * @param infoList
     * @throws DocumentException
     * @throws IOException
     */
    protected void BaseInfo(List<ProjectInfo> infoList, Integer type,Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("一、基本情况",document);
        String content ="位于%s%s%s%s（东经：%s°，北纬：%s°），地块面积%s平方米。";
        if (StringUtils.isEmpty(info.location)) {
            content = String.format(content, info.provinceName,(info.logicCity?"": info.cityName),info.countyName,info.villageName,
                    PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude),4),
                    PdfAnalyzeUtil.Round(Double.valueOf(info.latitude), 4),
                    PdfAnalyzeUtil.Round(info.area,2));
        } else {
            content ="位于%s%s（东经：%s°，北纬：%s°），地块面积%s平方米。";
            content = String.format(content, info.provinceName,info.location,
                    PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude),4),
                    PdfAnalyzeUtil.Round(Double.valueOf(info.latitude),4),
                    PdfAnalyzeUtil.Round(info.area,2));
        }
        content = "您所申请的" + this.getName(type) + "，" + content;

        content = this.getAreaContent(info, content);
        this.addContent(content,document);
        this.addTable(info, type,document);
        this.AddBaseImg(infoList,document);
    }

    protected void addTable(ProjectInfo info, Integer type,Document document) throws DocumentException {

        this.addTitle("表." + this.getName(type) + "申请相关规定", sectionFont,document);
        int[] tableWidth = { 45, 45};
        PdfPTable table = this.getPdfPTable(2, tableWidth);

        table.addCell(this.createImgTitle("是否占用"));
        table.addCell(this.createImgTitle("约束范围"));
        if (info.sthxImg != null) {
            table.addCell(this.createContent("占用", this.redFont));
        } else {
            table.addCell(this.createContent("不占用", this.greenFont));
        }
        table.addCell(this.createImgTitle("生态保护红线"));

        if (info.zrbhdImg != null) {
            table.addCell(this.createContent("占用", this.redFont));
        } else {
            table.addCell(this.createContent("不占用", this.greenFont));
        }
        table.addCell(this.createImgTitle("自然保护地"));

        if (info.jbntImg != null) {
            table.addCell(this.createContent("占用", this.redFont));
        } else {
            table.addCell(this.createContent("不占用", this.greenFont));
        }
        table.addCell(this.createImgTitle("永久基本农田"));

        if (info.czkfImg != null) {
            table.addCell(this.createContent("占用", this.redFont));
        } else {
            table.addCell(this.createContent("不占用", this.greenFont));
        }
        table.addCell(this.createImgTitle("城镇开发边界"));

        document.add(table);
    }

    /**
     * 永久基本农田分析
     * @param infoList
     * @param result
     * @throws DocumentException
     */
    protected void thirdPart(List<ProjectInfo> infoList,ResultInfo result,Document document) throws DocumentException {
        ProjectInfo info = null;
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("三、永久基本农田分析",document);
        this.addJbntMessageContent(result, other,document);
        this.addBhyjjbnt(document);
    }

    protected void addJbntMessageContent(ResultInfo result, ProjectInfo other,Document document) throws DocumentException {
        this.addSencondTitle("(一)永久基本农田",document);
        String jbntResult ="基于重庆基本农田数据分析：";
        if (null != other.jbntArea && other.jbntArea > 0) {
            result.passJbnt = EnumAnalyzeResult.NoPass;
            if(other.jbntArea < other.area) {
                result.passJbnt = EnumAnalyzeResult.PartPass;
            }
            jbntResult += "拟申请区涉及永久基本农田，共" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "平方米。";
        } else {
            result.passJbnt = EnumAnalyzeResult.AllPass;
            jbntResult += "拟申请区不涉及永久基本农田。";
        }
        this.addContent(jbntResult,document);
        if(other.jbntImg!=null) {
            String desc = "基本农田："+PdfAnalyzeUtil.Round(other.jbntArea,2)+"平方米";
            AddImg("永久基本农田",other.jbntImg,desc,document);
        }
    }

    protected void addBhyjjbnt(Document document) throws DocumentException {
        this.addSencondTitle("(二)补划永久基本农田",document);
        this.addContent("暂无数据",document);
    }

    private String getName(Integer type) {
        if (1 == type)
            return "设施农用地选址复核";
        else if (2 == type)
            return "临时用地";
        else if (3 == type)
            return "农房";
        else
            return "";
    }

    protected void AddSign(ProjectInfo info,Document document) throws DocumentException {
        String timeStr = "时  间： "+ new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr,document);
    }

    protected void addDescribe(Integer type,Document document) throws DocumentException {
        document.newPage();
        this.addFirstTitle("附：涉及政策解读",document);
        this.addSthxDescribe("1、关于生态保护红线",document);
        this.addZrbhqDescribe("2、关于自然保护地",document);
        this.addJbntDescribe("3、关于永久基本农田",document);
        this.addCzkfbjDescribe("4、关于城镇开发边界",document);
        if (2 == type) {
            this.addTdghDescribe("5、关于村镇国土空间规划",document);
            this.addDzzhDescribe("6、地址灾害安全",document);
        }
    }
}
