package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;

/**
 * 耕保app查询功能
 * Created by licong on 2021/9/23.
 */
@Service("CloudAnalyzeGdbhService")
@Primary
public class CloudAnalyzeGdbhService extends CloudAnalyzeCQBysxzService {

    public CloudAnalyzeGdbhService() throws IOException, DocumentException {
    }

    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            ProjectInfo otherInfo = this.getOtherNode(infoList);
            document= this.createPdf(info);

            document.addTitle("耕地查询报告");
            this.addTitle("耕地查询报告", titleFont,document);
            String content = "按照您勾绘的耕地查询区域，依据渝耕保后台数据，生成的耕地查询报告如下。";
            this.addContent(content, 0,document);

            this.addContentItalicRed("受数据齐全性、时效性和精度限制，本分析报告仅用于辅助参考，不具有法律效应。",document);

            this.BaseInfo(infoList,document);

            this.secondPart(otherInfo, "二、土地利用现状查询",document);

            this.thirdPart(otherInfo, "三、耕地坡度查询",document);

            this.thirdPart(otherInfo, "四、耕地质量查询",document);

            this.fifthPart(otherInfo, "五、永久基本农田查询",document);

            this.thirdPart(otherInfo, "六、补充耕地查询",document);

//            this.thirdPart(otherInfo, "七、临时用地查询");
//
//            this.thirdPart(otherInfo, "八、设施农用地查询");

            document.close();
            return true;
        } catch (Exception ex) {
            ex.printStackTrace();
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void BaseInfo(List<ProjectInfo> infoList, Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("一、基本情况",document);
        String content ="位于%s%s%s%s（东经：%s°，北纬：%s°），总查询区域面积%s平方米。";
        if (StringUtils.isEmpty(info.location)) {
            content = String.format(content, info.provinceName,(info.logicCity?"": info.cityName),info.countyName,info.villageName,
                    PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude),4),
                    PdfAnalyzeUtil.Round(Double.valueOf(info.latitude), 4),
                    PdfAnalyzeUtil.Round(info.area,2));
        } else {
            content ="位于%s%s（东经：%s°，北纬：%s°），总查询区域面积%s平方米。";
            content = String.format(content, info.provinceName,info.location,
                    PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude),4),
                    PdfAnalyzeUtil.Round(Double.valueOf(info.latitude),4),
                    PdfAnalyzeUtil.Round(info.area,2));
        }
        this.addContent(content,document);
        this.AddBaseImg(infoList,document);
    }

    protected void secondPart(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addFirstTitle(title,document);
        String desc ="根据查询结果显示，";
        if(info.tdghCqInfos!=null && info.tdghCqInfos.size()>0) {
            desc += "您所勾绘的查询范围有" + this.getTdlyxz(info) + "，具体分布可查看详细分析图。";
        } else {
            desc += "您所勾绘的查询范围没有占用土地利用现状图层";
        }
        this.addContent(desc,document);
        if(info.tdghCqImg != null) {
            AddImg(null, info.tdghCqImg, "土地利用现状叠加分析图",document);
        }
    }

    protected void thirdPart(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addFirstTitle(title,document);
        String desc ="暂无数据";

        this.addContent(desc,document);
    }

    protected void fifthPart(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addFirstTitle(title,document);
        this.addYjjbnt(info, "（一）永久基本农田",document);
        this.addBhyjjbnt(info, "（二）补划永久基本农田",document);
    }

    protected void addYjjbnt(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addSencondTitle(title,document);
        String desc = "";
        if(info.jbntArea !=null && info.jbntArea >0) {
            desc += "查询范围内涉及永久基本农田，其中占用永久基本农田" + PdfAnalyzeUtil.Round(info.jbntArea,2) + "平方米。";
        } else {
            desc += "查询范围内不涉及永久基本农田。";
        }
        this.addContent(desc,document);
        if(info.jbntImg != null) {
            AddImg(null, info.jbntImg, "永久基本农田叠加分析图",document);
        }
    }
    protected void addBhyjjbnt(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addSencondTitle(title,document);
        String desc = "暂无数据";
        this.addContent(desc,document);
    }
}
