package com.geoway.landteam.landcloud.service.datacq.impl;

import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbBizProjectHistory;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectHistoryRepository;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectRepository;
import com.geoway.landteam.landcloud.servface.datacq.BackDataService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.service.thirddata.utils.MaterializedViewUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.ProjectStatus;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.sql.Connection;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Created by licong on 2020/6/15.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class BackDataServiceImpl implements BackDataService {
    @Value("${project.submitDir}")
    protected String submitDir;
    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    private TskTaskBizRepository taskBizRepository;
    @Autowired
    private TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    private TbBizProjectRepository projectRepository;
    @Autowired
    private TbtskFieldsRepository fieldsRepository;
    @Autowired
    private TbtskGroupRepository groupRepository;
    @Autowired
    private AppMediaRepository appMediaRepository;
    @Autowired
    private UserBiz2Repository userBiz2Repository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
/*    @Autowired
    private ITaskDeleteService taskDeleteService;*/
    @Autowired
    private TskRightAreaRepository TskRightAreaRepository;
 /*   @Autowired
    private TskTaskBizHistoryRepository historyRepository;*/
    @Autowired
    private TbBizProjectHistoryRepository projectHistoryRepository;
    /*@Autowired
    private ProjectStatisticRepository2 statisticRepository;*/
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    private TskAssignRecordRepository assignRecordRepository;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
   /* @Autowired
    private ExportDataService exportDataService;*/
    @Autowired
    private ExportTxtService exportTxtService;


    private GiLoger logger = GwLoger.getLoger(BackDataServiceImpl.class);

    @Override
    @Transactional
    public TskTaskBiz reviewProject(String bizId, String message, String checkId, String checkStatus) throws Exception {
        TskTaskBiz oldBiz = this.taskBizRepository.gwSearchByPK(bizId);
        TbtskObjectinfo oldTableInfo = this.objectinfoRepository.gwSearchByPK(oldBiz.getTableId());
        if (oldBiz == null) {
            this.logger.error("没有找到对应项目,bizId:" + bizId);
            throw new Exception("没有找到对应项目");
        }
        if (ProjectStatus.status1.equals(checkStatus)) {
            this.taskResouceService.saveCheckMessage(message, bizId);
            return null;
        } else if (ProjectStatus.status2.equals(checkStatus)) {
            this.taskResouceService.saveCheckMessage(message, bizId);
            return null;
        } else if (ProjectStatus.status3.equals(checkStatus)) {
            if (null != oldBiz.getIsDel() && 1 == oldBiz.getIsDel()) {//如果项目标记为已删除
                return null;
            }
            oldBiz.setIsDel(1);
            this.taskBizRepository.save(oldBiz);
            //发送删除任务消息
           /* this.taskDeleteService.deleteTask(101l, bizId, new ArrayList<String>(), 15);*/
            this.exportTxtService.deleteTask(bizId,null,false);
            //创建数据表
            Map<String, String> dataMap = this.copyData(oldTableInfo.getfTablename());
            String newTableName = dataMap.get("tableName");
            //复制表关联
            TbtskObjectinfo newTable =this.copyObjectInfo(oldTableInfo, newTableName);
            //复制任务表
            TskTaskBiz newBiz = this.copyNewTaskBiz(oldBiz, newTable.getfId());
           /* //将任务表保存至历史表中
            this.copyHistoryTaskBiz(oldBiz, newBiz.getId());*/
            //复制项目表
            TaskBizProject oldProject = this.projectRepository.findOneByTableid(oldTableInfo.getfId());
            TaskBizProject newProject = this.copyProject(checkId, newBiz.getId(), newTable.getfId(), checkStatus, oldProject);
            //将项目表保存至历史表中
            this.copyHistoryProject(newProject.getId(), oldProject);
            List<TbtskFields> fieldList = this.fieldsRepository.getTbtskFieldsByTableid(oldTableInfo.getfId());
            Map<String, String> fieldMap = this.copyFields(fieldList, newTable);
            //复制group
            this.copyGroup(oldTableInfo.getfTablename(), fieldMap, newTableName);
            //复制多媒体表
            this.copyMedia(dataMap);
            //复制任务权限表
            this.copyUserBiz(oldBiz.getId(), newBiz.getId());
            //复制作业区权限
            this.copyArea(oldBiz.getId(), newBiz.getId());
            //复制statistics
            this.copyStatistics(oldProject.getId(), newProject.getId(), newTable.getfId(), newTable.getfTablename());
            //复制下发表
            this.copyAssign(oldBiz.getId(), dataMap);
            MaterializedViewUtils.setJdbcTemplate(this.jdbcTemplate);
            MaterializedViewUtils.createOrReplaceBHJBNTTB2ConflicCheckView();
            //删除旧数据，上交时得找到新数据对应的旧数据id传至内网，将对应id的project和biz删除
//            未实现
            this.projectRepository.delete(oldProject);
//            this.taskBizRepository.delete(oldBiz);//删除任务里会发送消息需要

//            this.saveCheckMessage(message, newBiz.getId());

            String url = this.createDB(newTable, newBiz);
            newBiz.setStructDbUrl(url);
            this.taskBizRepository.save(newBiz);

            //不提交的情况下同步副本会增加冗余
            //this.exportDataService.createData(newBiz.getId(),null,false,false,null,IdentityType.WYDC,null);

            return newBiz;
        }
        return null;
    }

    @Override
    @Transactional
    public void reviewProjectLan(String bizId, String message) {
        TskTaskBiz oldBiz = this.taskBizRepository.gwSearchByPK(bizId);
        TaskBizProject oldProject = this.projectRepository.findOneByTableid(oldBiz.getTableId());
      /*  //将任务表保存至历史表中
        this.copyHistoryTaskBiz(oldBiz, UUID.randomUUID().toString());*/
        //将项目表保存至历史表中
        this.copyHistoryProject(UUID.randomUUID().toString(), oldProject);
        this.taskResouceService.saveCheckMessage(message, oldBiz.getId());
    }

    private TskTaskBiz copyNewTaskBiz(TskTaskBiz biz, String tableId) {
        TskTaskBiz newbiz = new TskTaskBiz();
        BeanUtils.copyProperties(biz, newbiz);
        newbiz.setTableId(tableId);
        newbiz.setId(UUID.randomUUID().toString());
        newbiz.setIsDel(null);
        this.taskBizRepository.save(newbiz);
        return newbiz;
    }

  /*  private TskTaskBizHistory copyHistoryTaskBiz(TskTaskBiz biz, String newbizId) {
        TskTaskBizHistory history = new TskTaskBizHistory();
        BeanUtils.copyProperties(biz, history);
        history.setNewid(newbizId);
        this.historyRepository.save(history);
        return history;
    }*/

    private Map<String, String> copyData(String oldTableName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String sxff = sdf.format(new Date());
        String[] tableNames = oldTableName.split("_");
        String newTableName = "";
        for (int i = 0; i < tableNames.length; i++) {
            if (i != tableNames.length - 1) {
                newTableName += tableNames[i] + "_";
            } else {
                newTableName += sxff;
            }
        }
        String createTable = "select * into " + newTableName + " from " + oldTableName;
        this.jdbcTemplate.execute(createTable);
        //更新数据主键
        String idSql = "select f_id from " + newTableName;
        List<Map<String, Object>> idList = this.jdbcTemplate.queryForList(idSql);
        Map<String, String> result = new HashMap<>();
        String updateIdSql = "";
        for (int i = 0; i < idList.size(); i++) {
            String oldId = idList.get(i).get("f_id").toString();
            String newId = UUID.randomUUID().toString();
            updateIdSql += "update " + newTableName + " set f_id = '" + newId + "' where f_id = '" + oldId + "';";
            result.put(oldId, newId);
        }
        this.jdbcTemplate.execute(updateIdSql);
        result.put("tableName", newTableName);
        return result;
    }

    private TbtskObjectinfo copyObjectInfo(TbtskObjectinfo old, String tableName) {
        TbtskObjectinfo data = new TbtskObjectinfo();
        BeanUtils.copyProperties(old, data);
        String id = UUID.randomUUID().toString();
        data.setfId(id);
        data.setfTablename(tableName);
        this.objectinfoRepository.save(data);
        return data;
    }

    @Override
    public TbBizProjectHistory copyHistoryProject(String newProjectId, TaskBizProject oldProject) {
        TbBizProjectHistory data = new TbBizProjectHistory();
        BeanUtils.copyProperties(oldProject, data);
        data.setNewid(newProjectId);
        this.projectHistoryRepository.save(data);
        return data;
    }

    @Override
    public TaskBizProject copyProject(TaskBizProject oldProject) {
        TaskBizProject data = new TaskBizProject();
        BeanUtils.copyProperties(oldProject, data);
        data.setId(UUID.randomUUID().toString());
        this.projectRepository.save(data);
        return data;
    }

    private TaskBizProject copyProject(String checkId,
                                     String newBizId, String newTableId, String checkStatus, TaskBizProject old) {
        TaskBizProject data = new TaskBizProject();
        BeanUtils.copyProperties(old, data);
        String newId = UUID.randomUUID().toString();
        data.setId(newId);
        data.setSubmitStatus("0");//上交状态还原
        data.setCheckId(checkId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        data.setCheckTime(sdf.format(new Date()));
        data.setCheckStatus(checkStatus);//0未核查，1.再办，2：已办，3.回退
        data.setTableid(newTableId);
        data.setBizId(newBizId);
        this.projectRepository.save(data);
//        this.saveCheckMessage(message, newId);
        return data;
    }

    @Override
    public void backLan(String oldBizId, String newBizId, String newProjectId) {
        TskTaskBiz biz = this.taskBizRepository.gwSearchByPK(oldBizId);
        if (null != biz) {
            biz.setIsDel(1);
            this.taskBizRepository.save(biz);
        }

      /*  TskTaskBizHistory bizHistory = this.historyRepository.gwSearchByPK(oldBizId);
        if (null != bizHistory) {
            bizHistory.setNewid(newBizId);
            this.historyRepository.save(bizHistory);
        }*/

        TbBizProjectHistory projectHistory = this.projectHistoryRepository.findByBiz(oldBizId);
        if (projectHistory != null) {
            projectHistory.setNewid(newProjectId);
            this.projectHistoryRepository.save(projectHistory);

            String sql = "delete from tbtsk_task_ntzy_project where f_id in " +
                    "(select f_id from tbtsk_task_ntzy_project_history where f_biz_id = '" + oldBizId + "')";
//            TaskBizProject project = this.projectRepository.gwSearchByPK(projectHistory.getId());
//            if (null != project)
//                this.projectRepository.delete(projectHistory.getId());
            this.jdbcTemplate.execute(sql);
        }

//        TaskBizProject project = this.projectRepository.gwSearchByPKByBizId(oldBizId);
//
//        TaskBizProjectHistory projectHistory = this.projectHistoryRepository.gwSearchByPK(project.getId());
//        projectHistory.setNewid(newProjectId);
//        this.projectHistoryRepository.save(projectHistory);
//
//        this.projectRepository.delete(project);
    }

    @Override
    public void backLanThread(String oldBizId, String newBizId, String newProjectId) {
       /* BackDataThread thread = new BackDataThread(oldBizId, newBizId, newProjectId, this);
        this.threadPoolTaskExecutor.execute(thread);*/
    }

    private Map<String, String> copyFields(List<TbtskFields> fieldList, TbtskObjectinfo newTable) {
        List<TbtskFields> newList = new ArrayList<>();
        Map<String, String> fieldMap = new HashMap<>();
        for (int i = 0; i < fieldList.size(); i++) {
            TbtskFields data = new TbtskFields();
            BeanUtils.copyProperties(fieldList.get(i), data);
            data.setfId(UUID.randomUUID().toString());
            data.setfTableid(newTable.getfId());
            data.setfTablename(newTable.getfTablename());
            newList.add(data);
            fieldMap.put(fieldList.get(i).getfId(), data.getfId());
        }
        if (newList.size() > 0) {
            this.fieldsRepository.gwAccessSelective(newList);
        }
        return fieldMap;
    }

    private void copyUserBiz(String oldBizId, String newBizId) {
        List<UserBiz2> oldList = this.userBiz2Repository.findByBizId(oldBizId);
        List<UserBiz2> newList = new ArrayList<>();
        for (int i = 0; i < oldList.size(); i++) {
            UserBiz2 data = new UserBiz2();
            BeanUtils.copyProperties(oldList.get(i), data);
            data.setId(UUID.randomUUID().toString());
            data.setBizId(newBizId);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.userBiz2Repository.gwAccessSelective(newList);
        }
    }

    private void copyGroup(String oldTableName, Map<String, String> fieldMap, String newTableName) {
        List<TbtskGroup> groupList = this.groupRepository.findByFTablename(oldTableName);
        List<TbtskGroup> newList = new ArrayList<>();
        for (int i = 0; i < groupList.size(); i++) {
            TbtskGroup data = new TbtskGroup();
            BeanUtils.copyProperties(groupList.get(i), data);
            String newFieldId = fieldMap.get(groupList.get(i).getfFieldid());
            data.setfId(UUID.randomUUID().toString());
            data.setfTablename(newTableName);
            data.setfFieldid(newFieldId);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.groupRepository.gwAccessSelective(newList);
        }
    }

    private void copyMedia(Map<String, String> dataMap) {
        List<String> dataIdList = new ArrayList<>();
        for (String key : dataMap.keySet()) {
            dataIdList.add(key);
        }
        List<AppMedia> mediaList = this.appMediaRepository.queryByGalleryids(dataIdList);
        List<AppMedia> newList = new ArrayList<>();
        for (int i = 0; i < mediaList.size(); i++) {
            AppMedia data = new AppMedia();
            BeanUtils.copyProperties(mediaList.get(i), data);
            data.setId(UUID.randomUUID().toString());
            data.setGalleryid(dataMap.get(mediaList.get(i).getGalleryid()));
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.appMediaRepository.gwAccessSelective(newList);
        }
    }

    private void copyArea(String oldBizId, String newBizId) {
        List<TskRightArea> oldList = this.TskRightAreaRepository.findByTaskId(oldBizId);
        List<TskRightArea> newList = new ArrayList<>();
        for (int i = 0; i < oldList.size(); i++) {
            TskRightArea data = new TskRightArea();
            BeanUtils.copyProperties(oldList.get(i), data);
            data.setId(UUID.randomUUID().toString());
            data.setTaskId(newBizId);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.TskRightAreaRepository.gwAccessSelective(newList);
        }
    }

    @Override
    public void copyStatistics(String oldProjectId, String newProjectId, String newTableid, String newTableName) {
      /*  List<ProjectStatistic2> oldList = this.statisticRepository.findByProject(oldProjectId);
        List<ProjectStatistic2> newList = new ArrayList<>();
        for (int i = 0; i < oldList.size(); i++) {
            ProjectStatistic2 data = new ProjectStatistic2();
            BeanUtils.copyProperties(oldList.get(i), data);
            data.setF_id(UUID.randomUUID().toString());
            data.setF_projectid(newProjectId);
            data.setF_tableid(newTableid);
            data.setF_tablename(newTableName);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.statisticRepository.save(newList);
        }*/
    }

    private void copyAssign(String oldBizid, Map<String, String> dataMap) {
        List<String> dataIdList = new ArrayList<>();
        for (String key : dataMap.keySet()) {
            dataIdList.add(key);
        }
        List<TskAssignRecord> list = this.assignRecordRepository.findByTaskIdAndDataIds(oldBizid,dataIdList);
        List<TskAssignRecord> newList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            TskAssignRecord data = new TskAssignRecord();
            BeanUtils.copyProperties(list.get(i), data);
            data.setId(UUID.randomUUID().toString());
            data.setDataId(dataMap.get(list.get(i).getDataId()));
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.assignRecordRepository.gwAccessSelective(newList);
        }
    }

    public boolean writeTxtData(List<String> result) throws Exception{
        boolean flag = false;
        String fileName = result.get(0);
        BufferedWriter out = null;
        try {
            if (result != null && !result.isEmpty()) {
                fileName += "_" + System.currentTimeMillis() + ".txt";
                File pathFile = new File(this.submitDir);
                if (!pathFile.exists()) {
                    pathFile.mkdirs();
                }
                String relFilePath = this.submitDir + File.separator + fileName;
                File file = new File(relFilePath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "GBK"));
                for (String info : result) {
                    out.write(info);
                    out.newLine();
                }
                flag = true;
            }
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return flag;
        }
    }

    private String createDB(TbtskObjectinfo newTable, TskTaskBiz newBiz) {
        TskTaskBiz task = new TskTaskBiz();
        TbtskObjectinfo table = new TbtskObjectinfo();
        BeanUtils.copyProperties(newBiz, task);
        BeanUtils.copyProperties(newTable, table);
        Connection conn = null;
        Statement statement = null;
        String dbUrl = "";
        try {
            // 01.先根据 taskids 生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = uploadDir + File.separator + fileName;
            SqlliteConnTool tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();

            if(table.getfTableversion() != null && table.getfTableversion() == 1){//历史数据
                // 生产表信息和字段信息
                TaskDBUtils.createInfo(tskTaskBizService, table, task, statement,null);

                // 生成图斑表
                TaskDBUtils.createTable(tskTaskBizService, table, task,statement);

            }else{
                // 生产表信息和字段信息
                TaskDBUtils.createInfo(tskTaskBizService, table, task, statement,null);

                // 生成图斑表
                TaskDBUtils.createTable(tskTaskBizService, table,task, statement);
            }

            // 关闭连接
            tool.closeAll(conn, statement, null);

            // 上传db包到oss上
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", newBiz.getUserId(), date.toString());
            dbUrl = ossOperatorService.sendObject2Oss(key, new File(filePath));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return dbUrl;
    }

}
