package com.geoway.landteam.landcloud.service.datacq.impl;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.OutworkProofService;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by licong on 2021/5/26.
 */
@Service
public class OutworkProofServiceImpl implements OutworkProofService {
   /* @Value("#{imeSettings['project.applicationType']}")*/
    @Value("${project.applicationType}")
    protected String applicationType;
   /* @Value("#{imeSettings['project.mediaUrlPrefix']}")*/
    @Value("${project.mediaUrlPrefix}")
    protected String mediaUrlPrefix;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    DataBizService dataBizService;

    @Autowired
    AppMediaRepository appMediaDao;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private AppMediaService mediaService;

    @Override
    public List<AppMedia> getMediaList(String galleryId) {
        List<AppMedia> appMedias = appMediaDao.queryByGid(galleryId);
        List<AppMedia> result = this.mediaService.getAppMedia(appMedias);
        return result;
    }
    @Override
    public List<AppMedia> getMediaList(String galleryId,String bizid) {
        List<AppMedia> appMedias = appMediaDao.queryByGalleryidAndBizid(galleryId,bizid);
        List<AppMedia> result = this.mediaService.getAppMedia(appMedias);
        return result;
    }
    @Override
    public List<AppMedia> getMediaList(List<String> galleryIds) {
        List<AppMedia> appMedias = appMediaDao.queryByGalleryids(galleryIds);
        List<AppMedia> result = this.mediaService.getAppMedia(appMedias);
        return result;
    }

    @Override
    public List<AppMedia> getMediaByBound(String wkt, Integer buffer) throws Exception {
        Geometry bound = WKTUtil.wktToGeom(wkt);
        if (null != buffer) {
            Double distance = buffer * 180 / Math.PI / 6371000;
            bound = bound.buffer(distance);
        }
//        String sql = "select * from tb_app_media where st_contains(ST_GeomFromText('" + WKTUtil.geomToWkt(bound) +
//                "'), st_geomfromtext('POINT(' || cast(f_lon as VARCHAR) || ' ' || cast(f_lat as VARCHAR) || ')'))";
//        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        List<AppMedia> appMedias = this.appMediaDao.queryByWkt(WKTUtil.geomToWkt(bound));
        List<AppMedia> result = this.mediaService.getAppMedia(appMedias);
        return result;
    }
}
