package com.geoway.landteam.landcloud.service.datacq.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.dto.BaseResponse;
import com.geoway.landteam.landcloud.common.util.PhoneNumberUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.*;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiDataType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskAutoimportRel;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectRepository;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.repository.pub.TbtskAutoimportRelRepository;
import com.geoway.landteam.landcloud.servface.datacq.BackDataService;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportZbphDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.*;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;
import com.geoway.landteam.landcloud.service.thirddata.utils.EsriGeoJsonUtil;

/**
 * 对第三方提供数据接口
 * Created by Walt Chiang(JY)) on 2020/8/24.
 */
@Service
public class TaskResouceServiceImpl implements TaskResouceService {
    private GiLoger logger = GwLoger.getLoger(TaskResouceServiceImpl.class);

   /* @Value("#{imeSettings['project.tempDir']}")*/
    @Value("${project.tempDir}")
    private String tempDir;
   /* @Value("#{imeSettings['project.import.media']}")*/
    @Value("${project.import.media}")
    private String mediaDir;
  /*  @Value("#{imeSettings['project.import.resultsDir']}")*/
    @Value("${project.import.resultsDir}")
    private String resultsDir;
  /*  @Value("#{imeSettings['project.applicationType']}")*/
    @Value("${project.applicationType}")
    private String applicationType;
   /* @Value("#{imeSettings['uis.LandPlatform.useridPrefix']}")*/
    @Value("${uis.LandPlatform.useridPrefix:}")
    private Long useridPrefix;
  /*  @Value("#{imeSettings['project.uploadDir']}")*/
    @Value("${project.uploadDir}")
    protected String uploadDir;
   /* @Value("#{imeSettings['project.submitDir']}")*/
    @Value("${project.submitDir}")
    protected String submitDir;

    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskFieldsService tbtskFieldsService;
    @Autowired
    private AppMediaRepository appMediaDao;
    @Autowired
    private TskTaskBizRepository bizDao;
    @Autowired
    private ExportDataService exportDataService;
    @Autowired
    private ExportTxtService exportTxtService;
    @Autowired
    private TbtskAutoimportRelRepository tbtskAutoimportRelDao;
    @Autowired
    private DataBizService dataBizService;
    @Autowired
    private TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    private RegionRepository regionRepository;
    @Autowired
    private LandUserRepository userRepository;
    @Autowired
    private TbBizProjectRepository projectRepository;
    @Autowired
    private BackDataService backDataService;
    @Autowired
    private ExportZbphDataService zbphDataService;
   /* @Autowired
    private SsnydService ssnydService;*/
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    private LogService logService;
    /*@Autowired
    private UpdateOracleService updateOracleService;*/
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TbtskObjectinfoRepository tbObjectinfoRepository;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    RegionService regionService;

    @Override
    public BaseResponse getResult(String namespace, String apiname, String bjbh) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            TbtskApplicationApi applicationApi=tbtskApplicationApiDao.queryApplicationApi(namespace,apiname);
            if(applicationApi==null){
                return  BaseResponse.buildFailuaResponse("接口存在");
            }
            TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
            String tableName = table.getfTablename();
            String[] bjbhArray = bjbh.split(",");
            String inString = "";
            for (int i = 0; i < bjbhArray.length; i++) {
                if (i == bjbhArray.length -1) {
                    inString += "'" + bjbhArray[i] + "'";
                } else {
                    inString += "'" + bjbhArray[i] + "',";
                }
            }
            String sql = "select *,ST_AsGeoJSON(f_shape) as f_geojson from " + tableName + " where f_bjbh in (" + inString + ")";
            if(StringUtils.isNotEmpty(applicationApi.getSqlfilterstr()))
                sql +=" and "+applicationApi.getSqlfilterstr();
            List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
            if (dataList.isEmpty()) {
                baseResponse.setData("未找到报建编号为" + bjbh + "的数据");
                return baseResponse;
            }
            JSONArray result = new JSONArray();
            for (int i = 0; i < dataList.size(); i++) {
                Map<String, Object> data = dataList.get(i);
//                    String geojson = (String) data.get("f_geojson");
                JSONObject geojson = this.createGeojson(applicationApi.getTableid(), data);
                JSONObject obj = new JSONObject();
                obj.put("bjbh", data.get("f_bjbh"));
                obj.put("feature", geojson);
                result.add(obj);
            }
            baseResponse.setData(result);
            return baseResponse;
        } catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse(e);
        }
    }

    @Override
    @Transactional
    public void saveTransaction(JSONObject obj, String usetype) throws Exception {
        TaskBizProject project;
        String wyid = obj.getString("wyid");
        String ywlx = obj.getString("ywlx");
        String xmbh = obj.getString("xmbh");
        String spzt = obj.getString("spzt");
        String bslx = obj.getString("bslx");
        String wyuserid = obj.getString("sendto");
        String sfzjbnt = obj.getString("sfzjbnt");
        if("5".equals(spzt)){
            //不占基本农田的删除存入历史表，占基本农田标记删除
            if(StringUtils.isEmpty(sfzjbnt) || "0".equals(sfzjbnt)){
                //不占基本农田的可能会没有外业，外业id由苍穹生成不能用于查找
                project = projectRepository.findByXmbh(xmbh);
                if(project == null) return;
                this.backDataService.copyHistoryProject(project.getId(),project);
                projectRepository.delete(project);
            }else{
                project = this.projectRepository.findOneByBizId(obj.getString("wyid"));
                if (null == project) {
                    throw new Exception("未找到要删除项目");
                }
                project.setCheckStatus("5");
                tskTaskBizService.delByTaskId(project.getBizId());
                projectRepository.save(project);
            }
            return;
        }
        if (!StringUtils.isEmpty(wyuserid)) {
//                if (!obj.containsKey("space") || StringUtils.isEmpty(obj.getString("space"))) {
//                    return BaseResponse.buildFailuaResponse("space不能为空");
//                }
            if ("1".equals(sfzjbnt)) {
                this.updateProject(obj);
            } else {
                this.updateCqData(obj);
            }
            this.assign(obj);
        } else if (ProjectStatus.status4.equals(spzt)) {//设施农用地取得用地，更新数据并推送部设施农用地系统
            if (!StringUtils.isEmpty(sfzjbnt) && "1".equals(sfzjbnt) && !StringUtils.isEmpty(wyid)) {
                this.updateProject(obj);
            } else {
                this.updateCqData(obj);
            }
            this.exportTxtService.updateJbnt(obj.toString(), InterfaceType.sendUpdateSsnyd);
        } else if (!StringUtils.isEmpty(sfzjbnt) && "1".equals(sfzjbnt) && !StringUtils.isEmpty(wyid)) {
            //我们传给苍穹的数据
            if (ProjectStatus.status3.equals(obj.getString("spzt"))) {
                //信息推送至外网
                this.exportTxtService.reviewProjectLan(wyid, obj.toString(), xmbh, spzt);
                //回退流程
                this.backDataService.reviewProjectLan(wyid, obj.toString());
            } else {//占用基本农田数据没有保存苍穹推送过来的过程数据，需按bslx保存历史数据，并修改外网数据
//                    this.saveCheckMessage(obj.toString(), wyid);
                this.updateProject(obj);
            }
        } else {
            this.updateCqData(obj);
        }
//        延迟更新中间库
//        解决上面事务中mybatis和hibernate混用获取不到刚插入的数据问题
        if("0".equalsIgnoreCase(ywlx)||"2".equalsIgnoreCase(ywlx)||"4".equalsIgnoreCase(ywlx)) {
            Thread thread = new Thread(()->{
                try {
                    Thread.sleep(5000);
                    TaskBizProject pro = this.getProjectByXmbh(xmbh);
                    String newId = pro.getId();
                    this.logService.saveLog(LogType.saveCqData, "更新中间库：" + "xmbh:" + xmbh + "; bslx:" + bslx + "; spzt:" + spzt  + "; newid:" + newId + "; type:" + ywlx);
                   /* this.updateOracleService.updateOne(pro.getUsetype(), newId, xmbh);*/
                }catch (Exception e){
                    e.printStackTrace();
                    this.logService.saveLog(LogType.saveCqData, "中间库更新失败：" + xmbh + ";message:" + e.getMessage());
                }
            });
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter() {
                @Override
                public void afterCommit() {
                    threadPoolTaskExecutor.execute(thread);
                }
            });
        }
    }

    @Override
    public String createResultDataFile(String namespace, String apiname, String bjbhs) throws IOException {
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            return null;
        }
        String tempPath = this.tempDir + File.separator + namespace;
        File file = new File(tempPath);
        if (!file.exists())
            file.mkdirs();

        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String[] bjbhArray = bjbhs.split(",");
        String inbjbhs = "";
        for (int i = 0; i < bjbhArray.length; i++) {
            inbjbhs += "'" + bjbhArray[i] + "'";
            if (i != bjbhArray.length - 1) {
                inbjbhs += ",";
            }
            File tempFile = new File(tempPath + File.separator + bjbhArray[i]);
            if (!file.exists())
                tempFile.mkdirs();
            String pdfPath = this.resultsDir + File.separator + bjbhArray[i] + ".pdf";
            File pdfFile = new File(pdfPath);
            if (pdfFile.exists()) {
                String newPdfPath = tempPath + File.separator + bjbhArray[i] + File.separator + bjbhArray[i] + ".pdf";
                FileUtil.copyFile(pdfPath, newPdfPath);
            }
        }
        String sql = "select f_id, f_bjbh from " + tableName + " where f_bjbh in (" + inbjbhs + ");";
        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        Map<String, String> map = new HashMap<>();
        List<String> idList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> temp = list.get(i);
            String f_id = (String) temp.get("f_id");
            String f_bjbh = (String) temp.get("f_bjbh");
            map.put(f_id, f_bjbh);
            idList.add(f_id);
        }
        List<AppMedia> mediaList = this.appMediaDao.queryByGalleryids(idList);
        for (int i = 0; i < mediaList.size(); i++) {
            AppMedia media = mediaList.get(i);
            String mediaPath = media.getServerpath();
            String time = media.getTime();
            String galleryid = media.getGalleryid();
            Integer type = media.getType();
            String bjbh = map.get(galleryid);

            String mediaFile = this.mediaDir + File.separator + mediaPath;
            String newPath = tempPath + File.separator + bjbh + File.separator + time;
            if (type == 1) {
                newPath += ".jpg";
            } else if (type == 2) {
                newPath += ".mp4";
            } else if (type == 3) {
                newPath += ".mp3";
            } else if (type == 4) {
                newPath += ".osgb";
            }
            FileUtil.copyFile(mediaFile, newPath);
        }
        ZipUtils utils = new ZipUtils();
        utils.doZip(tempPath);
        String zipPath = this.tempDir + File.separator + "bysxz.zip";
        ExportFileUtil.deleteFileAndDir(new File(tempPath));
        return zipPath;
    }

    @Override
    public void importBysxzData(String json) throws Exception{
        String namespace = ApiNameType.bysxzImport[0];
        String apiname = ApiNameType.bysxzImport[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("获取关联配置失败");
        }
        if (json.contains("\\")) {
            json = json.replace("\\", "");
//            json = json.substring(1, json.length());
//            json = json.substring(0, json.length() - 1);
        }
//        JSONArray array = JSONArray.parseArray(json);
//        String ids = "";
//        for (int j = 0; j < array.size(); j++) {
            JSONObject object = JSON.parseObject(json);
            if (!PhoneNumberUtil.isMobile(object.getString("gtdydh"))) {
                throw new Exception("手机号不合法");
            }
            String fid = this.saveData(object, applicationApi, ApiDataType.Bysxz);
            String ids = "";
            if (!"".equals(fid)) {
//                if (ids.equals("")) {
//                    ids += fid;
//                } else {
//                    ids += "," + fid;
//                }
                 ids = fid;
            }
//        }
        if (!"".equals(ids)) {
            this.exportData(applicationApi, ids);
        }
    }

    @Override
    public String importReportData(String json) throws Exception {
        String namespace = ApiNameType.report[0];
        String apiname = ApiNameType.report[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("获取关联配置失败");
        }
        JSONObject object = JSONArray.parseObject(json);
        return   this.saveData(object, applicationApi, ApiDataType.report);
    }


    @Override
    public List<Map> selectReportByIDs(List<String> ids) throws Exception {
        String namespace = ApiNameType.report[0];
        String apiname = ApiNameType.report[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("获取关联配置失败");
        }
        TbtskObjectinfo tbtskObjectinfo =tbObjectinfoRepository.getObjectByTableId(applicationApi.getTableid());
        if (tbtskObjectinfo == null) {
            throw new Exception("获取关联table失败");
        }
        List<Map> result=new ArrayList<Map>();
        String idStr="";
        for (int i=0;i<ids.size();i++){
            if(ids.size()==i+1){
                idStr=idStr+"'"+ids.get(i)+"'";
            }else {
                idStr=idStr+"'"+ids.get(i)+"',";
            }
        }
        String sqlStr="SELECT r.f_id,r.f_status,r.f_createtime,r.f_committime,array_to_string(array_agg(u.f_rname),',') as usrs  from (SELECT tb.f_id, tar.f_assignto,tb.f_status,tb.f_createtime,tb.f_committime from "
                + tbtskObjectinfo.getfTablename()
                +" as tb ,tbtsk_assign_record AS tar WHERE (tb.f_id in ( "
                +idStr
                +" )) AND tar.f_dataid = tb.f_id) AS r LEFT JOIN tbsys_user as u on  cast(u.f_userid as VARCHAR) = r.f_assignto GROUP BY r.f_id,r.f_status,r.f_createtime,r.f_committime";

        result=dataBizService.queryDataBySql(sqlStr);
//        for (int j = 0; j < array.size(); j++) {
//            JSONObject object = array.getJSONObject(j);
        return   result;
//            this.zbphDataService.exportZbphData(object);
//        }
    }

    @Override
    public Map getReportByID(String id) throws Exception{
        String namespace = ApiNameType.report[0];
        String apiname = ApiNameType.report[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("获取关联配置失败");
        }
        TbtskObjectinfo tbtskObjectinfo =tbObjectinfoRepository.getObjectByTableId(applicationApi.getTableid());
        if (tbtskObjectinfo == null) {
            throw new Exception("获取关联table失败");
        }

        Map result=dataBizService.selectByID(tbtskObjectinfo.getfTablename(),applicationApi.getPrimary(),"'"+id+"'");
        return   result;
    }

    @Override
    public void updateCqData(JSONObject obj) throws Exception{
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.datasync[0], ApiNameType.datasync[1]);
        if (applicationApi == null) {
            throw new Exception("该接口不可使用");
        }
        String tablename = applicationApi.getTableid();
        Map<String, String> fieldsMap = this.getFiledMap(tablename);

        String data = obj.getString("data");
        JSONObject dataObject = JSONObject.parseObject(data);
        dataObject.keySet().forEach(key -> {
            obj.put(key, dataObject.get(key));
        });

        String xmbh = obj.getString("xmbh");
        String submission = obj.getString("bslx");
        Map<String, Object> result = new HashMap<>();
        fieldsMap.keySet().forEach(key -> {
            Object value = obj.get(fieldsMap.get(key));
            if (value != null) {
                result.put(key, value);
            }
        });
        result.put("f_data", data);
        boolean flag = true;
        if (obj.containsKey("space") && !StringUtils.isEmpty(obj.getString("space"))) {
            this.processGeodata(obj, result);
            flag = false;
        }

        TaskBizProject oldProject = this.projectRepository.findByXmbh(xmbh);
        String newProjectId = UUID.randomUUID().toString();
        String lastProjectId = newProjectId;
        if (null != oldProject && !submission.equals(oldProject.getSubmission())) {//保存历史，新增数据
            this.backDataService.copyHistoryProject(newProjectId, oldProject);
            result.put("f_id", newProjectId);
            if (flag) {//space为空，不更新shp数据
             /*   result.put("f_shape", oldProject.getBoundary());
                result.put("f_boundary", oldProject.getBoundary());
                result.put("f_red_line_shape", oldProject.getRed_line_boundary());
                result.put("f_red_line_boundary", oldProject.getRed_line_boundary());
                result.put("f_destory_gzc_shape", oldProject.getDestory_gzc_boundary());
                result.put("f_destory_gzc_boundary", oldProject.getDestory_gzc_boundary());
                result.put("f_destory_jbnt_shape", oldProject.getDestory_jbnt_boundary());
                result.put("f_destory_jbnt_boundary", oldProject.getDestory_jbnt_boundary());*/
//                dataBizService.insertData(tablename, result, null);
            } else {
//                dataBizService.insertData(tablename, result, "f_shape");
            }
            dataBizService.insertData(tablename, result, "f_shape");
            this.projectRepository.delete(oldProject);
        } else if (null == oldProject) {
            result.put("f_id", newProjectId);
            dataBizService.insertData(tablename, result, "f_shape");
        } else {
            lastProjectId = oldProject.getId();
            dataBizService.updateData(tablename, result, "f_xmbh='" + obj.getString("xmbh") + "'");
        }
      /*  if ("4".equals(obj.getString("spzt")) && !this.applicationType.equals("lan")) {//推送取得用地阶段设施农用地消息
            this.ssnydService.sendMessageByid(lastProjectId);
        }*/
    }

    /**
     * 苍穹接口中，处理space中的shp数据
     * @param obj
     * @param result
     * @throws Exception
     */
    private void processGeodata(JSONObject obj, Map<String, Object> result) throws Exception {
        JSONArray array = obj.getJSONArray("space");
        for (int i = 0; i < array.size(); i++) {
            String space = array.getJSONObject(i).getString("json");
            Geometry geometry =GeoUtils.geojson2Geom(space);
            String bound = geometry.toText();
            String wkt = WKTUtil.geomToWkt(geometry);
            if ("xmfw".equals(array.getJSONObject(i).getString("fwlx")) || "xmqydgdzb".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_shape", wkt);
                result.put("f_boundary", bound);
            } else if ("lsydfw".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_red_line_shape", wkt);
                result.put("f_red_line_boundary", bound);
            } else if ("phgdgzczb".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_destory_gzc_shape", wkt);
                result.put("f_destory_gzc_boundary", bound);
            } else if ("phjbntdkgdzb".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_destory_jbnt_shape", wkt);
                result.put("f_destory_jbnt_boundary", bound);
            }
        }
    }

    /**
     * 步移式选址构建geojson
     * @param tableid
     * @param data
     * @return
     */
    private JSONObject createGeojson(String tableid, Map<String, Object> data) {
        String geojson = (String) data.get("f_geojson");
        JSONObject result = new JSONObject();
        JSONObject obj = JSONObject.parseObject(geojson);
        result.put("geometry", obj);
        JSONObject properties = new JSONObject();
        List<TbtskFields> fieldList = this.tbtskFieldsService.getAllFieldsByTableID(tableid);
        for (int i = 0; i < fieldList.size(); i++) {
            TbtskFields field = fieldList.get(i);
            if (field.getfFieldInnerOuterSys()<4) {
                String fieldName = field.getfFieldname();
                properties.put(fieldName, data.get(fieldName));
            }
        }
        String submitUser = this.getSubmitUser((String) data.get("f_id"));
        properties.put("f_submitUser", submitUser);
        result.put("properties", properties);
        result.put("type", "Feature");
        return  result;
    }

    /**
     * 步移式选址获取上传用户，该用户内外网得保持一致
     * @param dataid
     * @return
     */
    private String getSubmitUser(String dataid) {
        String sql = "select f_rname from tbsys_user where f_userid = (select cast(f_assignto as INTEGER)" +
                " from tbtsk_assign_record where f_dataid = '" + dataid + "'  and f_status = '1' limit 1)";
        try {
            Map<String, Object> map = this.jdbcTemplate.queryForMap(sql);
            return (String) map.get("f_rname");
        } catch (Exception e) {
            return "";
        }
    }

    @Override
    public String saveData(JSONObject object, TbtskApplicationApi applicationApi, Integer datatype) throws Exception {
        String tableid = applicationApi.getTableid();
        Map<String, String> mapping = this.getFiledMap(tableid);

        TbtskObjectinfo table = tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(applicationApi.getTableid());
        String primary = applicationApi.getPrimary();
        HashMap<String, Object> map = new HashMap<>();
        Map data = null;
        if (!StringUtils.isEmpty(primary)) {
//            data = dataBizService.selectByID(table.getfTablename(), primary, "'" + object.getString(mapping.get(primary)) + "'");
            String[] primarys = primary.split(",");
            String sql = "select * from " + table.getfTablename() + " where 1=1 ";
            for (int i = 0; i < primarys.length; i++) {
                sql += " and " + primarys[i] + " = '" + object.getString(mapping.get(primarys[i])) + "'";
            }
            List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
            if (list != null && !list.isEmpty())
                data = list.get(0);
        }
        String f_id = "";
        //插入数据
        this.insertData(object, mapping, allFields, map, data);
        if (data == null){
            if (map.containsKey("tbid") && map.get("tbid") !=null && !StringUtils.isEmpty(map.get("tbid").toString())) {
                f_id = map.get("tbid").toString();
            }else if (map.containsKey("f_id") && map.get("f_id") !=null && !StringUtils.isEmpty(map.get("f_id").toString())) {
                f_id = map.get("f_id").toString();
            } else {
                f_id = UUID.randomUUID().toString();
            }
        }else{
            f_id = (String) data.get("f_id");
            if (object.containsKey("sendto") && !StringUtils.isEmpty(object.getString("sendto")) && mapping.containsKey("f_sendto")) {
                map.put("f_sendto", object.getString("sendto"));
            }
        }

        Region region = null;
        if(ApiDataType.Bysxz == datatype) {//步移式选址行政区划代码处理
            if (object.containsKey("cunName") && !StringUtils.isEmpty(object.getString("cunName"))) {
                region = this.getRegionByName(object.getString("cunName"));
            }
            map.put("f_userid", applicationApi.getSqlfilterstr());
        } else if (ApiDataType.SSNYD == datatype){//object.containsKey("space") && !StringUtils.isEmpty(object.getString("space"))
            region = this.getRegionByName(object.getString("qxmc"));
            JSONArray array = object.getJSONArray("space");
            for (int i = 0; i < array.size(); i++) {//这里没有处理谷歌地图偏移问题
                JSONObject temp = array.getJSONObject(i);
                String type = temp.getString("fwlx");
                if (!"xmfw".equals(type) && !"xmqydgdzb".equals(type)) {//这里会传递多个geometry，只选取项目边界作为图斑
                    continue;
                }
                String space = array.getJSONObject(i).getString("json");
                Geometry geometry = GeoUtils.geojson2Geom(space);
                String wkt = WKTUtil.geomToWkt(geometry);
                map.put("f_shape", wkt);
                map.put("f_shape1", wkt);
                Point point = geometry.getCentroid();
                map.put("f_lat", point.getY());
                map.put("f_lon", point.getX());
            }
        } else if (ApiDataType.Jcjg == datatype) {//这里没有处理谷歌地图偏移问题
            region = this.getRegionByName(object.getString("qxmc"));
            map.put("f_shape", object.getString("shape"));
            map.put("f_shape1", object.getString("shape"));
            Geometry geometry = WKTUtil.wktToGeom(object.getString("shape").replace("SRID=4490;",""));
            Point point = geometry.getCentroid();
            map.put("f_lat", point.getY());
            map.put("f_lon", point.getX());
            map.put("f_sendto",object.get("sendto"));
            map.put("f_status",object.get("status"));
            map.put("f_xhzg",object.get("ghzt"));
        }else if (ApiDataType.Phjg == datatype) {//这里没有处理谷歌地图偏移问题
            region = StringUtils.isNotBlank(object.getString("xzqdm")) ? this.getRegionByCode(object.getString("xzqdm")) : this.getRegionByName(object.getString("xzqmc"));
            map.put("f_shape", object.getString("shape"));
            map.put("f_shape1", object.getString("shape"));
            Geometry geometry = WKTUtil.wktToGeom(object.getString("shape").replace("SRID=4490;",""));
            Point point = geometry.getCentroid();
            map.put("f_lat", point.getY());
            map.put("f_lon", point.getX());
        } else if (ApiDataType.Xzgd == datatype) {//新增耕地
            this.saveXzgdGeometry(object, map, "coord1", "f_shape");
            this.saveXzgdGeometry(object, map, "coord2", "f_shape2");
            this.saveXzgdMessage(map);
            this.zbphDataService.exportZbphData(map);
        }else if (ApiDataType.Gtzz == datatype) {
        }
        if (null == region && !StringUtils.isEmpty(object.getString("f_shape"))) {//通用，通过shape计算图形位置
            Geometry geometry = WKTUtil.wktToGeom(object.getString("f_shape").replace("SRID=4490;",""));
            String xzqdmsys = this.getXzqdmSys(geometry);
            map.put("f_xzqdmsys", xzqdmsys);
            if (!StringUtils.isEmpty(xzqdmsys)) {
                region = this.regionRepository.queryRegionByCode(xzqdmsys.substring(0, 6));
                map.put("f_xzqmc1", region.getName());
                map.put("f_xzqdm", region.getCode());
            }
        } else if (null != region) {//仅插入区县数据
            map.put("f_xzqmc1", region.getName());
            if (ApiDataType.Jcjg == datatype || ApiDataType.Bysxz == datatype){//监测监管没有f_xzqmc字段
                map.put("f_xzqmc", region.getName());
            }
            map.put("f_xzqdm", region.getCode());
            map.put("f_xzqdmsys", region.getCode() + "000000");
        }

        if (data == null) {
            map.put("f_id", f_id);
            map.put("f_status", "1");
            map.put("f_createtime", System.currentTimeMillis() + "");
            dataBizService.insertDataByTimeStamp(table.getfTablename(), map, "f_shape");
        } else {
            String where = "";
            if (!StringUtils.isEmpty(primary)) {
                String[] primarys = primary.split(",");
                where = " 1=1 ";
                for (int i = 0; i < primarys.length; i++) {
                    where += " and " + primarys[i] + " = '" + object.getString(mapping.get(primarys[i])) + "'";
                }
            }
            dataBizService.updateData(table.getfTablename(), map, where);
        }
        return f_id;
    }

    private Region getRegionByCode(String xzqdm) {
        return this.regionRepository.queryRegionByCode(xzqdm);
       /* List<Region> regionList = this.regionRepository.queryRegionByCode(xzqdm);
        if (regionList.isEmpty())
            return null;
        else
            return regionList.get(0);*/
    }

    @Override
//    @Transactional(propagation = Propagation.NESTED)
    public void saveCheckMessage(String message, String bizid) {
        JSONObject object = JSONObject.parseObject(message);
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.datasync[0], ApiNameType.datasync[1]);
        String tablename = applicationApi.getTableid();
       /* List<TbtskAutoimportRel> fields = this.tbtskAutoimportRelDao.getImportTableFields(tablename);*/
        String f_submission = object.getString("bslx");
        String f_check_status = object.getString("spzt");
        String xmbh = object.getString("xmbh");
        String messages = object.getString("message");
        JSONObject data = object.getJSONObject("data");
        data.put("ywid", object.getString("ywid"));
        String update = "update " + tablename  + " set ";
      /*  for (int i = 0; i < fields.size(); i++) {
            TbtskAutoimportRel rel = fields.get(i);
            if (data.containsKey(rel.getImFieldname()) && !StringUtils.isEmpty(data.getString(rel.getImFieldname()))) {
                update += rel.getFieldname() + "= '" + data.getString(rel.getImFieldname()) + "',";
            }
        }*/
        update += "f_data = '" + data.toString() + "',";
        update += "f_check_message = '" + messages + "',";
        if (!StringUtils.isEmpty(f_submission))
            update += "f_submission = '" + f_submission + "',";
        update += "f_check_status = '" + f_check_status + "',";
        update += "f_xmbh = '" + xmbh + "'";
        update += " where f_biz_id = '" + bizid + "'";
        String finalUpdate = update;
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronizationAdapter() {
            @Override
            public void afterCommit() {
                jdbcTemplate.execute(finalUpdate);
            }
        });
//        JSONObject object = JSONObject.parseObject(message);
//        TaskBizProject project = projectRepository.findOneByBizId(bizid);
//        String f_submission = object.getString("bslx");
//        String f_check_status = object.getString("spzt");
//        String xmbh = object.getString("xmbh");
//        String messages = object.getString("message");
//        JSONObject data = object.getJSONObject("data");
//        data.put("ywid", object.getString("ywid"));
//        project.setData(data.toJSONString());
//        if (!StringUtils.isEmpty(f_submission)) {
//            project.setCheckMessage(messages);
//        }
//        project.setCheckStatus(f_check_status);
//        project.setSubmission(f_submission);
//        project.setXmbh(xmbh);
//        projectRepository.save(project);
    }

    private void insertData(JSONObject object, Map<String, String> mapping, List<TbtskFields> allFields, HashMap<String, Object> map, Map data) throws Exception {
        List<String> list = new ArrayList<>();
        allFields.forEach(e->list.add(e.getfFieldname()));
        for (TbtskFields field : allFields) {
            String fieldName = field.getfFieldname();
            String fieldType = field.getfFieldtype();
            Integer outWork = field.getfIsOutwork();
            String type = TskTaskBizDBUtil.getDBType(fieldType);
            Integer nullable ;
            if (null == outWork) {
                nullable = field.getfNullable();
            } else {
                nullable = outWork == 1 ? 1 : field.getfNullable();
            }
            Integer order = field.getfOrder();

            if(mapping.containsKey(fieldName)){
                String str =  mapping.get(fieldName);
                if(StringUtils.isNotEmpty(str)){
                    BysxzUtil.addDatatoMap(map, type, str, fieldName, nullable, order, object);
                    continue;
                }
            }
            if (data == null) {
                if("f_index".equalsIgnoreCase(fieldName)){
                    continue;
                }
                if (fieldName.equals("f_lat") || fieldName.equals("f_lon")) {
                    continue;
                }
                String value = field.getfDefaultvalue();
                if (type.equals(TskTaskBizDBUtil.getDBType("5"))) {//Timestamp特殊处理
                    value = null;
                }
                map.put(fieldName, value);
                BysxzUtil.addDatatoMap(map, type, fieldName, fieldName, nullable, order, object);
            }
        }
    }

    private Region getRegionByName(String name) {
        if (name.startsWith("重庆市")) {
            name = name.split("重庆市")[1];
        }
        name = name.substring(0, 2);
        List<Region> regionList = this.regionRepository.queryByName(name + "%");
        if (regionList.isEmpty())
            return null;
        else
            return regionList.get(0);
    }

    @Override
    public void assign(JSONObject obj) throws Exception {
        String namespace = ApiNameType.assgin[0];
        String apiname = ApiNameType.assgin[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("该接口不可使用");
        }
        //获取配置信息
        String tableid = applicationApi.getTableid();
        Map<String, String> mapping = this.getFiledMap(tableid);
        TbtskObjectinfo table = tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(applicationApi.getTableid());
        String primary = applicationApi.getPrimary();

        String ids = "";
        JSONObject dataObject = obj.getJSONObject("data");
        Long userid = obj.getLong("sendto");
        userid += this.useridPrefix;
        LandUser user = this.userRepository.queryUserById(userid);
        if (user == null) {
            throw new Exception("没有用户id为" + userid + "的用户信息");
        }

        String hasDataSql = "select f_id from " + table.getfTablename() + " where " + primary + "='" + obj.getString(mapping.get(primary)) + "'";
        List<Map<String, Object>> hasDataList = this.jdbcTemplate.queryForList(hasDataSql);
        if (!hasDataList.isEmpty()) {
            //重复下发涉及到外网已下发数据删除问题，暂不处理
//            throw new Exception("ywid为" + obj.getString(mapping.get(primary)) + "的数据已下发，无法重复下发");
        }

        String xmbh = obj.getString("xmbh");
      /*  dataObject.put("sendto", user.getRelatedusers());*/
        dataObject.put("ywid", obj.getString("ywid"));
        dataObject.put("xmbh", xmbh);
        dataObject.put("bslx", obj.getString("bslx"));
        dataObject.put("spzt", obj.getString("spzt"));
//        dataObject.put("space", obj.getJSONArray("space"));
        List<Geometry> geoList = new ArrayList<>();
        if (obj.containsKey("space") && !StringUtils.isEmpty(obj.getString("space"))) {
            geoList = this.getGeo(obj);
        } else {
            geoList = this.getGeoByTabele(xmbh);
        }
        for (int i = 0; i < geoList.size(); i++) {
            Geometry geo = geoList.get(i);
            String fid = this.saveBzyjbntData(dataObject, applicationApi, allFields, table, mapping, geo);
            if (i != 0) {
                ids += ",";
            }
            ids += fid;
        }

        if (!"".equals(ids)) {
            this.exportData(applicationApi, ids);
        }
    }

    @Override
    @Transactional
    public void updateProject(JSONObject obj) throws Exception {
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.datasync[0], ApiNameType.datasync[1]);
        if (applicationApi == null) {
            throw new Exception("该接口不可使用");
        }
        String submission = obj.getString("bslx");
        String bizId = obj.getString("wyid");
        TaskBizProject oldProject = this.projectRepository.findOneByBizId(bizId);
        if (!submission.equals(oldProject.getSubmission()) ){
//                || (submission.equals(oldProject.getSubmission()) && obj.getJSONObject("data").containsKey("bgqk") && "1".equals(obj.getJSONObject("data").getString("bgqk")))) {
            //当bgqk = 1时，为改扩建，这种类型上传的shp是增加的部分，需存历史数据
            this.updateProject(oldProject, obj);
            this.exportTxtService.updateJbnt(obj.toString(), InterfaceType.sendUpdateJbnt);
        } else {
            //更新数据
            this.saveCheckMessage(obj.toString(), obj.getString("wyid"));
            String spzt = obj.getString("spzt");
            if (!spzt.equals(oldProject.getCheckStatus()) && !ProjectStatus.status4.equals(spzt) && this.applicationType.equals("lan")) {//审批状态变化，为4的时候前面已推送
                this.exportTxtService.updateJbnt(obj.toString(), InterfaceType.sendUpdateJbnt);
            }
        }
    }


    @Override
    @Transactional
    public void updateProject(TaskBizProject oldProject, JSONObject obj) throws Exception {
        if (null == oldProject) {
            oldProject = this.projectRepository.findOneByBizId(obj.getString("wyid"));
        }
        if (null == oldProject) {
            return;
        }
        TaskBizProject newProject = this.backDataService.copyProject(oldProject);
        this.backDataService.copyHistoryProject(newProject.getId(), oldProject);

        TbtskObjectinfo objectinfo = this.tbtskObjectinfoService.getObjectbyID(newProject.getTableid());
        this.backDataService.copyStatistics(oldProject.getId(), newProject.getId(), newProject.getTableid(), objectinfo.getfTablename());

        this.projectRepository.delete(oldProject);
        this.saveCheckMessage(obj.toString(), obj.getString("wyid"));

        /*if ("4".equals(obj.getString("spzt")) && !this.applicationType.equals("lan")) {
            this.ssnydService.sendMessageByid(newProject.getId());
        }*/
    }

    @Override
    public boolean hasComplete(String xmbh) {
        String namespace = ApiNameType.assgin[0];
        String apiname = ApiNameType.assgin[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        TbtskObjectinfo table = tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String sql = "select * from " + tableName + " where f_status != '4' and f_xmbh = '" +  xmbh + "'";
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
        if (data.isEmpty()) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public String getLatestYwid(String tableName, String xmbh) throws Exception {
        String sql = "select f_ywid from " + tableName + " where f_xmbh = '" + xmbh + "' order by f_createtime desc limit 1";
        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(sql);
        if (null == list || list.isEmpty())
            return "";
        else {
            return (String) list.get(0).get("f_ywid");
        }
    }

    @Override
    public void updatePrjectYtgzc(String xmbh, String xmmc, String bslx, String space) throws Exception {
        TaskBizProject oldProject = this.projectRepository.findByXmbh(xmbh);
        if (null == oldProject){
            throw new Exception("无法获取xmbh为" + xmbh + "的项目");
        }
        TaskBizProject newProject = this.backDataService.copyProject(oldProject);
        this.backDataService.copyHistoryProject(newProject.getId(), oldProject);
        newProject.setXmbh(xmbh);
        newProject.setName(xmmc);
        newProject.setSubmission(bslx);
        Geometry geometry = GeoUtils.geojson2Geom4490(space);
        newProject.setShape(geometry);
        newProject.setBoundary(geometry.toText());
        this.projectRepository.save(newProject);
    }

    @Override
    public void importXzgdData(String json) throws Exception {
        String namespace = ApiNameType.xzgdImportData[0];
        String apiname = ApiNameType.xzgdImportData[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("获取关联配置失败");
        }
        if (json.contains("\\")) {//信息中心推送数据特殊处理
            json = json.replace("\\\\", "");
        }
        JSONArray array = JSONArray.parseArray(json);
        for (int j = 0; j < array.size(); j++) {
            JSONObject object = array.getJSONObject(j);
            this.saveData(object, applicationApi, ApiDataType.Xzgd);
            try{
                this.zbphDataService.exportZbphData(object);
            }catch (Exception e){
                logger.error("导出到占补平衡失败");
            }
        }
    }
    /**
     * 获取不占用基本农田项目边界信息
     * @param object
     * @return
     * @throws Exception
     */
    private List<Geometry> getGeo(JSONObject object) throws Exception {
        JSONArray array = object.getJSONArray("space");
        for (int i = 0; i < array.size(); i++) {//这里没有处理谷歌地图偏移问题
            JSONObject temp = array.getJSONObject(i);
            String type = temp.getString("fwlx");
            if (!"xmfw".equals(type) && !"xmqydgdzb".equals(type)) {//这里会传递多个geometry，只选取项目边界作为图斑
                continue;
            }
            String space = array.getJSONObject(i).getString("json");
            List<Geometry> geometry = GeoUtils.geojson2Geoms(space);
            return geometry;
        }
        return null;
    }

    /**
     * 拆分mutilpolygon
     * @param xmbh
     * @return
     * @throws Exception
     */
    private List<Geometry> getGeoByTabele(String xmbh) throws Exception {
        TaskBizProject project = this.projectRepository.findByXmbh(xmbh);
        if (null == project || null == project.getShape())
            throw new Exception("space为空时，无法获取到xmbh为" + xmbh + "的项目边界");
        Geometry geometry = project.getShape();
        if (null == geometry)
            throw new Exception("");
        Integer length = geometry.getNumGeometries();
        List<Geometry> result = new ArrayList<>();
        if (length == 0) {
            result.add(geometry);
        } else {
            for (int i = 0; i < length; i++) {
                result.add(geometry.getGeometryN(i));
            }
        }
        return result;
    }

    public String saveBzyjbntData(JSONObject object, TbtskApplicationApi applicationApi, List<TbtskFields> allFields,
                                  TbtskObjectinfo table, Map<String, String> mapping, Geometry geo) throws Exception {
        HashMap<String, Object> map = new HashMap<>();

        //插入数据
        this.insertData(object, mapping, allFields, map, null);

        String f_id = UUID.randomUUID().toString();
        Region region = this.getRegionByName(object.getString("qxmc"));

        String wkt = WKTUtil.geomToWkt(geo);
        map.put("f_shape", wkt);
        map.put("f_shape1", wkt);
        Point point = geo.getCentroid();
        map.put("f_lat", point.getY());
        map.put("f_lon", point.getX());

        if (null != region) {
            map.put("f_xzqmc1", region.getName());
            map.put("f_xzqdm", region.getCode());
            map.put("f_xzqdmsys", region.getCode() + "000000");
        }

        map.put("f_id", f_id);
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_userid", applicationApi.getSqlfilterstr());
        dataBizService.insertData(table.getfTablename(), map, "f_shape");
        return f_id;
    }

    /**
     * 获取配置表中的字段映射
     * @param tableid
     * @return
     * @throws Exception
     */
    public Map<String, String> getFiledMap(String tableid) throws Exception {
        return this.getFiledMap(tableid, null);
    }

    @Override
    public Map<String, String> getFiledMap(String tableid, String tag) throws Exception {
        if (StringUtils.isEmpty(tag)) {
            tag = "0";
        }
//        Map<String, String> fieldsMap = new HashMap<>();
        List<TbtskAutoimportRel> fields = this.tbtskAutoimportRelDao.getImportTableFields(tableid, tag);
        Map<String, String> fieldsMap = new HashMap<>();
        if (fields.size() > 0){
            for(TbtskAutoimportRel value : fields){
                fieldsMap.put(value.getFieldname(), value.getImFieldname());
            }
        } else {
            throw new Exception("获取配置信息失败");
        }
        return fieldsMap;
    }

    public TaskBizProject getProjectByXmbh(String xmbh){
        TaskBizProject project = this.projectRepository.findByXmbh(xmbh);
        return project;
    }

    @Override
    public void receive(String data, Integer type, MultipartFile[] files) throws Exception {
        JSONObject object = JSONObject.parseObject(data);
        object.put("geoway_type", type);
        if (files.length > 0)
            this.saveFile(object, type, files);
        if (type == LogType.kfly_gdxx || type == LogType.kfly_jsydghxkz_zjl || type == LogType.zngl_swltsksjk)
            this.saveData(object, type, files);
        if (type == LogType.kfly_jsydghxkz || type == LogType.kfly_jsydghxkz_szjtl || type == LogType.kfly_jgghhsqrs)
            this.sendData(object, type, files);

    }

    private void saveXzgdGeometry(JSONObject object, HashMap<String, Object> map, String objKey, String mapKey){
        try {
            if(object.containsKey(objKey) && !StringUtils.isEmpty(object.getString(objKey)) && !"null".equals(object.getString(objKey))){
                String geojosn = object.getJSONObject(objKey).getJSONObject("result").toString();
                Geometry geometry = GeoUtils.geojson2Geom(EsriGeoJsonUtil.esri2geo(geojosn));
                map.put(mapKey, geometry);
            } else {
                map.put(mapKey, null);
            }
        } catch (Exception e) {
            this.logger.error(e);
            map.put(mapKey, null);
        }
    }

    /**
     *
     * @param map
     * 合计新增水田=垦造水田面积+旱改水面积;合计新增粮食产能=新增耕地粮食产能+提质改造粮食产能
     */
    private void saveXzgdMessage(HashMap<String, Object> map){
        BigDecimal f_hjxzstmj = new BigDecimal(0);
        if (map.get("f_kzstmj") != null && !StringUtils.isEmpty(map.get("f_kzstmj").toString())) {
            f_hjxzstmj = f_hjxzstmj.add(new BigDecimal(map.get("f_kzstmj").toString()));
        }
        if (map.get("f_hgsmj") != null && !StringUtils.isEmpty(map.get("f_hgsmj").toString())) {
            f_hjxzstmj = f_hjxzstmj.add(new BigDecimal( map.get("f_hgsmj").toString()));
        }
        BigDecimal f_hjxzlscn = new BigDecimal(0);
        if (map.get("f_xzgdlscn") != null && !StringUtils.isEmpty(map.get("f_xzgdlscn").toString())) {
            f_hjxzlscn = f_hjxzlscn.add(new BigDecimal(map.get("f_xzgdlscn").toString()));
        }
        if (map.get("f_tzgzlscn") != null && !StringUtils.isEmpty(map.get("f_tzgzlscn").toString())) {
            f_hjxzlscn = f_hjxzlscn.add(new BigDecimal(map.get("f_tzgzlscn").toString()));
        }
        map.put("f_hjxzstmj", f_hjxzstmj);
        map.put("f_hjxzlscn", f_hjxzlscn);
    }

    /**
     * 保存数据至本地数据库
     * @param object
     * @param type
     * @param files
     * @throws Exception
     */
    private void saveData(JSONObject object, Integer type, MultipartFile[] files) throws Exception {
        TbtskApplicationApi applicationApi = null;
        if (type == LogType.kfly_gdxx) {
            applicationApi = this.tbtskApplicationApiDao.queryApplicationApi("phjg", "kfly_gdxx");
            Geometry geometry = GeoUtils.geojson2Geom(EsriGeoJsonUtil.esri2geo(object.getString("供地范围")));
            object.put("f_shape", geometry.toText());//geojson转wkt
            this.saveData(object, applicationApi, null);
        } else if (type == LogType.kfly_jsydghxkz_zjl) {
            applicationApi = this.tbtskApplicationApiDao.queryApplicationApi("phjg", "kfly_jsydghxkz_zjl");
            JSONArray array = object.getJSONObject("总平面图建筑轮廓").getJSONArray("features");
            for (int i = 0; i < array.size(); i++) {
                JSONObject obj = array.getJSONObject(i);
                //把json中的字符串值转换为json对象
                String geometryStr = obj.getString("geometry");
                String attributeStr = obj.getString("attributes");
                JSONObject geometryJson = JSONObject.parseObject(geometryStr);
                JSONObject attributes = JSONObject.parseObject(attributeStr);
                attributes.put("标识码",obj.getString("unique"));
                obj.put("geometry",geometryJson);
                obj.put("attributes",attributes);

                JSONObject esriGeojson = new JSONObject();
                esriGeojson.put("geometryType", object.getString("geometryType"));
                JSONArray feature = new JSONArray();
                feature.add(obj);
                esriGeojson.put("features", feature);
                Geometry geometry = GeoUtils.geojson2Geom(EsriGeoJsonUtil.esri2geo(esriGeojson.toJSONString()));
                JSONObject copyobj = JSONObject.parseObject(object.toString());
                copyobj.remove("总平面图建筑轮廓");
                for (String key : attributes.keySet()) {
                    copyobj.put( key, attributes.get(key));
                }
                copyobj.put("f_shape", geometry.toText());
                this.saveData(copyobj, applicationApi, null);
            }
        } else if (type == LogType.zngl_swltsksjk) {
            JSONArray array = object.getJSONArray("data");
            applicationApi = this.tbtskApplicationApiDao.queryApplicationApi("zngl", "zngl_swltsksjk");
            Set<String> idSet = new HashSet<>();
            for (int i = 0; i < array.size(); i++) {
                JSONObject obj = this.getData(array.getJSONObject(i));
                String f_id = this.saveData(obj, applicationApi, null);
                idSet.add(f_id);
            }
            this.exportData(applicationApi, StringUtils.join(idSet, ","));
        }
    }

    private void exportData(TbtskApplicationApi applicationApi, String ids) throws Exception {
        TskTaskBiz task = this.bizDao.getByTableId(applicationApi.getTableid());
        this.exportDataService.export(task.getId(), ids, false, false, null, IdentityType.WYDC, null);
    }

    /**
     * 处理geojson数据，将读取属性及shp
     * @param geojson
     * @return
     * @throws Exception
     */
    private JSONObject getData(JSONObject geojson) throws Exception {
        JSONObject result = new JSONObject();
        JSONObject properties = geojson.getJSONObject("properties");
        for (String key : properties.keySet()) {
            result.put( key, properties.get(key));
        }
        Geometry geometry = GeoUtils.geojson2Geom(geojson.toJSONString());
        result.put("f_shape", geometry.toText());
        return result;
    }

    /**
     * 通用，发送文件至外网
     * @param dataObj
     * @param type
     * @param files
     * @throws IOException
     */
    private void sendData(JSONObject dataObj, Integer type, MultipartFile[] files) throws Exception {
        String safeFileName = new StringBuilder().append(System.currentTimeMillis()).toString();
        String fileNameNoSuffix = new StringBuilder().append(uploadDir).append(File.separator).append(safeFileName).toString();
        List<String> txtData = new ArrayList<>();
        txtData.add(dataObj.toString());
        this.exportTxtService.writeTxtData(txtData, fileNameNoSuffix, false, "data");
        if (files.length > 0 && null != dataObj.getJSONArray("geoway_filename")) {
            JSONArray objArray = dataObj.getJSONArray("geoway_filename");
            for (int i = 0; i < objArray.size(); i++) {
                String fromPath = this.mediaDir + File.separator + "other" + File.separator + type + File.separator + objArray.getString(i);
                String toPath = fileNameNoSuffix + File.separator + objArray.getString(i);
                FileUtils.copyFile(new File(fromPath), new File(toPath));
            }
        }
        ZipUtils utils = new ZipUtils();
        utils.doZip(fileNameNoSuffix);
        ExportDataUtils.copyFileToSubmit(safeFileName + ".zip", this.uploadDir, this.submitDir);//用于测试，可删除
        // 删除临时文件夹
        ExportFileUtil.deleteFileAndDir(new File(fileNameNoSuffix));
        File zipFile = new File(fileNameNoSuffix + ".zip");
        String identity = "";
        if (type == LogType.kfly_jsydghxkz || type == LogType.kfly_jsydghxkz_szjtl || type == LogType.kfly_jgghhsqrs)//传递给今奥
            identity = IdentityType.JAPHJG;
        this.fileTransferService.sendFile(fileNameNoSuffix + ".zip", identity);
        zipFile.delete();
    }

    /**
     * 通用，保存文件至本地
     * @param data
     * @param type
     * @param files
     * @throws IOException
     */
    private void saveFile(JSONObject data, Integer type, MultipartFile[] files) throws IOException {
        JSONArray filePathArray = new JSONArray();
        for (MultipartFile file : files) {
            String filename = file.getOriginalFilename();
            String path = this.mediaDir + File.separator + "other" + File.separator + type;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Long time = System.currentTimeMillis();
            String newFile = time + "_" + filename;
            path += File.separator + newFile;
            File outFile = new File(path);
            FileUtils.copyInputStreamToFile(file.getInputStream(), outFile);
            filePathArray.add(newFile);
        }
        data.put("geoway_filename", filePathArray);
    }

    private String getXzqdmSys(Geometry geo) {
        String xzqdmsys = "";
        RegionVillage regionVillage = regionService.queryRegionVillageByCoor(geo);
        if (regionVillage != null) {
            xzqdmsys = regionVillage.getCode();
        } else {
            RegionTown regionTown = regionService.queryRegionTownCotain(geo);
            if (regionTown != null) {
                xzqdmsys = regionTown.getCode() + "000";
            } else {
                try {
                    String wkt = WKTUtil.geomToWkt(geo);
                    RegionDetail region =regionService.queryRegionByGeom(wkt, 4490, 3);
                    if (null == region){
                        throw new Exception("数据错误，数据中心点不在本省范围");
                    }
                    xzqdmsys = region.getCode() + "000000";
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return xzqdmsys;
    }
}
