package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

/**
 * @Author Waves
 * @Date 2024/3/5
 * @Description
 **/
public abstract class AbstractScopedFileResolver implements FileResolver2 {

    protected FileResolverProvider2 fileResolverProvider2;

    @Autowired
    public void setFileResolverProvider2(FileResolverProvider2 fileResolverProvider2) {
        this.fileResolverProvider2 = fileResolverProvider2;
    }

    protected abstract String getScopedExtension();

    protected FileResolver2 getScopedResolver(String type){
        Assert.hasText(type);
        Assert.hasText(getScopedExtension());
        String scopedResolverType = this.getScopedExtension().toLowerCase() + "." + type;
        return fileResolverProvider2.hasHandler(scopedResolverType)?
                fileResolverProvider2.getHandler(scopedResolverType):
                fileResolverProvider2.getHandler(type);
    }
}
