package com.geoway.landteam.landcloud.service.datatransfer.inherit;


import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import org.springframework.stereotype.Service;

/**
 * @Author Waves
 * @Date 2023/3/23
 * @Description
 **/
@Service(FileResolver2.PREFIX + "calc.db")
public class CalcDbFileResolver extends ZipDbFileResolver{

    @Override
    public void resolve(String filepath) throws Exception {
        SqlliteConnTool connTool = null;
        try {
            connTool = new SqlliteConnTool(filepath);
            //导入Tbtsk_task_biz
            this.insertBizData(connTool);
            //导入tbtsk_objectinfo（任务与表关联）
            this.insertObjectInfo(connTool);
            //导入tbtsk_fields及数据表
            this.insertFields(connTool);
            //tbtsk_group
            this.insertGroup(connTool);
            //导入数据表，这里之前是写在tbtsk_fields之后，从tbtsk_fields获取fileds
            this.insertTableData(connTool);
            insertOrUpdateTable(connTool,"tb_cloud_calculatiton_def");
            insertOrUpdateTable(connTool,"tb_cloud_calculation_task");
        } finally {
            connTool.Dispose();
        }
    }

}
