package com.geoway.landteam.landcloud.service.datatransfer.inherit;


import com.geoway.landteam.landcloud.dao.atlas.CloudCalculationTaskDao;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.servface.datatransfer.FileResolver;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.CloudCalculationTaskService;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @Author Waves
 * @Date 2023/3/23
 * @Description
 **/
@Service(FileResolver.PREFIX + "calc")
public class CalcFileResolver extends ZipFileResolver {
    @Autowired
    CloudCalculationTaskDao cloudCalculationTaskDao;
    @Autowired
    CloudCalculationTaskService cloudCalculationTaskService;
    @Override
    protected String getScopedExtension() {
        return "calc";
    }
    @Value("${project.applicationType}")
    protected String applicationType;

    @Override
    protected void process(String path) throws Exception{
        File dir = new File(path);
        if(!dir.exists() || !dir.isDirectory()) return;
        List<File> files = new ArrayList<>();
        File[] temp = dir.listFiles(f -> f.getName().endsWith(".db"));
        Collections.addAll(files,temp);
        temp = dir.listFiles(f -> f.getName().endsWith(".zip"));
        Collections.addAll(files,temp);
        for(File file :files){
            //根据后缀类型查找解析器并解析
            String fullname = file.getAbsolutePath();
            String suffix = FilenameUtils.getExtension(fullname);
            //这里需要注入文件夹类型解析器
            if(StringUtils.isBlank(suffix)){
                continue;
            }
            FileResolver2 fileResolver = this.getScopedResolver(suffix);
            fileResolver.resolve(fullname);
        }
        if(dir.exists()){
            FileUtil.deleteFileAndDir(dir);
        }

        //更新状态
        String taskid = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(path));
        if("lan".equals(applicationType)){
            Integer status = CloudCalculationTask.STATUS_PUSH |CloudCalculationTask.STATUS_LAN_RECEIVED;
            cloudCalculationTaskDao.updataStatusByTaskid(taskid,status);
        }else {
            cloudCalculationTaskService.addStatusByTaskid(taskid,CloudCalculationTask.STATUS_RETURNED|CloudCalculationTask.STATUS_RETURN);
        }
    }
}
