package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalcuationDef;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationDefRepository;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationTaskRepository;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.DatasourceFactory;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.impl.DatasourceHdfs;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.impl.HdfsHandleImpl;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ShapeOprate;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import com.geoway.landteam.landcloud.service.util.FileUtil;
import com.geoway.landteam.landcloud.service.util.ZipUtils;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.Hdfs;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * @Author Waves
 * @Date 2023/3/23
 * @Description
 **/
@Service(FileResolver2.PREFIX + "calc.zip")
public class CalcZipFileResolver extends ZipDbFileResolver{

    private int SHAPE_NUM_LIMIT =  5000;
    @Autowired
    CloudCalculationDefRepository cloudCalculationDefRepository;
    @Autowired
    CloudCalculationTaskRepository cloudCalculationTaskRepository;
    @Autowired
    DatasourceFactory datasourceFactory;
    @Autowired
    private DefaultOssOperatorService stsService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private HdfsHandleImpl hdfsHandler;

    @Value("${project.applicationType}")
    protected String applicationType;
    @Override
    public void resolve(String filepath) throws Exception {
        String taskid = "";
        if("lan".equals(applicationType)){
            taskid = FilenameUtils.getBaseName(filepath);
            String unzipPath = FilenameUtils.getFullPath(filepath);
            ZipUtils.unZip(new File(filepath), unzipPath);
            JSONObject datasource = Optional.of(taskid)
                    .map(cloudCalculationDefRepository::queryByTask)
                    .map(CloudCalcuationDef::getInputDataSource)
                    .map(JSONObject::parseObject)
                    .orElseThrow(()-> new RuntimeException());
            String type = datasource.getString("type");
            String source = datasource.getString("dataSource");
            String dbuser = datasource.getString("dbuser");
            String password = datasource.getString("dbpassword");

            if("hdfs".equalsIgnoreCase(type)){
                String hdfsPath = datasource.getString("path");
                String srcPath = unzipPath + taskid;
                DatasourceHdfs ds = (DatasourceHdfs)datasourceFactory.getDatasource(type);
                Hdfs hdfs = null;
                try{
                    hdfs = ds.getDaoObject(source,dbuser,password);
                    hdfsHandler.uploadshp(hdfs,"LOCAL",taskid,srcPath,hdfsPath,"0","0");
                }finally {
                    if(hdfs != null){
                        ds.returnDaoObject(source,hdfs);
                    }
                }
            }else{
                Datasource ds = datasourceFactory.getDatasource(type);
                if(!ds.testConnection(source,dbuser,password)) {
                    throw new RuntimeException("输入数据源连接失败");
                }
                List<Geometry> geometrylist = parseGeometry(filepath);
                String tablename = datasource.getString("tablename");
                ds.startConnectionPool(source,dbuser,password);
                JdbcTemplate inputTemplate = (JdbcTemplate)ds.getDaoObject(source,dbuser,password);
                for (Geometry geometry:geometrylist) {
                    String geomStr = String.format("st_geomfromtext('%s',%s)",geometry.toString(),4490);
                    Long oid = System.currentTimeMillis() % (Integer.MAX_VALUE);
                    String sql = String.format("insert into %s (objectid,shape,taskid) values(%s,%s,'%s')",tablename,oid,geomStr,taskid);
                    inputTemplate.update(sql);
                }
            }
            // 删除解压文件夹
            FileUtil.deleteFileAndDir(new File(unzipPath));
        }else{
            taskid = FilenameUtils.getBaseName(FilenameUtils.getFullPathNoEndSeparator(filepath));
            List<CloudCalculationTask> tasks = Optional.of(taskid).map(cloudCalculationTaskRepository::queryByTaskid)
                    .orElseThrow(RuntimeException::new);
            String taskname = tasks.get(0).getName();
            if(StringUtils.isBlank(taskname))
                throw new RuntimeException("Empty Tasak Name!");
            String sendObjName = "calc/" + taskname + ".zip";
            // 上传到obs
            String url = stsService.sendObject2Oss(sendObjName, filepath);
            tasks.stream().forEach( task -> {
                String resultStr = task.getResult();
                JSONObject result;
                if(StringUtils.isBlank(resultStr)){
                    result= new JSONObject();
                }else {
                    result = JSONObject.parseObject(resultStr);
                }
                result.put("shape",url);
                task.setResult(result.toJSONString());
            });
            cloudCalculationTaskRepository.saveAll(tasks);
        }
    }

    private List<Geometry> parseGeometry(String filepath) throws Exception {
        List<Geometry> geoms = null;
        List<Geometry> result =new ArrayList<>();
                // 解压文件夹名称
        String zipDirFileName = FilenameUtils.removeExtension(filepath);
        // 获取shp文件
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");

        ShapefileDataStore shpDataStore = new ShapefileDataStore(new File(shpFileList.get(0)).toURI().toURL());
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore
                .getFeatureSource(shpDataStore.getTypeNames()[0]);
        //获取图层原始坐标系，转换目标坐标系
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        String wkt = sourceCRS.toWKT();


        ShapeOprate shapeOprate = new ShapeOprate();

        if (shpFileList != null && shpFileList.size() > 0) {
            geoms = shapeOprate.readShp(shpFileList.get(0));
        }
//        List<Map> fields=null;
//        List<String> dbfFileList = FileUtil.findFiles(zipDirFileName, "*.dbf");
//        if (dbfFileList != null && dbfFileList.size() > 0) {
//            fields = shapeOprate.readDBF(dbfFileList.get(0));
//        }
        int count = 0 ;
        GeometryFactory factory = new GeometryFactory();
        List<Polygon> polygons = new ArrayList();
        for(int i = 0; i < geoms.size(); i++){
            if(count < SHAPE_NUM_LIMIT){
                polygons = getPolygon(polygons, geoms.get(i), false,  wkt);
                count += 1;
            }else {
                Geometry multipolygon = factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
                result.add(multipolygon);
                polygons = new ArrayList();
                count = 0;
            }
        }
        if(count > 0){
            Geometry multipolygon = factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
            result.add(multipolygon);
        }

        return result;
    }

    private List<Polygon> getPolygon(List<Polygon> polygons, Geometry geometry, boolean transform, String crsSourceWkt) throws Exception{
        if("MultiPolygon".equals(geometry.getGeometryType()) && geometry.getNumGeometries() > 0){
            for(int i = 0; i < geometry.getNumGeometries(); i++){
                polygons = getPolygon(polygons, geometry.getGeometryN(i), transform, crsSourceWkt);
            }
        }else if("Polygon".equals(geometry.getGeometryType())){
            if(transform){
                polygons.add((Polygon) GeoUtils.geoTransform(geometry, crsSourceWkt, "EPSG:4490"));
            }else{
                polygons.add((Polygon) geometry);
            }
        }
        return polygons;
    }

}
