package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.List;

/**
 * @Author Waves
 * @Date 2023/3/23
 * @Description
 **/
@Service(FileResolver2.PREFIX + "zip")
public class ZipFileResolver extends AbstractScopedFileResolver {

    //需处理的数据，之后改到配置文件中，不处理全生命周期数据
    private final String[] identitys = new String[]{"wydc", "zbph", "phjg", "dcxs"};//dcxs 作为中转处理的类型
    @Override
    protected String getScopedExtension() {
        return "zip";
    }

    @Override
    public void resolve(String path) throws Exception {
        // e.g. path --- d:\exchange\objIdentity\123456.zip
        //e.g. 123456
        String fileNameWithoutExtension = FilenameUtils.getBaseName(path);
        // e.g. d:\exchange\objIdentity
        String filePath = FilenameUtils.getFullPathNoEndSeparator(path);
        //e.g. objIdentity
//        String objIdentity = FilenameUtils.getName(filePath);
        // e.g. d:\exchange\objIdentity\123456\
        String decompressedPath = filePath + File.separator + fileNameWithoutExtension + File.separator;
        ZipUtils utils = new ZipUtils();
        utils.decompressZip(path, decompressedPath);
//        if (this.identitys[0].equals(objIdentity)|| this.identitys[2].equals(objIdentity)) {
//        }
        this.process(decompressedPath);
        this.deleteFiles(decompressedPath);
    }

    /**
     * 文件解压后的处理工作
     * @param path 解压目录
     * @throws Exception
     */
    protected void process(String path) throws Exception {
        //保存数据
        List<String> dbFileList = FileUtil.findFiles(path, "meta.db");
        if (!dbFileList.isEmpty()) {
            String dbPath = dbFileList.get(0);
            FileResolver2 fileResolver = getScopedResolver("db");
            fileResolver.resolve(dbPath);
        }
        FileResolver2 mediaResolver =  getScopedResolver("media");
        mediaResolver.resolve(path);
        //保存pdf，步移式选址文件
        FileResolver2 pdfResolver =  getScopedResolver("pdf");
        pdfResolver.resolve(path);
        //回退至外网的数据再次推送至内网后处理内网数据
        List<String> txtList = FileUtil.findDirectorys(path, "*txt");
        if (!txtList.isEmpty()) {
            String backLan = "";//内网处理回退至外网再次提交的任务时，该txt最后处理；
            for (int i = 0; i < txtList.size(); i++) {
                if (InterfaceType.backLan.equals(txtList.get(i))) {
                    backLan = txtList.get(i);
                } else{
                    fileResolverProvider2.getHandler("txt").resolve(txtList.get(i));
                }
            }
            if (!StringUtils.isEmpty(backLan)) {
                fileResolverProvider2.getHandler("txt").resolve(backLan);
            }
        }
    }

    private void deleteFiles(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            FileUtil.deleteFileAndDir(file);
        } else {
            file.delete();
        }
    }
}
