package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.dao.pub.TbExchangeFieldRelDao;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.customtask.task.ObjectTableNameService;
import com.geoway.landteam.landcloud.servface.datatransfer.DirectoryResolver;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.File;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author Waves
 * @Date 2023/7/27
 * @Description
 **/
public abstract class AbstractWpzfDirectoryResolver implements DirectoryResolver {
    private GiLoger loger = GwLoger.getLoger(AbstractWpzfDirectoryResolver.class);

    protected TbExchangeFieldRelDao tbExchangeFieldRelDao;
    protected JdbcTemplate jdbcTemplate;
    protected AppMediaRepository appMediaRepository;

    @Autowired
    public void setTbExchangeFieldRelDao(TbExchangeFieldRelDao tbExchangeFieldRelDao) {
        this.tbExchangeFieldRelDao = tbExchangeFieldRelDao;
    }

    @Autowired
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Autowired
    public void setAppMediaRepository(AppMediaRepository appMediaRepository) {
        this.appMediaRepository = appMediaRepository;
    }

    //1-jpg/png 2-mp4 3-mp3 4-osgb 5-pdf 6-txt 7-word 8-excel 9-ppt
    protected static Map<String,Integer> SUFFIX_TYPE_MAP = new HashMap<String,Integer>(){{
        put("jpg",1);
        put("png",1);
        put("mp4",2);
        put("mp3",3);
        put("osgb",4);
        put("pdf",5);
        put("txt",6);
        put("doc",7);
        put("docx",7);
        put("xls",8);
        put("xlsx",8);
        put("ppt",9);
        put("pptx",9);
        put("zip",10);
    }};

    protected SysConfigService sysConfigService;
    protected ObjectTableNameService objectTableNameService;
    protected DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    public void setSysConfigService(SysConfigService sysConfigService){
        this.sysConfigService = sysConfigService;
    }
    @Autowired
    public void setObjectTableNameService(ObjectTableNameService objectTableNameService){
        this.objectTableNameService = objectTableNameService;
    }
    @Autowired
    public void setDefaultOssOperatorService(DefaultOssOperatorService defaultOssOperatorService) {
        this.defaultOssOperatorService = defaultOssOperatorService;
    }

    protected String getPrefix( AttachFileParam param){
        return param.getCode().toLowerCase();
    }
    abstract protected String getConfigKey( AttachFileParam param);
    abstract protected String getAttachTableName( AttachFileParam param);
    abstract protected String queryFileInfoSql(AttachFileParam param, String filename);
    abstract protected void customedMediaField(AppMedia media,ResultSet rs) throws Exception;

    @Override
    public void resolve(File directory, AttachFileParam param) throws Exception {
        File[] files = directory.listFiles();
        for (File file:files){
            uploadAttach(file,param);
        }
    }
    protected Integer getMedaiType(String filename){
        String extension = FilenameUtils.getExtension(filename);
        if(StringUtils.isNotBlank(extension)){
            return SUFFIX_TYPE_MAP.get(extension);
        }
        //key为null有线程安全问题
        return -1;
    }
    protected void uploadAttach(File file, AttachFileParam param) throws Exception{

        TbExchangeFieldRel rel = tbExchangeFieldRelDao.getConfig(getPrefix(param) + "." + getConfigKey(param));
        Integer objectType = rel.getObjectType();
        String objectId = rel.getObjectid();
        String tablename = objectTableNameService.getTablename(objectId,objectType);
        SqlliteConnTool connTool = param.getConnTool();

        String filename = file.getName();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

        String sql = queryFileInfoSql(param,filename);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        if(rs.next()){
            String tbbsm = rs.getString("tbbsm");
            String primary = "f_dkbsm";
            if("ba006".equals(getPrefix(param))){
                primary = "f_tbbsm";
            }
            //获取不到tbbh没法正则匹配
            String idSql = String.format("select f_id from %s where %s = '%s'",tablename,primary,tbbsm);
            String idSqlChild = String.format("select f_id from %s where %s = '%s'",tablename + "_child",primary,tbbsm);
            String id = Optional.of(idSql)
                    .map(jdbcTemplate::queryForList)
                    .filter(e -> !e.isEmpty())
                    .map(e -> e.get(0))
                    .map(e -> (String)e.get("f_id"))
                    .orElseGet(() -> Optional.of(idSqlChild)
                            .map(jdbcTemplate::queryForList)
                            .filter(e -> !e.isEmpty())
                            .map(e -> e.get(0))
                            .map(e -> (String)e.get("f_id"))
                            .orElseThrow(() -> new RuntimeException("未找到图斑"))
                    );

            String md5 = Md5Util.calFileMd5(file);
            int contMd5 = appMediaRepository.countBySm3(objectId,id,md5);
            if(contMd5 == 0 ){
                AppMedia media = new AppMedia();
                media.setBizId(objectId);
                media.setId(UUID.randomUUID().toString());
                media.setGalleryid(id);
                media.setTypetype(0);
                media.setFromSource("JAIMPORT");
                media.setSm3(md5);
                media.setTableName(tablename);
                media.setMediasize(Double.valueOf(file.length()));

                String extension = FilenameUtils.getExtension(filename);
                Integer type = SUFFIX_TYPE_MAP.get(extension);
                media.setType(type);

                String remoteUrl = "media/101/" + media.getBizId() + "/" + System.currentTimeMillis() + "/" + type + "/" + filename;
                String url = defaultOssOperatorService.sendObject2Oss(remoteUrl, file);
                media.setServerpath(url);

                String timeStr = rs.getString("createtime");
                try{
                    Date createtime= sdf.parse(timeStr);
                    media.setCreateTime(String.valueOf(createtime.getTime()));
                }catch (Exception e){
                    e.printStackTrace();
                }
                customedMediaField(media,rs);
                appMediaRepository.save(media);
            }
        }
    }
}
