package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.io.File;
import java.util.Map;
import java.util.Optional;

/**
 * @Author Waves
 * @Date 2023/8/1
 * @Description provider更优于Factory
 **/
@Component
public class DbResolverProvider {


    @Resource
    private Map<String , DbResolver> DB_RESOLVER_MAP;


    public final DbResolver getHandler(String code)throws Exception{
        return Optional.ofNullable(code)
                //增加前缀
                .map(DbResolver.PREFIX::concat)
                .map(String::toLowerCase)
                .map(DB_RESOLVER_MAP::get)
                .orElseThrow(()-> new Exception("未找到该类型DB解析器"));
    }

    public final boolean hasHandler(String code){
        return Optional.ofNullable(code)
                //增加前缀
                .map(DbResolver.PREFIX::concat)
                .map(String::toLowerCase)
                .map(DB_RESOLVER_MAP::get)
                .isPresent();
    }


    public final void handle(SqlliteConnTool connTool,String code) throws Exception{
        this.getHandler(code).resolve(connTool);
    }
    public final void handle(String path,String code) throws Exception{
        SqlliteConnTool connTool = new SqlliteConnTool(path);
        this.getHandler(code).resolve(connTool);
    }
    public final void handle(File dbFile, String code) throws Exception{
        SqlliteConnTool connTool = new SqlliteConnTool(dbFile.getAbsolutePath());
        this.getHandler(code).resolve(connTool);
    }

}
