package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.datatransfer.DirectoryResolver;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;


import javax.annotation.Resource;
import java.io.File;
import java.util.Map;
import java.util.Optional;

/**
 * @Author Waves
 * @Date 2023/8/17
 * @Description
 **/
@Component
public class DirectoryResolverProvider {
    @Resource
    private Map<String, DirectoryResolver> DIR_RESOLVER_MAP;

    public final DirectoryResolver getHandler(String code) throws Exception{
        return Optional.ofNullable(code)
                //增加前缀
                .map(DirectoryResolver.PREFIX::concat)
                .map(String::toLowerCase)
                .map(DIR_RESOLVER_MAP::get)
                .orElseThrow(()-> new Exception("未找到该类型DB解析器"));
    }

    public final boolean hasHandler(String code){
        return Optional.ofNullable(code)
                //增加前缀
                .map(DirectoryResolver.PREFIX::concat)
                .map(String::toLowerCase)
                .map(DIR_RESOLVER_MAP::get)
                .isPresent();
    }
    public final void handle(String path, AttachFileParam param, String code) throws Exception{
        File dir = new File(path);
        if(dir.isDirectory()) {
            this.getHandler(code).resolve(dir,param);
        }
    }
    public final void handle(File directory, AttachFileParam param, String code) throws Exception{
        if(directory.isDirectory()){
            this.getHandler(code).resolve(directory,param);
        }
    }
    public final void handle(File directory, AttachFileParam param) throws Exception{
        String code = directory.getName();
        this.handle(directory,param,code);
    }

    public final void handle(String path, AttachFileParam param) throws Exception{
        path = FilenameUtils.getPathNoEndSeparator(path);
        String code = FilenameUtils.getName(path);
        this.handle(path,param,code);
    }
}
