package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.service.jms.service.IConsumerStrategyService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.jms.JMSException;
import javax.jms.MapMessage;
import java.io.IOException;

/**
 * Created by licong on 2020/6/22.
 */
@Service
public class ExportDataConsumerServiceImpl implements IConsumerStrategyService {
    private GiLoger logger = GwLoger.getLoger(ExportDataConsumerServiceImpl.class);

    private final String EXPORT_DATA_CODE = "ExportDataCode";
    @Autowired
    private ExportDataService exportDataService;

    @Override
    public String getCode() {
        return this.EXPORT_DATA_CODE;
    }

    @Override
    public void execute(MapMessage mapMessage) {
        try {
            String taskId = mapMessage.getString("taskId");
            Long userId = mapMessage.getLong("userId");//未使用
            String ids = mapMessage.getString("ids");
            Boolean isSubmit = mapMessage.getBoolean("isSubmit");
            this.exportDataService.export(taskId, ids, false, isSubmit, String.valueOf(userId), IdentityType.WYDC, null);
        } catch (JMSException | IOException e) {
            logger.error(e.getMessage());
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }
}
