package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TbtskTaskClassService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.servface.taskTranslate.TaskBusiCodeApater2_0Service;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.datatransfer.constants.BusiType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Created by licong on 2020/6/22.
 */
@Service
public class ExportDataServiceImpl implements ExportDataService {
    private GiLoger logger = GwLoger.getLoger(ExportDataServiceImpl.class);
  /*  @Value("#{imeSettings['project.uploadDir']}")*/
    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Value("${project.submitDir}")
   /* @Value("#{imeSettings['project.submitDir']}")*/
    protected String submitDir;
    @Value("${cloudService.url}")
   /* @Value("#{imeSettings['cloudService.url']}")*/
    private String cloudQueryUrl;
    @Value("${project.applicationType}")
  /*  @Value("#{imeSettings['project.applicationType']}")*/
    private String applicationType;
    private final String template = "dailytaskmeta-submit.db";

    @Autowired
    private TskTaskBizService tskTaskBizService;
    @Autowired
    private TbtskFieldsService tbtskFieldsService;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    private LandUserRepository landUserDao;
    @Autowired
    private CloudQueryService cloudQueryDao;
    @Autowired
    private ExportTxtService exportTxtService;
    @Autowired
    private FileTransferService fileTransferService;
//    @Autowired
    @Resource(name = "CloudAnalyzeCQBysxzService")
    private CloudAnalyzeCQBysxzService analyzeCQService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TaskBusiCodeApater2_0Service taskBusiCodeApater2_0Service;
    /**
     * 可缓存的线程池
     */
    private ExecutorService executor = Executors.newCachedThreadPool();

    /**
     *
     * @param taskId 任务主键
     * @param ids 数据id，英文逗号分隔，如果不为空，只生成数据表和filed表（为了让接收者知道数据所属）
     * @param isAppSubmit 是否是app提交数据，如果是则只导出多媒体相关及图斑数据
     * @param isSubmit 是否是基本农田上交项目，如果是则在导入时会调用苍穹接口
     * @param userId 用户信息，用于步移式选址获取pdf文件
     * @throws Exception
     */
    @Override
    public void export(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds) throws Exception {
        checkNotNull(taskId, "taskId can not be null ");
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List<TbtskFields> sourceFields = null;
        SysConfig disabelTransferConfig = sysConfigService.findOne("transfer.disable");
        boolean disabelTransfer ;
        if(disabelTransferConfig == null || StringUtils.isBlank(disabelTransferConfig.getValue())){
            disabelTransfer = false;
        }else {
            disabelTransfer = "true".equals(disabelTransferConfig.getValue().toLowerCase());
        }
        File zipFile = null;
        try {
            tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
            if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
                tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && StringUtils.isNotBlank(tbtskObjectinfo.getfTablename())) {
                sourceFields = tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            String safeFileName = new StringBuilder().append(System.currentTimeMillis()).toString();
            String fileNameNoSuffix = new StringBuilder()
                    .append(uploadDir)
                    .append(File.separator)
                    .append(safeFileName)
                    .toString();
            if (sourceFields != null && sourceFields.size() > 0) {
                this.createExportData(fileNameNoSuffix, tbtskObjectinfo, tskTaskBiz, sourceFields, ids, isAppSubmit, userId, userIds);
                if (isSubmit) {
                    this.createSubmitTxt(fileNameNoSuffix, tskTaskBiz.getId());
                    if (!"lan".equals(this.applicationType))
                        this.createBackTxt(fileNameNoSuffix, tskTaskBiz.getId());
                }
                // 压缩文件夹
                ZipUtils utils = new ZipUtils();
                utils.doZip(fileNameNoSuffix);
                //ExportDataUtils.copyFileToSubmit(safeFileName + ".zip", this.uploadDir, this.submitDir);//用于测试，可删除
                // 删除临时文件夹
                ExportFileUtil.deleteFileAndDir(new File(fileNameNoSuffix));
                zipFile = new File(fileNameNoSuffix + ".zip");
                //开发利用app提交不同步到内网
                if(!disabelTransfer ){
                    this.fileTransferService.sendFile(fileNameNoSuffix + ".zip", identity);
                }
            }
        } catch (Exception e) {
            logger.error(e);
            e.printStackTrace();
            throw e;
        }finally {
            if(!disabelTransfer && zipFile != null){
                zipFile.delete();
            }
        }
    }



    /**
     * 创建可下载的db
     * @param taskId 任务主键
     * @param ids 数据id，英文逗号分隔，如果不为空，只生成数据表和filed表（为了让接收者知道数据所属）
     * @param isAppSubmit 是否是app提交数据，如果是则只导出多媒体相关及图斑数据
     * @param isSubmit 是否是基本农田上交项目，如果是则在导入时会调用苍穹接口
     * @param userId 用户信息，用于步移式选址获取pdf文件
     * @throws Exception
     */
    @Override
    public void createDownloadDataAsync(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds){
        // 启动线程进行数据构建
        Thread thread = new Thread(new Runnable() {
            @Override
            public void run() {
                createDownloadData(taskId,ids,isAppSubmit,isSubmit,userId,identity,userIds);
            }
        });
        //触发：thread
        executor.execute(thread);
    }

    /**
     *
     * @param taskId 任务主键
     * @param ids 数据id，英文逗号分隔，如果不为空，只生成数据表和filed表（为了让接收者知道数据所属）
     * @param isAppSubmit 是否是app提交数据，如果是则只导出多媒体相关及图斑数据
     * @param isSubmit 是否是基本农田上交项目，如果是则在导入时会调用苍穹接口
     * @param userId 用户信息，用于步移式选址获取pdf文件
     * @throws Exception
     */
    public void createDownloadData(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds) {
        checkNotNull(taskId, "taskId can not be null ");
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List<TbtskFields> sourceFields = null;
        DataDownloadRecord dataDownloadRecord = dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, Long.parseLong(userId));

        dataDownloadRecordService.save(dataDownloadRecord);
        try {
            tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
            dataDownloadRecord.setName(tskTaskBiz.getName());
            if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
                tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && StringUtils.isNotBlank(tbtskObjectinfo.getfTablename())) {
                sourceFields = tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            String safeFileName = new StringBuilder().append(System.currentTimeMillis()).toString();
            String fileNameNoSuffix = new StringBuilder()
                    .append(uploadDir)
                    .append(File.separator)
                    .append(tskTaskBiz.getName()+"_"+safeFileName)
                    .toString();
            if (sourceFields != null && sourceFields.size() > 0) {
                this.createExportData(fileNameNoSuffix, tbtskObjectinfo, tskTaskBiz, sourceFields, ids, isAppSubmit, userId, userIds);
                if (isSubmit) {
                    this.createSubmitTxt(fileNameNoSuffix, tskTaskBiz.getId());
                    if (!"lan".equals(this.applicationType))
                        this.createBackTxt(fileNameNoSuffix, tskTaskBiz.getId());
                }
                // 压缩文件夹
                ZipUtils utils = new ZipUtils();
                utils.doZip(fileNameNoSuffix);
//                ExportDataUtils.copyFileToSubmit(safeFileName + ".zip", this.uploadDir, this.submitDir);//用于测试，可删除
                // 删除临时文件夹
                ExportFileUtil.deleteFileAndDir(new File(fileNameNoSuffix));
                File zipFile = new File(fileNameNoSuffix + ".zip");
                dataDownloadRecord.setUrl(zipFile.getAbsolutePath());
                dataDownloadRecord.setTbCount(tskTaskBiz.getAllCount());
                dataDownloadRecord.setEndTime(new Date());
                dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                dataDownloadRecordService.save(dataDownloadRecord);
            }
        } catch (Exception e) {
            logger.error(e);
            e.printStackTrace();
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setErrorMsg(e.getMessage());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            dataDownloadRecordService.save(dataDownloadRecord);
        }
    }

    /**
     * 创建接口数据
     * @param requestBody 接口的对应参数
     * @param url 跨网段的接口路径
     * @param type 接口的请求方式 （post 或者 get）
     * @param loginUrl 登录接口的请求  get
     * @param identity 业务系统id，用于文件传输
     * @throws Exception
     */
    @Override
    public void createInterfaceData(JSONObject requestBody, String url, String type, String loginUrl, String identity) throws Exception {
        checkNotNull(url, "url can not be null ");
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("requestBody",requestBody);
            jsonObject.put("url",url);
            jsonObject.put("loginUrl",loginUrl);
            jsonObject.put("type",type);
            String fileName = new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date());
            File file = new File(System.getProperty("java.io.tmpdir") + fileName + ".ex");
            String param = jsonObject.toJSONString();
            FileUtils.writeStringToFile(file, param, "GBK");
            this.fileTransferService.sendFile(file, identity);
            file.delete();
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }



    @Override
    public void appSubmit(String bizId, String tableName, MultipartFile[] files, String userId, String identity){
        try {
            if (files.length < 1) {
                this.logger.error("app上交任务数据同步失败，无法获取db文件");
                throw new Exception("无法获取db文件");
            }
            MultipartFile fileOfDB = files[0];

            File tempUploadFile = buildTempUploadFile(UUID.randomUUID().toString());
            FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);
            SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            ResultSet rs = null;
            String sql = "SELECT DISTINCT f_id from " + tableName;
            rs = statement.executeQuery(sql);
            List<String> idList = new ArrayList<>();
            while (rs.next()) {
                String f_id = rs.getString("f_id");
                idList.add(f_id);
            }
            connPool.closeAll(connection,statement,rs);
            tempUploadFile.delete();

            this.export(bizId, String.join(",", idList), true, false, userId, identity, null);
        } catch (Exception e) {
            this.logger.fatal("app上交任务数据同步失败" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void sendBYSXZData(String taskid, String ids) throws Exception {
        this.export(taskid, ids, false, false, null, IdentityType.WYDC, null);
    }

    @Override
    public String getAppSubmitIds(String tableName, MultipartFile[] files) throws SQLException, IOException {
        MultipartFile fileOfDB = files[0];
        File tempUploadFile = buildTempUploadFile(UUID.randomUUID().toString());
        FileUtils.copyInputStreamToFile(fileOfDB.getInputStream(), tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "SELECT DISTINCT f_id from " + tableName;
        rs = statement.executeQuery(sql);
        List<String> idList = new ArrayList<>();
        while (rs.next()) {
            String f_id = rs.getString("f_id");
            idList.add(f_id);
        }
        connPool.closeAll(connection,statement,rs);
        tempUploadFile.delete();
        return String.join(",", idList);
    }

    /**
     * 在指定目录生成导出文件，重载1
     * @param resultDbFileDir 成果db所在路径(新生成的db存放的路径)
     * @param tbtskObjectinfo 任务配置信息
     * @param tskTaskBiz 任务配置信息
     * @param fieldsList 任务配置信息
     * @param ids 图斑筛选
     * @param isAppSubmit 是否app提交
     * @param userId 用于步移式选址获取pdf文件
     * @param userIds 自动下发到用户
     * @return
     */
    @Override
    public void createExportData(String resultDbFileDir,
                                 TbtskObjectinfo tbtskObjectinfo,TskTaskBiz tskTaskBiz, List<TbtskFields> fieldsList,
                                 String ids,Boolean isAppSubmit, String userId, String userIds) throws Exception {
        logger.info("日常任务下载 开始导出数据 ");
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String databaseFile = ExportDataUtils.copyDataBaseFile(resultDbFileDir, this.template, null);
            connTool = new SqlliteConnTool(databaseFile);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);
            this.createExportData(resultDbFileDir, conn, ps, tbtskObjectinfo, tskTaskBiz, fieldsList, ids, isAppSubmit, userId, userIds);

            ExportDataUtils.closeConn(connTool, conn, ps);
        } catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            throw e;
        } finally {
            ExportDataUtils.closeConn(connTool, conn, ps);
        }
    }
    @Override
    public void createExportData(String DbFileDir,String taskId, String ids) throws Exception{

        TskTaskBiz tskTaskBiz = Optional.ofNullable(taskId)
                .map(tskTaskBizService::findByTaskId)
                .orElseThrow(()-> new RuntimeException("无效的bizId"));
        TbtskObjectinfo objectinfo = Optional.ofNullable(tskTaskBiz.getTableId())
                .map(tbtskObjectinfoService::getObjectbyID)
                .orElseThrow(RuntimeException::new);
        List<TbtskFields> fields = Optional.ofNullable(objectinfo.getfTablename())
                .map(tbtskFieldsService::getAllFieldsByTables)
                .orElseThrow(()-> new RuntimeException("字段配置错误"));
        this.createExportData(DbFileDir,objectinfo,tskTaskBiz,fields,ids,false,null,null);

    }
    /**
     * 在指定目录生成导出文件，重载2
     * @param resultDbFileDir 成果db所在路径(新生成的db存放的路径)
     * @param conn db连接配置
     * @param pre  db连接配置
     * @param tbtskObjectinfo 任务配置信息
     * @param tskTaskBiz 任务配置信息
     * @param fieldsList 任务配置信息
     * @param ids 图斑筛选
     * @param isAppSubmit 是否app提交
     * @param userId 用于步移式选址获取pdf文件
     * @param userIds 自动下发到用户
     */
    private void createExportData(String resultDbFileDir,Connection conn, PreparedStatement pre,
                                  TbtskObjectinfo tbtskObjectinfo,TskTaskBiz tskTaskBiz, List<TbtskFields> fieldsList,
                                  String ids, Boolean isAppSubmit, String userId, String userIds) throws Exception {
        logger.info("开始写入Tbtsk_task_biz");//增加biz信息，为了在外网数据至内网时判断任务类型（步移式选址需要）
        String busiCode = taskBusiCodeApater2_0Service.getBusiCode(tskTaskBiz);
//        this.insertBizData(conn, pre, tskTaskBiz);
        this.insertBizData(conn, pre, tskTaskBiz.getId());
        TbtskObjectinfo childInfo = null;
        if (tskTaskBiz.getPmEnable() ==1 ) {//与子表
            List<TbtskObjectinfo> childList = this.tbtskObjectinfoService.getObjectByParentObjId(tbtskObjectinfo.getfId());
            if (!childList.isEmpty())
                childInfo = childList.get(0);
        }
        if (isAppSubmit) {//app提交，只导出多媒体信息和下发信息
            logger.info("开始写入tb_app_media");
            this.insertAppMedia(conn, pre, tbtskObjectinfo.getfTablename(), resultDbFileDir, ids);
            logger.info("开始写入tbtsk_assign_record");
            this.insertAssign(conn, pre, tskTaskBiz.getId(), ids);
            if ("BYSXZ".equals(busiCode)) {//导出建设用地选址检测结果pdf
                this.insertBysxz(conn, pre, tbtskObjectinfo.getfTablename(), resultDbFileDir, ids, userId);
            }
        } else if (null == ids || StringUtils.isEmpty(ids)) {//如果不是空，只导出数据表，不导出下面的表
            logger.info("开始写入tbtsk_objectinfo");
            this.insertObjectInfo(conn, pre, tbtskObjectinfo.getfId());
            if (null != childInfo)
                this.insertObjectInfo(conn, pre, childInfo.getfId());

            logger.info("开始写入tb_app_media");
            this.insertAppMedia(conn, pre, tbtskObjectinfo.getfTablename(), resultDbFileDir, null);
            logger.info("开始写入tbsys_user_biz2");
            this.insertUserBiz(conn, pre, tskTaskBiz.getId());

            logger.info("开始写入tbtsk_group");
            this.insertGroup(conn, pre, tbtskObjectinfo.getfTablename());
            logger.info("开始写入tbtsk_assign_record");
            this.insertAssign(conn, pre, tskTaskBiz.getId(), null);
            logger.info("开始写入tbtsk_task_ntzy_project");
            this.insertProjectInfoData(conn, pre, tbtskObjectinfo.getfId());
            logger.info("开始吸入check表");
            this.insertCheckData(conn, pre, fieldsList);
            logger.info("开始写入tbtsk_task_project_ntzy_statistics");
            this.insertStatistics(conn, pre, tbtskObjectinfo.getfId());
        } else if (BusiType.Bysxz.equals(busiCode) || BusiType.Spba.equals(busiCode) || BusiType.Jcjg.equals(busiCode)
                || BusiType.PHJG.equals(busiCode)|| BusiType.JDJC.equals(busiCode) || BusiType.JCPH.equals(busiCode)) {
            //需外网下发的数据需要
            logger.info("开始写入tbtsk_objectinfo");
            this.insertObjectInfo(conn, pre, tbtskObjectinfo.getfId());
            logger.info("开始写入tbtsk_group");
            this.insertGroup(conn, pre, tbtskObjectinfo.getfTablename());
            if (null != childInfo)
                this.insertObjectInfo(conn, pre, childInfo.getfId());
            if (BusiType.Jcjg.equals(busiCode)|| BusiType.JDJC.equals(busiCode)) {
                //如果是耕地监测任务，该任务可能是内网创建，所以需将需要的信息传递至外网
                logger.info("开始写入tbtsk_task_ntzy_project");
                this.insertProjectInfoData(conn, pre, tbtskObjectinfo.getfId());
                logger.info("开始写入tbtsk_task_project_ntzy_statistics");
                this.insertStatistics(conn, pre, tbtskObjectinfo.getfId());
                logger.info("开始写入tbsys_user_biz2");
                this.insertUserBiz(conn, pre, tskTaskBiz.getId());
            }
        }
        logger.info("开始写入数据表");
        this.insertTableData(conn, pre, fieldsList, ids, userIds);
        logger.info("开始写入tbtsk_fields");
        this.insertFields(conn, pre, tbtskObjectinfo.getfId());
        if (childInfo != null) {
            String childrenIds = this.getChildrenIds(tbtskObjectinfo, childInfo, ids);
            if (!StringUtils.isEmpty(childrenIds)) {
                List<TbtskFields> childFiledList = tbtskFieldsService.getAllFieldsByTables(childInfo.getfTablename());
                this.insertTableData(conn, pre, childFiledList, childrenIds, null);
                this.insertFields(conn, pre, childInfo.getfId());
                this.insertGroup(conn, pre, childInfo.getfTablename());
                if (!"lan".equals(this.applicationType))
                    this.insertAppMedia(conn, pre, childInfo.getfTablename(), resultDbFileDir, childrenIds);
            }
        }
    }

    /**
     * 导出tbtsk_objectinfo
     * @param connection
     * @param pre
     * @param tableId
     * @throws Exception
     */
    private void insertObjectInfo(Connection connection, PreparedStatement pre, String tableId) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_objectinfo"));
        String insertSql = "INSERT INTO 'tbtsk_objectinfo' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "SELECT * from tbtsk_objectinfo t where t.f_id = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 导出数据表
     * @param connection
     * @param pre
     * @param fieldsList
     * @throws Exception
     */
    private void insertTableData(Connection connection, PreparedStatement pre, List<TbtskFields> fieldsList,
                                 String ids, String userIds) throws Exception {
        String tableName = fieldsList.get(0).getfTablename();
        String create = "CREATE TABLE '" + tableName + "' (";
        String insert = "INSERT INTO '" + tableName + "' (";
        String insertEnd = " VALUES (";
        boolean flag = true;
        for (int i = 0; i < fieldsList.size(); i++) {
            String field = fieldsList.get(i).getfFieldname();
            create += "'" + field + "'" + this.getTypeSql(fieldsList.get(i));
            insert += "'" + field + "'";
            insertEnd += "?";
            if (i != fieldsList.size()-1) {
                create += ",";
                insert += ",";
                insertEnd += ",";
            }
            if (field.equals("f_sendto")) {
                flag = false;
            }
        }
        if (flag && !StringUtils.isEmpty(userIds)) {
            create += ",'f_sendto' text";
            insert += ",'f_sendto'";
            insertEnd += ",?";
        }
        create += ")";
        insert += ")";
        insertEnd += ")";
        insert += insertEnd;
        pre = connection.prepareStatement(create);
        pre.execute();

        String sql1 = "select * from " + tableName ;
        if (null != ids && !StringUtils.isEmpty(ids)) {
            sql1 += " WHERE f_id in (";
            sql1 += this.getInSql(ids);
            sql1 += ")";
        }
        List<Map<String, Object>> mapList = this.jdbcTemplate.queryForList(sql1);
        pre = connection.prepareStatement(insert);
        for (int i = 0; i < mapList.size(); i++) {
            Map<String, Object> map = mapList.get(i);
            for (int j = 0; j < fieldsList.size(); j++) {
                this.setTableData(pre, fieldsList.get(j), map, j + 1);
            }
            if (!StringUtils.isEmpty(userIds)) {
                pre.setString(fieldsList.size() + 1, userIds);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    /**
     * 导出Check表
     * @param connection
     * @param pre
     * @param fieldsList
     * @throws Exception
     */
    private void insertCheckData(Connection connection, PreparedStatement pre, List<TbtskFields> fieldsList) throws Exception {
        String tableName = fieldsList.get(0).getfTablename();
        String checkName = tableName + "_check";
        boolean hasTable = this.isTableExist(checkName);
        if (!hasTable) {
            return;
        }
        List<String> fieldCheck = new ArrayList<>();
        fieldCheck.add("f_id");
        fieldCheck.add("f_pid");
        fieldCheck.add("f_createtime");
        fieldCheck.add("f_userid");
        fieldCheck.add("f_username");
        fieldCheck.add("f_checktime");
        fieldCheck.add("f_sign");

        String create = "CREATE TABLE '" + checkName + "' ('f_id' varchar(100),'f_pid' varchar(100)" +
                ",'f_createtime' varchar(100),'f_userid' varchar(100),'f_username' varchar(100)," +
                "'f_checktime' varchar(100),'f_sign' text";
        String insert = "INSERT INTO '" + checkName + "' ('f_id','f_pid','f_createtime','f_userid'" +
                ",'f_username','f_checktime','f_sign'";
        String insertEnd = " VALUES (?,?,?,?,?,?,?";
        String[] existsArr = {"f_id","f_pid","f_createtime","f_userid","f_username","f_checktime","f_sign"};
        for (int i = 0; i < fieldsList.size(); i++) {

            if (fieldsList.get(i).getfIsOutwork() != null &&1 != fieldsList.get(i).getfIsOutwork()) {
                continue;
            }
            String field = fieldsList.get(i).getfFieldname();
            boolean flag = Arrays.asList(existsArr).contains(field);
            if(!flag){
                fieldCheck.add(field);
                create += ",'" + field + "'" + this.getTypeSql(fieldsList.get(i));
                insert += ",'" + field + "'";
                insertEnd += ",?";
            }
        }
        create += ")";
        insert += ")";
        insertEnd += ")";
        insert += insertEnd;
        pre = connection.prepareStatement(create);
        pre.execute();

        String sql1 = "select * from " + checkName + " ;";
        List<Map<String, Object>> mapList = this.jdbcTemplate.queryForList(sql1);
        pre = connection.prepareStatement(insert);
        for (int i = 0; i < mapList.size(); i++) {
            Map<String, Object> map = mapList.get(i);
            for (int j = 0; j < fieldCheck.size(); j++) {
                this.setTableData2(pre, fieldCheck, map, j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    /**
     * 导出tbtsk_task_project_ntzy_statistic
     * @param connection
     * @param pre
     * @param tableId
     * @throws Exception
     */
    private void insertStatistics(Connection connection, PreparedStatement pre, String tableId) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_task_project_ntzy_statistic"));
        String insertSql = "INSERT INTO 'tbtsk_task_project_ntzy_statistic' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "SELECT * from tbtsk_task_project_ntzy_statistic t where t.f_tableid = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 数据表是否存在
     * @param tableName
     * @return
     */
    private boolean isTableExist(String tableName) {
        if(tableName.contains(".")){
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        String sql = "select count(*) as f_count from pg_class where relname = '" + tableName + "'";
        Map<String, Object> map = this.jdbcTemplate.queryForMap(sql);
        if (0 == Integer.valueOf(map.get("f_count").toString())) {
            return false;
        } else {
            return true;
        }
    }

    private String getTypeSql(TbtskFields fields) {
        if ("varchar".equals(fields.getfFieldtype())) {
            return " varchar(" + fields.getfLength() + ")";
        } else if ("text".equals(fields.getfFieldtype())) {
            return " text";
        } else if ("geometry".equals(fields.getfFieldtype())) {
            return " text";
        } else {
            return " varchar(100)";
        }
//        else if ("decimal".equals(fields.getfFieldtype())) {
//            return " numeric(" + fields.getfLength() + "," + fields.getfPrecision() + ")";
//        } else if (fields.getfFieldtype().indexOf("int") != -1) {
//            return " int4";
//        } else {
//            return " varchar";
//        }
    }

    /**
     * 保存数据表
     * @param pre
     * @param fields
     * @param map
     * @param index
     * @throws SQLException
     */
    private void setTableData(PreparedStatement pre, TbtskFields fields, Map<String, Object> map, int index) throws SQLException {
        if (null == map.get(fields.getfFieldname())) {
            pre.setString(index, null);
        } else {
            pre.setString(index, map.get(fields.getfFieldname()).toString());
        }
//        if ("varchar".equals(fields.getfFieldtype()) || "geometry".equals(fields.getfFieldtype()) ||
//                "text".equals(fields.getfFieldtype())) {
//            if (null == map.get(fields.getfFieldname())) {
//                pre.setString(index, null);
//            } else {
//                pre.setString(index, map.get(fields.getfFieldname()).toString());
//            }
//        } else if ("decimal".equals(fields.getfFieldtype())) {
//            if (null == map.get(fields.getfFieldname())) {
//                pre.setDouble(index, 0);
//            } else {
//                pre.setDouble(index, (Double) map.get(fields.getfFieldname()));
//            }
//        } else if (fields.getfFieldtype().indexOf("int") != -1) {
//            if (null == map.get(fields.getfFieldname())) {
//                pre.setInt(index, 0);
//            } else {
//                pre.setInt(index, (Integer) map.get(fields.getfFieldname()));
//            }
//        } else {
//            pre.setString(index, map.get(fields.getfFieldname()).toString());
//        }
    }

    private void setTableData2(PreparedStatement pre, List<String> fields, Map<String, Object> map, int index) throws SQLException {
        if (null == map.get(fields.get(index - 1))) {
            pre.setString(index, null);
        } else {
            pre.setString(index, map.get(fields.get(index - 1)).toString());
        }
    }

    /**
     * 导出tb_app_media，并导出多媒体数据
     * @param connection
     * @param pre
     * @param tableName
     * @throws Exception
     */
    private void insertAppMedia(Connection connection, PreparedStatement pre, String tableName,
                                String resultDbFileDir, String ids) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tb_app_media"));
        String insertSql = "INSERT INTO 'tb_app_media' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tb_app_media t where t.f_galleryid in (select f_id from " + tableName ;
        if (!StringUtils.isEmpty(ids)) {
            String idsql = this.getInSql(ids);
            dataSql += " WHERE f_id in (" + idsql + ")";
        }
        dataSql += ");";

        pre = connection.prepareStatement(insertSql);
        List<Map<String, Object>> mapList = this.jdbcTemplate.queryForList(dataSql);
        if (mapList.size() == 0) {
            return;
        }
        for (int i = 0; i < mapList.size(); i++) {
            Map<String, Object> map = mapList.get(i);
            this.insertMedias(map, resultDbFileDir);
            for (int j = 0; j < fieldArray.length; j++) {
                ExportDataUtils.setStringData(pre, map, fieldArray[j], j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    /**
     * 导出tbsys_user_biz2
     * @param connection
     * @param pre
     * @param bizid
     * @throws Exception
     */
    private void insertUserBiz(Connection connection, PreparedStatement pre, String bizid) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbsys_user_biz2"));
        String insertSql = "INSERT INTO 'tbsys_user_biz2' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbsys_user_biz2 t where t.f_bizid = '" + bizid + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 插入tbtsk_fields
     * @param connection
     * @param pre
     * @param tableId
     * @throws SQLException
     */
    private void insertFields(Connection connection, PreparedStatement pre, String tableId)
            throws SQLException {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_fields"));
        String insertSql = "INSERT INTO 'tbtsk_fields' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_fields t where t.f_tableid = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 插入tbtsk_group
     * @param connection
     * @param pre
     * @param tablename
     * @throws SQLException
     */
    private void insertGroup(Connection connection, PreparedStatement pre, String tablename) throws SQLException {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_group"));
        String insertSql = "INSERT INTO 'tbtsk_group' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_group t where t.f_tablename = '" + tablename + "'";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 插入tbtsk_assign_record
     * @param connection
     * @param pre
     * @param taskId
     * @throws SQLException
     */
    private void insertAssign(Connection connection, PreparedStatement pre, String taskId,
                              String ids) throws SQLException {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_assign_record"));
        String insertSql = "INSERT INTO 'tbtsk_assign_record' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_assign_record t WHERE t.f_taskid = '" + taskId + "'";
        if (!StringUtils.isEmpty(ids)) {
            String idsql = this.getInSql(ids);
            dataSql += " and f_dataid in (" + idsql + ")";
        }
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 导入项目信息，基本农田占用使用tbtsk_task_ntzy_project
     * @param connection
     * @param pre
     * @param tableId
     * @throws Exception
     */
    private void insertProjectInfoData(Connection connection, PreparedStatement pre, String tableId) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_task_ntzy_project"));
        String insertSql = "INSERT INTO 'tbtsk_task_ntzy_project' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_task_ntzy_project where f_tableid = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    /**
     * 保存多媒体信息
     * @param map
     * @param resultDbFileDir
     */
    private void insertMedias(Map<String, Object> map, String resultDbFileDir) {
        if (null == map.get("f_serverpath") || StringUtils.isEmpty(map.get("f_serverpath").toString())) {
            return;
        }
        String serverPath = map.get("f_serverpath").toString();
        //以http://开头截断站点域名
        if(serverPath.toLowerCase().startsWith("http://")){
            int pathIndex = serverPath.indexOf("/",7);
            serverPath = serverPath.substring(pathIndex + 1);
        }
        String[] paths = serverPath.split("/");
        String mediaPath = resultDbFileDir;
        for (int i = 0; i < paths.length - 1; i++) {
            mediaPath += File.separator + paths[i];
        }
        String url = "";
        if (null == map.get("f_downloadurl") || StringUtils.isEmpty(map.get("f_downloadurl").toString())) {
//            url = serverPath;
            url = map.get("f_serverpath").toString();
        } else {
            url = map.get("f_downloadurl").toString();
        }
        String mediaName = paths[paths.length - 1];

//        File file = new File(mediaPath, mediaName);
//        if (!file.exists())
        try {
            if (StringUtils.isNotBlank(url)) {
                if (url.startsWith("https://pan.jfunbox.com")) {
                    FileUtils.copyURLToFile(new URL(url), new File(mediaPath, mediaName));
                } else {
                    // 从华为obs云盘下载附件需要先获取授权地址
                    url = temporarySignedUrlService.getTemporarySignedUrl("", url, null);
                    FileUtils.copyURLToFile(new URL(url), new File(mediaPath, mediaName));
                }
            }
        } catch (IOException e) {
            logger.error(e);
            e.printStackTrace();
        }
    }

    /**
     * 数据插入模板
     * @param connection
     * @param pre
     * @param insertSql 插入数据sql
     * @param dataSql 获取数据sql
     * @param fieldArray 字段数组
     * @throws SQLException
     */
    private void insertTeml(Connection connection, PreparedStatement pre, String insertSql, String dataSql,
                            String[] fieldArray) throws SQLException {
        pre = connection.prepareStatement(insertSql);
        List<Map<String, Object>> mapList = this.jdbcTemplate.queryForList(dataSql);
        for (int i = 0; i < mapList.size(); i++) {
            Map<String, Object> map = mapList.get(i);
            for (int j = 0; j < fieldArray.length; j++) {
                ExportDataUtils.setStringData(pre, map, fieldArray[j], j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void setNumberData(PreparedStatement pre, Object obj, int index) throws SQLException {
        if (null == obj) {
            pre.setString(index, null);
        } else {
            pre.setString(index, (String) obj);
        }
    }

    private File buildTempUploadFile(String userid){
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("task-%s-%s-%s.db", userid,sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(uploadDir, fileName);
    }

    private void createSubmitTxt(String path, String bizId) throws Exception {
        List<String> data = new ArrayList<>();
        data.add("submitProject");
        data.add(bizId);
        this.exportTxtService.writeTxtData(data, path, false);
    }

    /**
     * 添加步移式选址pdf，获取mark为1的报告文件
     * @param connection
     * @param pre
     * @param tableName
     * @param resultDbFileDir
     * @param ids
     * @param userId
     */
    private void insertBysxz(Connection connection, PreparedStatement pre, String tableName,
                             String resultDbFileDir, String ids, String userId) throws Exception {
        String inString = this.getInSql(ids);
        String requestSql = "select f_requestid, f_bjbh from " + tableName + " where f_id in (" + inString + ");";
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(requestSql);

        List<String> requestList = new ArrayList<>();
        Map<String, String> requestMap = new HashMap<>();
        for (int i = 0; i < dataList.size(); i++) {
            Map<String, Object> obj = dataList.get(i);
            String requestId = (String) obj.get("f_requestid");
            if (!StringUtils.isEmpty(requestId)) {
                requestMap.put(requestId, (String) obj.get("f_bjbh"));
                requestList.add(requestId);
            }
        }

//        LandUser user = this.landUserDao.queryUserById(Long.valueOf(userId));
//        String url = this.getPdfUrl("3a6a35c9-f7e6-474b-af66-942320f0ff98", user.getName(), 1, "建设用地选址", "http://114.116.76.9:8081");
//        String fileName = requestMap.get("3a6a35c9-f7e6-474b-af66-942320f0ff98") + ".pdf";
//        FileUtils.copyURLToFile(new URL(url), new File(resultDbFileDir, fileName));

        //只获取村镇选址
        List<CloudQuery> cloudQueryList = this.cloudQueryDao.getByRequestIdAndMark(requestList);
        if (cloudQueryList.isEmpty())
            return;
        LandUser user = this.landUserDao.queryUserById(Long.valueOf(userId));
        for(int i = 0; i < cloudQueryList.size(); i++) {
            CloudQuery obj = cloudQueryList.get(i);
            String requestId = obj.getRequestId();
            String tag = obj.getTag();
            if (!"村镇选址".equals(tag) || null == obj.getResult()) {
                continue;
            }
            String fileName = requestMap.get(requestId) + ".pdf";
            File file = new File(resultDbFileDir, fileName);
          /*  this.analyzeCQService.createPdfFile(requestId, user.getRname(), 1, "村镇选址", 1, file.getPath());*/
            break;
        }
    }

    /**
     * 如果是外网且是内网回退的任务，需在外网导出的时候将回退任务主键发送至内网
     * @param bizId
     * @return
     */
    private void createBackTxt(String path, String bizId) throws Exception {
        String sql1 = "select f_id from tbtsk_task_ntzy_project where f_biz_id = '" + bizId + "';";
        List<Map<String, Object>> data1 = this.jdbcTemplate.queryForList(sql1);
        if (data1.isEmpty()) {
            return;
        }
        String newProjectId = (String) data1.get(0).get("f_id");
        String sql = "select f_id from tbtsk_task_biz_history where f_newid = '" + bizId + "';";
        List<Map<String, Object>> data = this.jdbcTemplate.queryForList(sql);
        if (data.isEmpty()) {
            return;
        }
        String oldBizId = (String) data.get(0).get("f_id");
        List<String> resultList = new ArrayList<>();
        resultList.add(InterfaceType.backLan);
        JSONObject object = new JSONObject();
        object.put("oldBizId", oldBizId);
        object.put("newBizId", bizId);
        object.put("newProjectId", newProjectId);
        resultList.add(object.toJSONString());
        this.exportTxtService.writeTxtData(resultList, path, false);
    }

    /**
     * 获取表字段及字段类型
     * @param tableName
     * @return
     */
    private List<Map<String, Object>> getFields(String tableName) {
        if(tableName.contains(".")){
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        String attributeSql = "select atttypid,attname from pg_attribute where attrelid = " +
                "(select oid from pg_class where relname = '" + tableName + "') and attname like 'f_%' ORDER BY atttypid;";
//        List<Map<String, Object>> list = this.jdbcTemplate.queryForList(attributeSql);
//        Map<String, String> resultMap = new HashMap<>();
//        for (int i = 0; i < list.size(); i++) {
//            Map<String, Object> map = list.get(i);
//        }
        return this.jdbcTemplate.queryForList(attributeSql);
    }

    private String[] getFieldArray(List<Map<String, Object>> data){
        String[] result = new String[data.size()];
        for (int i = 0; i < data.size(); i++) {
            Map<String, Object> map = data.get(i);
            result[i] = map.get("attname").toString();
        }
        return result;
    }

    private void insertBizData(Connection connection, PreparedStatement pre, String id) throws Exception {
        String tablename = "tbtsk_task_biz";
        String[] fieldArray = this.getFieldArray(this.getFields(tablename));
        String insertSql = "INSERT INTO '" + tablename + "' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from " + tablename + " t where t.f_id = '" + id + "'";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private String getInSql(String ids) {
        String[] idArray = ids.split(",");
        String idsql = "";
        for (int i = 0; i < idArray.length; i++) {
            idsql += "'" + idArray[i] + "'";
            if (i != idArray.length - 1) {
                idsql += ",";
            }
        }
        return idsql;
    }

    private String getChildrenIds(TbtskObjectinfo parent, TbtskObjectinfo child, String ids) {
        String relfield = child.getRelfield();
        if (StringUtils.isEmpty(relfield)) {
            return "";
        }
        JSONObject relJson = JSONObject.parseObject(relfield);
        String parentFiled = relJson.getString("parentFieldName");
        String childFiled = relJson.getString("fieldName");

        String sql = "select f_id from " + child.getfTablename() + " where " + childFiled + " in " +
                "(select " + parentFiled + " from " + parent.getfTablename() + " where f_id in (" + this.getInSql(ids) + "));";
        String result = "";
        List<Map<String, Object>> dataList = this.jdbcTemplate.queryForList(sql);
        for (int i = 0; i < dataList.size(); i++) {
            result += dataList.get(i).get("f_id");
            if (i != dataList.size() - 1)
                result += ",";
        }
        return result;
    }
}
