package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ParamType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.UpdateType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ValueType;
import com.geoway.landteam.landcloud.model.datatransfer.dto.DataOperate;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportJsonService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by licong on 2021/9/17.
 */
@Service
public class ExportJsonServiceImpl implements ExportJsonService {
    private  static GiLoger logger = GwLoger.getLoger(ExportJsonServiceImpl.class);
   /* @Value("#{imeSettings['project.submitDir']}")*/
    @Value("${project.submitDir}")
    protected String submitDir;

    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    private TskTaskBizService tskTaskBizService;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private TbtskFieldsService tbtskFieldsService;

    @Override
    public void deleteTaskData(String dataIds, String taskId) throws IOException {
        TskTaskBiz biz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo objectinfo = this.tbtskObjectinfoService.getObjectbyID(biz.getTableId());
        String tableName = objectinfo.getfTablename();
        String[] idArray = dataIds.split(",");
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < idArray.length; i++) {
            JSONObject object = new JSONObject();
            object.put("type", UpdateType.DEL);
            object.put("table", tableName);
            object.put("data", new JSONArray());
            JSONArray paramArray = new JSONArray();
            JSONObject paramObject = this.createParamObject("f_id", idArray[i], ValueType.TYPE_STRING, ParamType.TYPE_EQ);
            paramArray.add(paramObject);
            object.put("param", paramArray);
            resultArray.add(object);
        }
        this.writeJson(resultArray.toString(), InterfaceType.deleteTaskData);
    }

    @Override
    public void editTskTaskBiz(TskTaskBiz taskBiz) throws IOException {
        JSONArray resultArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("type", UpdateType.UPDATE);
        object.put("table", "tbtsk_task_biz");
        JSONArray dataArray = new JSONArray();
        if (StringUtils.isNotBlank(taskBiz.getName())) {
            dataArray.add(this.createDataObject("f_name", taskBiz.getName(), ValueType.TYPE_STRING));
        }

        if (StringUtils.isNotBlank(taskBiz.getDesc())) {
            dataArray.add(this.createDataObject("f_desc", taskBiz.getDesc(), ValueType.TYPE_STRING));
        }

        if (taskBiz.getStartTime() != null) {
            dataArray.add(this.createDataObject("f_starttime", taskBiz.getStartTime(), ValueType.TYPE_DATE));
        }

        if (taskBiz.getEndTime() != null) {
            dataArray.add(this.createDataObject("f_endtime", taskBiz.getEndTime(), ValueType.TYPE_DATE));
        }

        if (StringUtils.isNotBlank(taskBiz.getAllowEdit())) {
            dataArray.add(this.createDataObject("f_allownedit", taskBiz.getAllowEdit(), ValueType.TYPE_STRING));
        }

        if (StringUtils.isNotBlank(taskBiz.getAllowNew())) {
            dataArray.add(this.createDataObject("f_allownew", taskBiz.getAllowNew(), ValueType.TYPE_STRING));
        }

        if (StringUtils.isNotBlank(taskBiz.getNeedSign())) {
            dataArray.add(this.createDataObject("f_needsign", taskBiz.getNeedSign(), ValueType.TYPE_STRING));
        }

        if (taskBiz.getIsTmpl() != null) {
            dataArray.add(this.createDataObject("f_istmpl", taskBiz.getIsTmpl(), ValueType.TYPE_INT));
        }
        object.put("data", dataArray);

        JSONArray paramArray = new JSONArray();
        paramArray.add(this.createParamObject("f_id", taskBiz.getId(), ValueType.TYPE_STRING, ParamType.TYPE_EQ));
        object.put("param", paramArray);
        resultArray.add(object);
        this.writeJson(resultArray.toString(), "editTskTaskBiz");
    }

    @Override
    public void checkTaskData(Map<String, Object> data, String bizId, String dataId, String type, Long userId, String tableName) throws IOException {
        JSONArray resultArray = new JSONArray();
        //更新assign
        JSONObject assignObject = new JSONObject();
        assignObject.put("type", UpdateType.UPDATE);
        assignObject.put("table", "tbtsk_assign_record");
        //set
        JSONArray assignDataArray = new JSONArray();
        JSONObject assignDataObject = this.createDataObject("f_status", "1", ValueType.TYPE_INT);
        assignDataArray.add(assignDataObject);
        assignObject.put("data", assignDataArray);
        //where
        JSONArray paramArray = new JSONArray();
        JSONObject paramObject1 = this.createParamObject("f_dataid", dataId, ValueType.TYPE_STRING, ParamType.TYPE_EQ);
        JSONObject paramObject2 = this.createParamObject("f_assignto", userId, ValueType.TYPE_STRING, ParamType.TYPE_EQ);
        paramArray.add(paramObject1);
        paramArray.add(paramObject2);
        assignObject.put("param", paramArray);

        resultArray.add(assignObject);
        //更新数据表
        JSONObject tableObject = new JSONObject();
        tableObject.put("type", UpdateType.UPDATE);
        tableObject.put("table", tableName);
        //set
        List<TbtskFields> fieldsList = this.tbtskFieldsService.getAllFieldsByTables(tableName);
        Map<String, Object> fieldMap = new HashMap<>();
        for(int i = 0; i < fieldsList.size(); i++) {
            fieldMap.put(fieldsList.get(i).getfFieldname(), fieldsList.get(i).getfFieldtype());
        }
        JSONArray tableDataArray = new JSONArray();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String fieldType = (String) fieldMap.get(entry.getKey());
            if (StringUtils.isEmpty(fieldType))
                continue;
            JSONObject tempObject = this.createDataObject(entry.getKey(), entry.getValue(), ValueType.getType(fieldType));
            tableDataArray.add(tempObject);
        }
        tableObject.put("data", tableDataArray);
        //where
        JSONArray paramTableArray = new JSONArray();
        JSONObject paramObject3 = this.createParamObject("f_id", dataId, ValueType.TYPE_STRING, ParamType.TYPE_EQ);
        paramTableArray.add(paramObject3);
        tableObject.put("param", paramTableArray);

        resultArray.add(tableObject);

        this.writeJson(resultArray.toString(), "checkTaskData");
    }

    @Override
    public void updateTbData(String tablename, List<DataOperate> data, List<DataOperate> where) throws IOException {
        JSONArray resultArray = new JSONArray();
        //更新
        JSONObject updateObj = new JSONObject();
        updateObj.put("type", UpdateType.UPDATE);
        updateObj.put("table", tablename);
        //set
        JSONArray assignDataArray = new JSONArray();
        data.forEach(item -> {
            JSONObject object = this.createDataObject(item.getField(), item.getValue(), item.getValueType());
            assignDataArray.add(object);
        });
        updateObj.put("data", assignDataArray);
        //where
        JSONArray paramArray = new JSONArray();
        where.forEach(item -> {
            JSONObject object = this.createParamObject(item.getField(), item.getValue(), item.getValueType(), item.getParamType());
            paramArray.add(object);
        });
        updateObj.put("param", paramArray);
        resultArray.add(updateObj);
        this.writeJson(resultArray.toString(), InterfaceType.updateTbData);
    }

    @Override
    public void submitTask(List<String> ids, String tablename) throws IOException {
        List<DataOperate> data= new ArrayList<>();
        DataOperate item = new DataOperate("f_status", "4", ValueType.TYPE_INT);
        data.add(item);
        List<DataOperate> where= new ArrayList<>();
        DataOperate item3 = new DataOperate("f_id", StringUtils.join(ids, ","), ValueType.TYPE_STRING, ParamType.TYPE_IN);
        where.add(item3);
        this.updateTbData(tablename, data, where);

        List<DataOperate> data2= new ArrayList<>();
        DataOperate item2 = new DataOperate("f_status", "1", ValueType.TYPE_STRING);
        data2.add(item2);
        List<DataOperate> where2= new ArrayList<>();
        DataOperate item4 = new DataOperate("f_id", StringUtils.join(ids, ","), ValueType.TYPE_STRING, ParamType.TYPE_IN);
        where2.add(item4);
        this.updateTbData("tbtsk_assign_record", data2, where2);
    }

    /**
     * 生成json文件
     * @param json
     * @throws IOException
     */
    public void writeJson(String json, String type) throws IOException {
        String fileName = type + "_" + System.currentTimeMillis();
        String path = this.submitDir + File.separator + fileName + ".json";
        File file = new File(path);
        if(!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        try {
            out.write(json);
            out.flush();
        } finally {
            out.close();
            this.fileTransferService.sendFile(path);
            file.delete();
        }
    }

    /**
     * 创建数据更新json
     * @param key
     * @param value
     * @param valueType
     * @return
     */
    private JSONObject createDataObject(String key, Object value, Integer valueType) {
        JSONObject object = new JSONObject();
        object.put("key", key);
        object.put("value", value);
        object.put("valueType", valueType);
        return object;
    }

    /**
     * 创建数据过来条件json
     * @param key
     * @param value
     * @param valueType
     * @param paramType
     * @return
     */
    private JSONObject createParamObject(String key, Object value, Integer valueType, Integer paramType) {
        JSONObject object = new JSONObject();
        object.put("key", key);
        object.put("value", value);
        object.put("valueType", valueType);
        object.put("paramType", paramType);
        return object;
    }
}
