package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbBizProjectHistory;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectHistoryRepository;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by licong on 2021/9/17.
 */
@Service
public class ExportTxtServiceImpl implements ExportTxtService {
    /*@Value("#{imeSettings['project.submitDir']}")*/
    @Value("${project.submitDir}")
    protected String submitDir;

    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    private TbBizProjectRepository projectDao;
    @Autowired
    private TbBizProjectHistoryRepository projectHistoryDao;

    @Override
    public void reviewProjectLan(String bizId, String message, String checkId, String checkStatus) throws Exception {
        List<String> resultList = new ArrayList<>();
        resultList.add(InterfaceType.backProject);
        JSONObject object = new JSONObject();
        object.put("bizId", bizId);
        object.put("message", JSONObject.parse(message));
        object.put("checkId", checkId);
        object.put("checkStatus", checkStatus);
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    @Override
    public void deleteTask(String taskId, Long userId,Boolean sync) throws Exception {
        List<String> resultList = new ArrayList<>();
        resultList.add(InterfaceType.deleteTask);
        JSONObject object = new JSONObject();
        object.put("taskId", taskId);
        object.put("userId", userId);
        object.put("sync", sync);
        //内网回退任务在外网创建了副本没同步到内网（不提交的情况下同步没意义故不做同步处理）
        //因此如果是回退的任务且需要苍穹同步删除的情况下需要给苍穹传历史bizId
        if(sync){
            TaskBizProject newProject = this.projectDao.findOneByBizId(taskId);

            if(newProject != null && "3".equals(newProject.getCheckStatus()) ){//项目是回退状态
                String newId = newProject.getId();
                TbBizProjectHistory history = projectHistoryDao.findByNewId(newId);
                if(history != null)
                    object.put("wyid",history.getBizId());
            }
        }
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    @Override
    public void sendTask(JSONObject data, Boolean isWhole) throws Exception {
        List<String> resultList = new ArrayList<>();
        if (isWhole) {
            resultList.add("sendTaskWhole");
        } else {
            resultList.add("sendTask");
        }
        resultList.add(data.toJSONString());
        this.writeTxtData(resultList, this.submitDir,true);
    }

    @Override
    public void updateJbnt(String json, String interfaceName) throws Exception {
        List<String> resultList = new ArrayList<>();
        resultList.add(interfaceName);
        JSONObject object = new JSONObject();
        object.put("message", JSONObject.parse(json));
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    @Override
    public void backItem(String bizId, String tbids, String reason) throws Exception {
        JSONObject object = new JSONObject();
        object.put("bizId", bizId);
        object.put("tbids", tbids);
        object.put("reason", reason);
        List<String> resultList = new ArrayList<>();
        resultList.add(InterfaceType.backItem);
        object.put("message", object);
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    /**
     * 两行，第一行是接口名称，第二行是参数json
     * @param result
     * @return
     * @throws Exception
     */
    public boolean writeTxtData(List<String> result, String path, boolean send) throws Exception{
        String fileName = result.get(0);
        return this.writeTxtData(result, path, send, fileName);
    }

    public boolean writeTxtData(List<String> result, String path, boolean send, String fileName) throws Exception{
        boolean flag = false;
        BufferedWriter out = null;
        File file = null;
        long timeName = System.currentTimeMillis();
        try {
            if (result != null && !result.isEmpty()) {
                fileName += "_" + timeName + ".txt";
                File pathFile = new File(path);
                if (!pathFile.exists()) {
                    pathFile.mkdirs();
                }
                String relFilePath = path + File.separator + fileName;
                file = new File(relFilePath);
                if (!file.exists()) {
                    file.createNewFile();
                }
                out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file), "UTF-8"));
                for (String info : result) {
                    out.write(info);
                    out.newLine();
                }
                flag = true;

            }
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
                if (send && null != file) {
                    this.fileTransferService.sendFile(file.getPath());
                }
            }
            return flag;
        }
    }
}
