package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportZbphDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Map;

/**
 * Created by licong on 2021/3/19.
 */
@Service
public class ExportZbphDataServiceImpl implements ExportZbphDataService {
    private final String template = "zbph.db";
  /*  @Value("#{imeSettings['project.uploadDir']}")*/
    @Value("${project.uploadDir}")
    protected String uploadDir;
   /* @Value("#{imeSettings['project.submitDir']}")*/
    @Value("${project.submitDir}")
    protected String submitDir;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TaskResouceService taskResouceService;
    private GiLoger logger = GwLoger.getLoger(ExportZbphDataServiceImpl.class);

    @Override
    public void exportZbphData(Map<String, Object> map) throws Exception {
//        String safeFileName = new StringBuilder().append(System.currentTimeMillis()).toString();
        String resultDbFileDir = new StringBuilder().append(uploadDir).toString();
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String tempFileName = System.currentTimeMillis() + ".db";
            String databaseFile = ExportDataUtils.copyDataBaseFile(resultDbFileDir, this.template, tempFileName);
            connTool = new SqlliteConnTool(databaseFile);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);
            this.exportData(conn, ps, map);
            ExportDataUtils.closeConn(connTool, conn, ps);
            String sendPath = resultDbFileDir + File.separator + tempFileName;
            this.fileTransferService.sendFile( resultDbFileDir + File.separator + tempFileName, IdentityType.ZBPH);
            File file = new File(sendPath);
//            file.delete();
        } catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            throw e;
        } finally {
            ExportDataUtils.closeConn(connTool, conn, ps);
        }
    }

    private void exportData(Connection connection, PreparedStatement pre, Map<String, Object> map) throws Exception {
        String[] fieldArray = {"XZQDM", "XZQMC", "XMMC", "ZSBH", "XMZGBM", "GDZB", "STZB", "LSCNZB"};
        String insertSql = "INSERT INTO 'XZZB' (" +  ExportDataUtils.getInsertFields(fieldArray) +") ";
        insertSql += " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        pre = connection.prepareStatement(insertSql);
        Map<String, String> mapRel = this.getRel();
        for (int j = 0; j < fieldArray.length; j++) {
            if (j == 5) {
                //新增耕地指标=复垦新增耕地+开发整理新增耕地
                BigDecimal GDZB = new BigDecimal(0);
                if (map.get("f_fkxzgd") != null && !StringUtils.isEmpty(map.get("f_fkxzgd").toString())) {
                    GDZB.add(new BigDecimal( map.get("f_fkxzgd").toString()));
                }
                if (map.get("f_kfzlxzgd") != null && !StringUtils.isEmpty(map.get("f_kfzlxzgd").toString())) {
                    GDZB.add(new BigDecimal(map.get("f_kfzlxzgd").toString()));
                }
                pre.setString(j + 1, String.valueOf(GDZB));
            } else if (!map.containsKey(mapRel.get(fieldArray[j]))) {
                pre.setString(j + 1, null);
            } else {
                pre.setString(j + 1, String.valueOf(map.get(mapRel.get(fieldArray[j]))));
            }
        }
        pre.addBatch();

        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private Map<String, String> getRel() throws Exception {
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.zbphXzgd[0], ApiNameType.zbphXzgd[1]);
        String tablename = applicationApi.getTableid();
        return this.taskResouceService.getFiledMap(tablename);
    }
}
