package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.servface.datatransfer.FileResolver;
import org.apache.commons.io.FilenameUtils;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Optional;

/**
 * @Author Waves
 * @Date 2023/7/21
 * @Description
 **/
public class FileResolverProvider {

    @Resource
    private Map<String , FileResolver> FILE_RESOLVER_MAP;

    /**
     * 根据文件后缀类型获取文件解析器，后缀类型在解析器实现类的@Service("******")中定义,全都用小写！！！
     * @param suffix
     * @return
     */
    public final FileResolver getHandler(String suffix){
        return Optional.ofNullable(suffix)
                //增加前缀
                .map(FileResolver.PREFIX::concat)
                .map(String::toLowerCase)
                .map(FILE_RESOLVER_MAP::get)
                .orElseThrow(()-> new RuntimeException("未找到该类型文件解析器"));
    }

    public final boolean hasHandler(String suffix){
        return Optional.ofNullable(suffix)
                //增加前缀
                .map(FileResolver.PREFIX::concat)
                .map(String::toLowerCase)
                .map(FILE_RESOLVER_MAP::get)
                .isPresent();
    }

    public final void handle(String path) throws Exception{
        String suffix = FilenameUtils.getExtension(path);
        this.getHandler(suffix).resolve(path);
    }

    public final void handle(String path,String resolver) throws Exception{
        this.getHandler(resolver).resolve(path);
    }
}
