package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.util.DateUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.OptLog;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.model.datacq.entity.ConfigFiletransfer;
import com.geoway.landteam.landcloud.model.datacq.entity.TbtskQueryInfo;
import com.geoway.landteam.landcloud.model.datatransfer.constants.IdentityType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.repository.datacq.ConfigFiletransferRepository;
import com.geoway.landteam.landcloud.repository.datacq.TbtskQueryInfoRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.SignUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.SmbUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.io.*;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * Created by licong on 2020/8/12.
 */
@Service
public class FileTransferServiceImpl implements FileTransferService {

    private GiLoger logger = GwLoger.getLoger(FileTransferServiceImpl.class);
    @Value("${FileTransfer.url}")
    private String url;
    @Value("${project.filetrans:}")
    private String filetransPath;
    @Value("${FileTransfer.shareUrl:}")
    private String shareUrl;

    private final String configkey = "filetransferConfig";//文件传输配置
    private final String mapkey = "filetransferConfigMap";//文件传输配置
    private final String mapProgress = "filetransferProgress";//正在获取的文件
    private final String inProgress = "filetransferInProgress";//正在处理的文件
    private boolean isStart = false;

  /*  @Value("#{imeSettings['project.import.exchange']}")*/
    @Value("${project.import.exchange}")
    protected String dataFolder;
    @Autowired
    private RedisTemplate redisTemplate;

    @Autowired
    private TbtskQueryInfoRepository tbtskQueryInfoRepository;
    @Autowired
    private ConfigFiletransferRepository filetransferRepository;
    @Autowired
    private LogService logService;
    @Autowired
    private SysConfigService sysConfigService;

    protected JSONObject config;

    @Override
    public void sendFile(File file, String identity) throws Exception {
        if(config == null){
            config = Optional.of("transfer.config")
                        .map(sysConfigService::findToJson)
                        .orElseGet(JSONObject::new);
        }
        String url = config.getString("url");
        String app = config.getString("app");
        String module = config.getString("module");

        String filePath = file.getAbsolutePath();
        String path = FilenameUtils.getFullPathNoEndSeparator(filePath);
        String baseName = FilenameUtils.getBaseName(filePath);
        String filename = FilenameUtils.getName(filePath);
        String tempPath = path + File.separator + baseName;
        FileUtil.creatDirectoryIfNotExist(tempPath);
        File tempFile = new File(tempPath + File.separator + filename );
        file.renameTo(tempFile);

        //add matedata
        File mate = new File(tempPath + File.separator + baseName + ".meta");
        JSONObject mateinfo = new JSONObject();
        mateinfo.put("identity",identity);
        mateinfo.put("filename",baseName);
        mateinfo.put("time",new Date().toString());
        mate.createNewFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(mate));
        try {
            out.write(mateinfo.toJSONString());
            out.flush();
        } finally {
            out.close();
        }
        Zip4jUtils.zip(tempPath,null,false,null);

        File  zip = new File(tempPath + ".zip");
        ExportFileUtil.deleteFileAndDir(new File(tempPath));
        HttpUtil.sendRrquestByFile( app, module, zip, url);
    }

    @Override
    public void getFile() {
        if (this.isStart) {//服务单例
            return;
        }
        if (this.isInProgress()) {//集群单例，redis锁问题
            return;
        }
        try {
            JSONArray fileArray = this.getFileList();
            if (null == fileArray || fileArray.size() == 0) {
                return;
            }
            this.logger.debug("获取文件：" + fileArray.toString());
            for (int i = 0; i < fileArray.size(); i++) {
                JSONObject object = fileArray.getJSONObject(i);
                String fileId = object.getString("FileId");
                if (this.hasDownload(fileId))
                    continue;
                String IdentityID = object.getString("IdentityID");
                String fileName = object.getString("FileName");
                String SystemId = object.getString("SystemId");
                this.logger.debug("获取文件：" + IdentityID + "   " + fileId + "   " +  fileName + "\n");
                String path = this.saveFile(fileName, fileId, IdentityID, SystemId);
                this.saveLdlife(path, IdentityID, fileId);
            }
        } catch (Exception e) {
            this.logger.error(e);
        } finally {
            this.isStart = false;
            this.removeProgress();
        }
    }

    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Override
    public void sendFile(String filePath) throws UnsupportedEncodingException {
       /* FileSendThread thread = new FileSendThread(filePath, this);
        this.threadPoolTaskExecutor.execute(thread);*/
    }

    @Override
    public void sendFile(String filePath, String identity) throws Exception {
        if (StringUtils.isEmpty(identity)) {
            identity = IdentityType.WYDC;
        }
        File file = new File(filePath);
        this.sendFile(file, identity);
    }

    @Override
    public void deleteFiletrans(String fileName) {
        String filePath = this.filetransPath + File.separator + fileName;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    public void removeProgress() {
        if (this.redisTemplate.hasKey(this.mapProgress)) {
            this.redisTemplate.delete(this.mapProgress);
        }
    }

    private JSONArray getFileList() {
        List<ConfigFiletransfer> configList = this.getConfig();
        JSONArray result = new JSONArray();
        for (int i = 0; i < configList.size(); i++) {
            ConfigFiletransfer config = configList.get(i);
            String systemId = config.getSystemid();
            String identitys = config.getIdentitys();
            JSONArray array = this.getFileList(systemId);
            if (array.isEmpty())
                continue;
            for (int j = 0; j < array.size(); j++) {
                JSONObject object = array.getJSONObject(j);
                String IdentityID = object.getString("IdentityID");
                if (identitys.indexOf(IdentityID) > -1) {
                    object.put("SystemId", systemId);
                    result.add(object);
                }
            }
        }
        return result;
    }

    private JSONArray getFileList(String systemId) {
        CloseableHttpClient client = null;
        try {
            String getUrl = url + "/getfileinfo?SystemId=" + systemId + "&IsReady=true";
            HttpGet get = new HttpGet(getUrl);
            client =  HttpClients.createDefault();
//            client.getParams().setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT, 30000);
            HttpResponse response = null;
            response = client.execute(get);
            String result = IOUtils.toString(response.getEntity().getContent(), "utf-8");
            JSONObject resultObject = JSONObject.parseObject(result);
            if (!"200".equals(resultObject.getString("code"))) {
                return null;
            } else {
                return JSONArray.parseArray(resultObject.get("data").toString());
            }
        } catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            return null;
        } finally {
            try {
                client.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String saveFile(String fileName, String fileId, String IdentityID, String SystemId) throws IOException {
        //文件是否重复传输
        Boolean fileExisted = false;
        File filePath = new File(this.dataFolder + File.separator + IdentityID);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        //定义要保存的文件路径
        String savePath = this.dataFolder + File.separator + IdentityID + File.separator + fileName;
        File file = new File(savePath);

        //已解析的数据重复传输则删除传输信息,解析失败的数据认为不是重复
//        List<TbtskQueryInfo> queryInfos = tbtskQueryInfoRepository.queryListByPath(savePath, Arrays.asList(0,1,2));
//        if(queryInfos!= null && !queryInfos.isEmpty()) {
//            //正在解析的直接跳过等待完成
//            //解析完成且下载完成的删除
//            if(isProcessFinished(queryInfos) && !this.isInProgress()){
//                removeFileInfo(fileId, this.getConfigByIdentity(IdentityID));
//            }
//            return "";
//        }
        //如果文件目录不出在则创建目录
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream is = null;
        DataInputStream dataInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            String getFileUrl = this.url + "/receive?SystemId=" + SystemId + "&IdentityID=" + IdentityID + "&FileId=" + fileId;
//            String getFileUrl = this.url + "/receive";
            String signUrl = this.getSignUrl(getFileUrl, this.getConfigByIdentity(IdentityID));
//            signUrl += "&SystemId=" + SystemId + "&IdentityID=" + IdentityID + "&FileId=" + fileId;
            URL url = new URL(signUrl);
            //字节输入流
            is = url.openStream();
            //字节流转字符流
            dataInputStream = new DataInputStream(is);
            fileOutputStream = new FileOutputStream(file);
            //使用char 数组传输    -----字节流byte数组
            byte[] chs = new byte[1024];
            //标记
            int len = 0;
            while ((len = dataInputStream.read(chs)) != -1) {
                // read() 方法，读取输入流的下一个字节，返回一个0-255之间的int类型整数。如果到达流的末端，返回-1
                fileOutputStream.write(chs,0,len);
            }
        } finally {
            try {
                fileOutputStream.close();
                dataInputStream.close();
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty(this.shareUrl)) {
            String smbPath = this.shareUrl + "/data/" + IdentityID + "/" + fileName;
            SmbUtil.putFile(savePath, smbPath);
            return smbPath;
        } else {
            return savePath;
        }
    }

    private String sendPost(String strUrl, Map<String, String> parameters, File file){
        HttpClient client = HttpClientBuilder.create().build(); // 开启一个客户端 HTTP 请求
        HttpPost post = new HttpPost(strUrl);//创建 HTTP POST 请求
        long time = 0l;
        OptLog log = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (file.length() > 10000000) {//10M
            time = System.currentTimeMillis();
            JSONObject object = new JSONObject();
            object.put("file", file.getName());
            object.put("fileLength", file.length()/1000/1000 + "M");
            object.put("starttime", sdf.format(new Date()));
            log = this.logService.saveLog(LogType.startFileTranfer, object.toString());
        }
//        if (file.length() > 100000000) {
//            return "";
//        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if(file.exists()){
            builder.addBinaryBody("Content", file);
        }
        for (String key : parameters.keySet()) {
            builder.addTextBody(key, parameters.get(key));//设置请求参数
        }
        HttpEntity entity = builder.build();// 生成 HTTP POST 实体
        post.setEntity(entity);//设置请求参数
        post.setHeader("Url", this.url.split("/api")[0]);
        HttpResponse response;
        try {
            response = client.execute(post);
            if (response.getStatusLine().getStatusCode()== HttpStatus.SC_OK) {
                String result = IOUtils.toString(response.getEntity().getContent(), "UTF-8");
                if (file.length() > 10000000) {//10M
                    long time2 = System.currentTimeMillis();
                    JSONObject object = JSONObject.parseObject(log.getData());
                    object.put("endtime", sdf.format(new Date()));
                    object.put("time", (time2 - time)/1000 + "s");
                    log.setData(object.toString());
                    log.setOptType(LogType.endFileTranfer);
                    this.logService.saveLog(log);
                }
                return result;
            } else {
                this.logger.fatal("传输出错" + response.getStatusLine().toString());
//                throw new Exception(response.getStatusLine().toString());
            }
        } catch (ClientProtocolException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }// 发起请求 并返回请求的响应
        return "";
    }

    private String sendPost2(String strUrl, Map<String, String> parameters, File file){
        RestTemplate rest = new RestTemplate();
        FileSystemResource resource = new FileSystemResource(file);
        MultiValueMap<String, Object> param = new LinkedMultiValueMap<>();
        param.add("Content", resource);
        for (String key : parameters.keySet()) {
            param.add(key, parameters.get(key));//设置请求参数
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(new MediaType(MediaType.MULTIPART_FORM_DATA, Charset.forName("utf-8")));
//        headers.setContentType(MediaType.parseMediaType("multipart/form-data; charset=UTF-8"));
        org.springframework.http.HttpEntity<MultiValueMap<String, Object>> requestEntity = new org.springframework.http.HttpEntity<>(param,
                headers);
        String string = rest.postForObject(strUrl, requestEntity, String.class);
        return string;
    }

    private String getSignUrl(String url, ConfigFiletransfer filetransfer){
        Date date = new Date();
        long time = date.getTime();
        if (url.contains("?")) {
            url += "&";
        } else {
            url += "?";
        }
        url += "appkey=" + filetransfer.getAppkey() + "&timestamp=" + String.valueOf(time);
        String sign = SignUtil.getSign(url, filetransfer.getAppsecret());
        url += "&sign=" + sign;
        return url;
    }
    @Override
    public String getSignUrl( String appkey,String secret,Long time){
        String url =this.url + "/send";
        if (url.contains("?")) {
            url += "&";
        } else {
            url += "?";
        }
        url += "appkey=" + appkey + "&timestamp=" + String.valueOf(time);
        String sign = SignUtil.getSign(url, secret);
        url += "&sign=" + sign;
        return url;
    }

    private void getSignParam(String url, ConfigFiletransfer filetransfer, Map<String, String> parameters){
        Date date = new Date();
        long time = date.getTime();
        if (url.contains("?")) {
            url += "&";
        } else {
            url += "?";
        }
        url += "appkey=" + filetransfer.getAppkey() + "&timestamp=" + String.valueOf(time);
        String sign = SignUtil.getSign(url, filetransfer.getAppsecret());
        parameters.put("appkey", filetransfer.getAppkey());
        parameters.put("timestamp", String.valueOf(time));
        parameters.put("sign",sign);
    }

    private void saveLdlife(String path, String IdentityID, String id) {
        if(StringUtils.isEmpty(path)){
            return;
        }
        TbtskQueryInfo info = new TbtskQueryInfo();
        info.setId(id);
        info.setPath(path);
        info.setState(0);
        info.setLevel(0);
        info.setTime(DateUtils.getSysTime().toString());
        info.setRepeat(0);
        info.setType(IdentityID);
        this.tbtskQueryInfoRepository.save(info);
    }

    private List<ConfigFiletransfer> getConfig(){
        if (this.redisTemplate.hasKey(this.configkey)) {
            return (List<ConfigFiletransfer>) this.redisTemplate.opsForValue().get(this.configkey);
        } else {
            List<ConfigFiletransfer> list = this.filetransferRepository.getConfig();
            this.redisTemplate.opsForValue().set( this.configkey, list, 1, TimeUnit.DAYS);
            return list;
        }
    }

    private ConfigFiletransfer getConfigByIdentity(String identity){
        if (this.redisTemplate.hasKey(this.mapkey)) {
            Map<String, ConfigFiletransfer> map = (Map<String, ConfigFiletransfer>) this.redisTemplate.opsForValue().get(this.mapkey);
            if (!map.containsKey(identity))
                this.saveConfig(map, identity);
            return map.get(identity);
        } else {
            Map<String, ConfigFiletransfer> map = new HashMap<>();
            this.saveConfig(map, identity);
            return map.get(identity);
        }
    }

    private void saveConfig(Map<String, ConfigFiletransfer> map, String identity) {
        ConfigFiletransfer obj = this.filetransferRepository.getConfigByType(identity);
        map.put(identity, obj);
        this.redisTemplate.opsForValue().set( this.mapkey, map, 1, TimeUnit.DAYS);
    }

    private Boolean isInProgress(){
        if (this.redisTemplate.hasKey(this.mapProgress)) {
            return true;
        } else {
            this.redisTemplate.opsForValue().set( this.mapProgress, true, 1, TimeUnit.DAYS);
            return false;
        }
    }

    private void copyToFiletrans(File file) throws IOException {
        String fileName = file.getName();
        FileUtil.copyFile(file.getPath(), this.filetransPath + File.separator + fileName);
    }

    public Boolean isInProgress(String fileid){
        if (this.redisTemplate.hasKey(this.inProgress)) {
            Set<String> set = (Set<String>) this.redisTemplate.opsForValue().get(this.inProgress);
            if (!set.contains(fileid)) {
                set.add(fileid);
                this.redisTemplate.opsForValue().set( this.inProgress, set, 1, TimeUnit.DAYS);
                return false;
            } else {
                return true;
            }
        } else {
            Set<String> set = new HashSet<>();
            set.add(fileid);
            this.redisTemplate.opsForValue().set( this.inProgress, set, 1, TimeUnit.DAYS);
            return false;
        }
    }


    public void removeProgress(String fileid) {
        if (this.redisTemplate.hasKey(this.inProgress)) {
            Set<String> set = (Set<String>) this.redisTemplate.opsForValue().get(this.inProgress);
            set.remove(fileid);
            this.redisTemplate.opsForValue().set( this.inProgress, set, 1, TimeUnit.DAYS);
        }
    }

    private boolean removeFileInfo(String id,ConfigFiletransfer filetransfer) {
        CloseableHttpClient client = null;
        try {
            String baseurl= url + "/deleteByInfo?id=" + id;
            String getUrl = getSignUrl(baseurl,filetransfer) ;
            HttpGet get = new HttpGet(getUrl);
            client =  HttpClients.createDefault();
//            client.getParams().setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT, 30000);
            HttpResponse response = null;
            response = client.execute(get);
            String result = IOUtils.toString(response.getEntity().getContent(), "utf-8");
            JSONObject resultObject = JSONObject.parseObject(result);
            if (!"200".equals(resultObject.getString("code"))) {
                return false;
            } else {
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e);
            return false;
        } finally {
            try {
                client.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    private Boolean isProcessFinished(List<TbtskQueryInfo> queryInfos){
        Assert.notNull(queryInfos,"empty queryInfos");
        for(TbtskQueryInfo queryInfo :queryInfos){
            String key = queryInfo.getId();
            if (this.redisTemplate.hasKey(this.inProgress)) {
                Set<String> set = (Set<String>) this.redisTemplate.opsForValue().get(this.inProgress);
                if (set.contains(key)) {
                    return false;
                }
            }
        }
        return  true;
    }

    /**
     * 仍然存在重复下载问题
     * @param fileId
     * @return
     */
    private Boolean hasDownload(String fileId) {
        TbtskQueryInfo info = this.tbtskQueryInfoRepository.gwSearchByPK(fileId);
        if (null != info)
            return true;
        else
            return false;
    }
}
