package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.model.pub.dto.FtApplicationDto;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplicationToBusiness;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToBusinessRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.FtAppToBusinessService;
import com.gexin.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;

/**
 * Created by zhuyuchen on 2021/10/11.
 */
@Service
public class FtAppToBusinessServiceImpl implements FtAppToBusinessService {

    @Autowired
    private FtApplicationToBusinessRepository ftApplicationToBusinessRepository;

    public String addEntity(FtApplicationDto dto, Long userId){
        String id = UUID.randomUUID().toString();
        FtApplicationToBusiness ftApplication = new FtApplicationToBusiness();
        ftApplication.setSystemid(dto.getSystemid());
        ftApplication.setIdentityid(dto.getIdentityid());
        ftApplication.setDescription(dto.getDescription());
        ftApplication.setRegistrant(userId);
        ftApplication.setRegistertime(new Timestamp(System.currentTimeMillis()));
        ftApplication.setState(1);
        ftApplication.setReceive(1);
        ftApplication.setSend(1);
        ftApplicationToBusinessRepository.save(ftApplication);
        return id;
    }

    public List<FtApplicationToBusiness> findAll(){
        return (List<FtApplicationToBusiness>)ftApplicationToBusinessRepository.findAll();
    }

    public Page<FtApplicationToBusiness> findPageList(String filterParam, String sortParam, int start, int limit) {
        Page<FtApplicationToBusiness> results = ftApplicationToBusinessRepository.findAll(new QuerySpecification<FtApplicationToBusiness>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        return results;
    }

    public void updateEntity(FtApplicationDto dto){
        FtApplicationToBusiness ftApplication = JSONObject.parseObject(JSON.toJSONString(dto),FtApplicationToBusiness.class);
        ftApplicationToBusinessRepository.save(ftApplication);
    }

    public void deleteByIds(List<String> ids) {
        Iterable<FtApplicationToBusiness> entities = ftApplicationToBusinessRepository.findAllById(ids);
        if (null != entities) {
            for(FtApplicationToBusiness entity:entities){
                ftApplicationToBusinessRepository.delete(entity);
            }
        }
    }




}
