package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.model.pub.dto.FtApplicationDto;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplicationToBusiness;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplicationToSystem;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToBusinessRepository;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToSystemRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.FtAppToSystemService;
import com.gexin.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;

/**
 * Created by zhuyuchen on 2021/10/11.
 */
@Service
public class FtAppToSystemServiceImpl implements FtAppToSystemService {

    @Autowired
    private FtApplicationToSystemRepository ftApplicationToSystemRepository;
    @Autowired
    private FtApplicationToBusinessRepository ftApplicationToBusinessRepository;

    public String addEntity(FtApplicationDto dto, Long userId){
        String id = UUID.randomUUID().toString();
        FtApplicationToSystem ftApplication = new FtApplicationToSystem();
        ftApplication.setAppkey(dto.getAppkey());
        ftApplication.setSystemid(dto.getSystemid());
        ftApplication.setDescription(dto.getDescription());
        ftApplication.setRegistrant(userId);
        ftApplication.setRegistertime(new Timestamp(System.currentTimeMillis()));
        ftApplication.setState(1);
        ftApplication.setIp("::1");
        ftApplication.setIp_state(1);
        ftApplicationToSystemRepository.save(ftApplication);
        return id;
    }

    public List<FtApplicationToSystem> findAll(){
        return (List<FtApplicationToSystem>)ftApplicationToSystemRepository.findAll();
    }

    public Page<FtApplicationToSystem> findPageList(String filterParam, String sortParam, int start, int limit) {
        Page<FtApplicationToSystem> results = ftApplicationToSystemRepository.findAll(new QuerySpecification<FtApplicationToSystem>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        return results;
    }

    public FtApplicationToSystem findByName(String name){
        return ftApplicationToSystemRepository.findByDescription(name);
    }

    public void updateEntity(FtApplicationDto dto){
        FtApplicationToSystem ftApplication = JSONObject.parseObject(JSON.toJSONString(dto),FtApplicationToSystem.class);
        ftApplicationToSystemRepository.save(ftApplication);
    }

    public void delete(FtApplicationToSystem entity){
        List<FtApplicationToBusiness> entities = ftApplicationToBusinessRepository.findBySystemid(entity.getSystemid());
        if (null != entities && entities.size() > 0){
            ftApplicationToBusinessRepository.deleteBySystemId(entity.getSystemid());
        }
        ftApplicationToSystemRepository.delete(entity);
    }




}
