package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.model.pub.dto.FtApplicationDto;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplication;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplicationToSystem;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationRepository;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToSystemRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.FtAppToSystemService;
import com.geoway.landteam.landcloud.servface.datatransfer.FtApplicationService;
import com.gexin.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;


/**
 * Created by zhuyuchen on 2021/10/11.
 */
@Service
public class FtApplicationServiceImpl implements FtApplicationService {

  /*  @Value("#{imeSettings['forwarded.url']}")*/
    @Value("${forwarded.url:}")
    protected String netUrl;
    @Autowired
    private FtApplicationRepository ftApplicationRepository;
    @Autowired
    private FtApplicationToSystemRepository ftApplicationToSystemRepository;
    @Autowired
    private FtAppToSystemService ftAppToSystemService;

    public String addEntity(FtApplicationDto dto, Long userId){
        String appkey = UUID.randomUUID().toString();
        String appsecret = UUID.randomUUID().toString();
        FtApplication ftApplication = new FtApplication();
        ftApplication.setAppkey(appkey);
        ftApplication.setAppsecret(appsecret);
        ftApplication.setSystemname(dto.getSystemname());
        ftApplication.setDescription(dto.getDescription());
        ftApplication.setDepartment(dto.getDepartment());
        ftApplication.setRegistrant(userId);
        ftApplication.setRegistertime(new Timestamp(System.currentTimeMillis()));
        if (null == dto.getState()){
            dto.setState(1);
        }
        ftApplication.setState(dto.getState());
        ftApplicationRepository.save(ftApplication);
        return appkey;
    }

    public List<FtApplication> findAll(){
        return (List<FtApplication>)ftApplicationRepository.findAll();
    }

    public Page<FtApplication> findPageList(String filterParam, String sortParam, int start, int limit) {
        Page<FtApplication> results = ftApplicationRepository.findAll(new QuerySpecification<FtApplication>(filterParam),
                 PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
        return results;
    }

    public void updateEntity(FtApplicationDto dto){
        FtApplication ftApplication = JSONObject.parseObject(JSON.toJSONString(dto),FtApplication.class);
        ftApplicationRepository.save(ftApplication);
    }

    public void delete(FtApplication entity){
        List<FtApplicationToSystem> entities = ftApplicationToSystemRepository.findByAppkey(entity.getAppkey());
        if (null != entities && entities.size() > 0){
            for(FtApplicationToSystem temp : entities){
                ftAppToSystemService.delete(temp);
            }
        }
        ftApplicationRepository.delete(entity);
    }

    public String forwarded(String param) throws IOException {
        //绑定表单传递请求头
        StringEntity httpEntity = new StringEntity(param, ContentType.create("application/x-www-form-urlencoded", "utf-8"));
        HttpPost post = new HttpPost(netUrl);
        post.setEntity(httpEntity);
        post.setHeader("Authorization", "Basic YWRtaW46Z2Vvc2VydmVy");//设置通用请求头
        String result = null;
        return result;
    }

    public String dealData(JSONObject jsonObject){
        Map<String, String> header = null;
        String param = null;
        if (jsonObject.containsKey("headers") && !StringUtils.isBlank(jsonObject.getString("headers"))) {
            header = JSONObject.parseObject(jsonObject.getString("headers"), Map.class);
        }
        JSONObject object = jsonObject.getJSONObject("requestbody");
        String url = jsonObject.getString("url");
        if (null == object || object.size() <= 0) {
            if (url.contains("&")) {
                url = url.replaceAll("&", "#");
                url = url.replaceAll(" ", "A1B2C3D4E5");
            }
            param = "&url=" + url;
        } else {
            String requestbody = object.toJSONString();
            if (header == null || header.size() <= 0) {
                param = "&url=" + url + "&requestbody=" + requestbody;
            } else {
                param = "&url=" + url + "&requestbody=" + requestbody + "&headers=" + JSONArray.toJSONString(header);
            }
        }
        if (!StringUtils.isBlank(jsonObject.getString("type"))){
            param = param + "&type=" + jsonObject.getString("type");
        }
        return param;

    }


}
