package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.datacq.entity.TbtskQueryInfo;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.repository.datacq.TbtskQueryInfoRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.*;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.SmbUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.io.File;
import java.io.IOException;
import java.util.*;

/**
 * 外业调查相关文件导入
 * Created by licong on 2020/6/11.
 */
@Service
//@Transactional(rollbackFor = Exception.class)
public class ImportDataServiceImpl implements ImportDataService {

   /* @Value("#{imeSettings['project.import.exchange']}")*/
   @Value("${project.import.exchange}")
    protected String dataFolder;
  /*  @Value("#{imeSettings['project.import.media']}")*/
  @Value("${project.import.media}")
    protected String mediaFolder;
  /*  @Value("#{imeSettings['project.import.bysxz']}")*/
  @Value("${project.import.bysxz}")
    protected String pdfFolder;
   /* @Value("#{imeSettings['project.minioModel']}")*/
   @Value("${project.minioModel:}")
    protected String minioModel;

    private int status = 0;
    @Autowired
    private ImportZbphDataService zbphDataService;
    @Autowired
    TbtskQueryInfoRepository queryInfoDao;
    @Autowired
    private FileTransferService fileTransferService;
   /* @Autowired
    private MinIOService minIOService;*/
    @Autowired
    private ImportDbService dbService;
    @Autowired
    private ImportTxtService txtService;
    @Autowired
    private ImportDcxsService dcxsService;
    @Autowired
    private ImportJsonService jsonService;
    @Autowired
    private ImportExService importExService;

    private GiLoger logger = GwLoger.getLoger(ImportDataServiceImpl.class);
    //需处理的数据，之后改到配置文件中，不处理全生命周期数据
    private final String[] identitys = new String[]{"wydc", "zbph", "phjg", "dcxs"};//dcxs 作为中转处理的类型

    @Override
    public void start() {
        try {
            if (this.status == 1){
                return;
            }
            this.status = 1;
            List<TbtskQueryInfo> list = queryInfoDao.queryListByList(0, new ArrayList<>(Arrays.asList(this.identitys)));
            for (int i = 0; i < list.size(); i++) {
                TbtskQueryInfo info = list.get(i);
                String objIdentity = info.getType();
                if (this.fileTransferService.isInProgress(info.getId())) {//redis缓存
                    continue;
                }
                info.setState(1);
                this.queryInfoDao.saveAndFlush(info);

                try {
                    String filePath = info.getPath();
                    if (filePath.startsWith("smb://")) {
                        String toPath = this.dataFolder + File.separator + objIdentity;
                        filePath = SmbUtil.getFile(filePath, toPath);
                    }
                    File file = new File(filePath);
                    this.progress(objIdentity, file);
                    info.setState(2);
                    this.queryInfoDao.saveAndFlush(info);
                    file.delete();
                } catch (Exception e) {
                    info.setState(3);
                    info.setError(ExceptionUtils.getStackTrace(e));
                    this.queryInfoDao.saveAndFlush(info);
                } finally {
                    this.fileTransferService.removeProgress(info.getId());
                }
            }
        } catch (Exception e) {
            this.logger.error(e);
        } finally {
            this.status = 0;
        }
    }

    public void progress(String objIdentity, File tempFile) throws Exception {
        String allFileName = tempFile.getName();
        String fileName = allFileName.split("\\.")[0];
        String filePath = tempFile.getPath();
        if (allFileName.indexOf(".zip") != -1) {//导入zip sqlite数据
            ZipUtils utils = new ZipUtils();
            utils.decompressZip(filePath, tempFile.getPath().split(".zip")[0] + File.separator);
            String processFile = this.dataFolder + File.separator + objIdentity + File.separator + fileName;
            if (this.identitys[0].equals(objIdentity)|| this.identitys[2].equals(objIdentity)) {
                this.importData(processFile);
            }
            this.deleteFiles(tempFile.getPath().split(".zip")[0] + File.separator);
        } else if (allFileName.indexOf(".txt") != -1) {//
            this.txtService.readTxt(filePath);
        } else if (allFileName.indexOf(".json") != -1) {
            this.jsonService.readJson(filePath);
        } else if (allFileName.indexOf(".db") != -1){
            if (this.identitys[1].equals(objIdentity)) {//解析占补平衡推送的db文件
                this.zbphDataService.importZbphDb(filePath);
            }else if(this.identitys[3].equals(objIdentity)){

            }
        }else if (allFileName.indexOf(".ex") != -1){
            this.importExService.importData(filePath);
        }
        else {
            this.logger.error("无法解析文件类型——" + allFileName);
        }
    }

    private void deleteFiles(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            FileUtil.deleteFileAndDir(file);
        } else {
            file.delete();
        }
    }

    public void importData(String path) throws Exception {
        //保存数据
        List<String> dbFileList = FileUtil.findFiles(path, "meta.db");
        if (!dbFileList.isEmpty()) {
            String dbPath = dbFileList.get(0);
            this.dbService.importToDb(dbPath);
//            this.logger.fatal("导入");
        }
        //保存文件
        List<String> mediaFileList = FileUtil.findDirectorys(path, "media");
        if (!mediaFileList.isEmpty()) {
            this.saveMedia(mediaFileList.get(0));
        }
        //保存pdf，步移式选址文件
        List<String> pdfFileList = FileUtil.findFiles(path, "*.pdf");
        if (!pdfFileList.isEmpty()) {
            this.savePdf(pdfFileList);
        }
        //回退至外网的数据再次推送至内网后处理内网数据
        List<String> txtList = FileUtil.findDirectorys(path, "*txt");
        if (!txtList.isEmpty()) {
            String backLan = "";//内网处理回退至外网再次提交的任务时，该txt最后处理；
            for (int i = 0; i < txtList.size(); i++) {
                if (InterfaceType.backLan.equals(txtList.get(i))) {
                    backLan = txtList.get(i);
                } else{
                    this.txtService.readTxt(txtList.get(i));
                }
            }
            if (!StringUtils.isEmpty(backLan)) {
                this.txtService.readTxt(backLan);
            }
        }
    }

    /**
     * 获取接收数据的文件夹
     * @param path 文件夹名称
     * @return
     */
    private String getDataPath(String path) {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        return new StringBuilder()
                .append(pathRoot)
                .append("data")
                .append(File.separator)
                .append(path)
                .toString();
    }

    private String getMediaPath(String path) {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        return new StringBuilder()
                .append(pathRoot)
                .append(path)
                .toString();
    }

    /**
     * 保存media至media文件夹
     * @param mediaPath 来源文件夹
     */
    private void saveMedia(String mediaPath) throws Exception {
        File tempFolder = new File(mediaPath);
        List<File> mediaList = this.getMediaFile(tempFolder);
        String newMediaPath = this.mediaFolder + File.separator + "media";//this.getMediaPath(this.mediaFolder);
        for (int i = 0; i < mediaList.size(); i++) {
            String tempPath = mediaList.get(i).getPath();
            String[] tempPaths = tempPath.split("media");
            if ("true".equals(minioModel)) {
                String relativePath = "media" + "/" + tempPaths[tempPaths.length - 1];
                this.logger.error(relativePath + "   " + tempPath);
               /* this.minIOService.addToBucket(relativePath, tempPath);*/
                this.logger.error("结束");
            } else {//本地文件模式
                String relativePath = tempPaths[tempPaths.length - 1];
                String[] paths = relativePath.split("\\\\");
                String father= newMediaPath;
                for (int j = 0; j < paths.length - 1; j++) {
                    father += File.separator + paths[j];
                }
                File fatherFile = new File(father);
                if (!fatherFile.exists()) {
                    fatherFile.mkdirs();
                }
                father += File.separator + paths[paths.length - 1];
                File mediaFile = new File(father);
                if (mediaFile.exists()) {
                    mediaFile.delete();
                }
                File tempFile = new File(tempPath);
                tempFile.renameTo(mediaFile);
            }
        }
    }

    /**
     * 获取目录下所有的文件
     * @param file
     * @return
     */
    private List<File> getMediaFile(File file) {
        List<File> fileList = new ArrayList<File>();
        File[] children = file.listFiles();
        for (int i = 0; i < children.length; i++) {
            File temp = children[i];
            if (temp.isDirectory()) {
                fileList.addAll(this.getMediaFile(temp));
            } else {
                fileList.add(temp);
            }
        }
        return fileList;
    }

    private void savePdf(List<String> pdfList) throws IOException {
        for (int i = 0; i < pdfList.size(); i++) {
            File temp = new File( pdfList.get(i));
            FileUtil.copyFile(pdfList.get(i), this.pdfFolder + File.separator + temp.getName());
        }
    }

}
