package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.servface.task.ITaskAssignService;
import com.geoway.landteam.customtask.task.entity.TskRightArea;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.model.datacq.dto.DataField;
import com.geoway.landteam.landcloud.model.datatransfer.constants.BusiType;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportDbService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportMessageService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ImportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * Created by licong on 2021/9/3.
 */
@Service
public class ImportDbServiceImpl implements ImportDbService {
    GiLoger logger = GwLoger.getLoger(ImportDbServiceImpl.class);
   /* @Value("#{imeSettings['project.applicationType']}")*/
    @Value("${project.applicationType:}")
    protected String applicationType;
  /*  @Value("#{imeSettings['project.minioModel']}")*/
    @Value("${project.minioModel:}")
    protected String minioModel;

    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private ImportMessageService messageService;
    @Autowired
    private TskRightAreaRepository tskRightAreaRepository;
    @Autowired
    private ITaskAssignService taskAssignService;
    @Autowired
    private LandUserRepository userRepository;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
  /*  @Autowired
    private MinIOService minIOService;*/

    @Override
    public void importToDb(String file) throws Exception {
        SqlliteConnTool connTool = null;
        try {
            connTool = new SqlliteConnTool(file);
            //导入Tbtsk_task_biz
            this.insertBizData(connTool);
            //导入tbtsk_objectinfo（任务与表关联）
            this.insertObjectInfo(connTool);
            //导入tbtsk_fields及数据表
            this.insertFields(connTool);
            //tbsys_user_biz2（任务权限）
            this.insertUserBiz(connTool);
            //tbtsk_group
            this.insertGroup(connTool);
            //tbtsk_assign_record(任务下发)
            this.insertAssign(connTool);
            //tbtsk_task_ntzy_project（项目详情）
            this.insertProjectInfoData(connTool);
            //tb_app_media（多媒体）
            this.insertAppMedia(connTool);
            //导入数据表，这里之前是写在tbtsk_fields之后，从tbtsk_fields获取fileds
            this.insertTableData(connTool);
            //导入check表
            this.insertCheckData(connTool);
            //导入tbtsk_task_project_ntzy_statistic
            this.insertStatistics(connTool);
            //如果是外网，下发数据
            if (!"lan".equals(this.applicationType)) {
                this.assign(connTool);
            } else {
                this.messageService.sendMessage(connTool);
            }
        } finally {
            connTool.Dispose();
        }
    }

    /**
     * 导入Tbtsk_task_biz
     * @throws Exception
     */
    private void insertBizData(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_task_biz";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 导入tbtsk_objectinfo
     * @throws Exception
     */
    private void insertObjectInfo(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_objectinfo";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 导入tbsys_user_biz2
     * @throws Exception
     */
    private void insertUserBiz(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbsys_user_biz2";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 插入tbtsk_fields
     * @throws SQLException
     */
    private void insertFields(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_fields";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 插入tbtsk_group
     * @throws SQLException
     */
    private void insertGroup(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_group";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 插入tbtsk_assign_record
     * @throws SQLException
     */
    private void insertAssign(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_assign_record";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 导入项目信息，基本农田占用使用tbtsk_task_ntzy_project
     * @throws Exception
     */
    private void insertProjectInfoData(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_task_ntzy_project";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    /**
     * 插入tb_app_media
     * @param connTool
     */
    private void insertAppMedia(SqlliteConnTool connTool) throws Exception {
        String[] fieldNames = {"f_id", "f_galleryid", "f_type", "f_time", "f_lon",
                "f_lat", "f_azimuth", "f_pitch", "f_shape", "f_videorecord",
                "f_serverpath", "f_mediatimelength", "f_mediasize", "f_fileid",
                "f_downloadurl", "f_mark", "f_typetype", "f_username", "f_media","f_bizid","f_tablename"};
        //导入时f_downloadurl设置为空(从内网到外网会不会覆盖原有数据？)
        String[] types = {"varchar", "varchar", "int4", "varchar", "float8",
                "float8", "varchar", "varchar", "text", "text",
                "special", "int4", "float8", "varchar",
                "null", "int4", "int4", "varchar", "text", "varchar", "varchar"};
        List<DataField> fieldsList = this.getFields(fieldNames, types);
        String tableName = "tb_app_media";
        deleteZgTaskMedia(connTool);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    //整改任务删除历史照片
    private void deleteZgTaskMedia(SqlliteConnTool connTool) throws SQLException {
        String bizSql = "select * from tbtsk_task_biz";
        ResultSetInfo bizResult = connTool.doQuery(bizSql);
        ResultSet bizRs = bizResult.getResultSet();
        String bizCode = "";
        while(bizRs.next()){
            bizCode = bizRs.getString("f_busicode");
        }
        if("GDBH_JCJG".equals(bizCode)){
            String sql = "select * from tb_app_media";
            ResultSetInfo result3 = connTool.doQuery(sql);
            ResultSet rs3 = result3.getResultSet();

            //已经删除过的
            String gallerys = "";
            while (rs3.next()) {
                String f_galleryid = rs3.getString("f_galleryid");
                String f_bizid = rs3.getString("f_bizid");
                String f_gallerys = f_galleryid + "_" + f_bizid;
                if( gallerys.indexOf(f_gallerys) == -1  ){
                    String deleteSql = String.format("delete from tb_app_media where f_galleryid='%s'and f_bizid='%s'",f_galleryid,f_bizid);
                    gallerys = gallerys + f_gallerys + ",";
                    jdbcTemplate.update(deleteSql);
                }
            }
        }
    }

    /**
     * 导入数据表
     * @throws Exception
     */
    private void insertTableData(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        Map<String, List<DataField>> fieldMap = new HashMap<>();
        while (rs.next()) {
            String f_fieldname = rs.getString("f_fieldname");
            String f_tablename = rs.getString("f_tablename");
            List<DataField> fieldsList = null;
            if (fieldMap.containsKey(f_tablename)) {
                fieldsList = fieldMap.get(f_tablename);
            } else {
                fieldsList = new ArrayList<>();
            }
            String f_fieldtype = TskTaskBizDBUtil.getDBType(rs.getString("f_fieldtype"));
            Integer f_length = ImportDataUtils.toInteger(rs.getString("f_length"));
            Integer f_precision = ImportDataUtils.toInteger(rs.getString("f_precision"));
            DataField data = new DataField();
            data.setfTablename(f_tablename);
            data.setfFieldname(f_fieldname);
            data.setfFieldtype(f_fieldtype);
            data.setfLength(f_length);
            data.setfPrecision(f_precision);
            fieldsList.add(data);

            fieldMap.put(f_tablename, fieldsList);
        }
//        fieldMap.forEach((key,value) -> {
//            this.insertTableData(connTool, value, key);
//        });
        for (Map.Entry<String, List<DataField>> entry : fieldMap.entrySet()) {//多张数据表
            this.insertTableData(connTool, entry.getValue(), entry.getKey());
        }
    }

    private void insertTableData(SqlliteConnTool connTool, List<DataField> fieldsList, String f_tablename) throws Exception {
        boolean hastable = this.isTableExist(f_tablename);
        if (!hastable) {
            String create = this.createTableSql(f_tablename, fieldsList);
            String primarySql = "ALTER TABLE \"public\".\"" + f_tablename + "\" ADD PRIMARY KEY (\"f_id\");";
            this.jdbcTemplate.execute(create);
            this.jdbcTemplate.execute(primarySql);
        }
        this.insertTmpl(connTool, fieldsList, f_tablename);
    }

    /**
     * 导入数据表，这里只能处理一张表的导入，如果有多张表会报错
     * @throws Exception
     */
    private void insertCheckData(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<DataField> fieldsList = new ArrayList<>();
        fieldsList.add(new DataField("f_id", "varchar", 100, null));
        fieldsList.add(new DataField("f_pid", "varchar", 100, null));
        fieldsList.add(new DataField("f_createtime", "varchar", 100, null));
        fieldsList.add(new DataField("f_userid", "varchar", 100, null));
        fieldsList.add(new DataField("f_username", "varchar", 100, null));
        fieldsList.add(new DataField("f_checktime", "varchar", 100, null));
        fieldsList.add(new DataField("f_sign", "text", null, null));
        String f_tablename = "";
        while (rs.next()) {
            String isOutWork = rs.getString("f_isoutwork");
            if (!"1".equals(isOutWork)) {
                continue;
            }
            String f_fieldname = rs.getString("f_fieldname");
            f_tablename = rs.getString("f_tablename");
            String f_fieldtype = rs.getString("f_fieldtype");
            Integer f_length = ImportDataUtils.toInteger(rs.getString("f_length"));
            Integer f_precision = ImportDataUtils.toInteger(rs.getString("f_precision"));
            DataField data = new DataField();
            data.setfTablename(f_tablename);
            data.setfFieldname(f_fieldname);
            data.setfFieldtype(f_fieldtype);
            data.setfLength(f_length);
            data.setfPrecision(f_precision);
            fieldsList.add(data);
        }
        f_tablename += "_check";
        boolean hasSqliteTable = this.isSqliteTableExist(f_tablename, connTool);
        if (!hasSqliteTable) {
            return;
        }
        boolean hastable = this.isTableExist(f_tablename);
        String create = this.createTableSql(f_tablename, fieldsList);
        String primarySql = "ALTER TABLE \"public\".\"" + f_tablename + "\" ADD PRIMARY KEY (\"f_id\");";
        if (!hastable) {
            this.jdbcTemplate.execute(create);
            this.jdbcTemplate.execute(primarySql);
        }
        this.insertTmpl(connTool, fieldsList, f_tablename);
    }

    /**
     * 导入统计信息，基本农田占用使用tbtsk_task_project_ntzy_statistic
     * @throws Exception
     */
    private void insertStatistics(SqlliteConnTool connTool) throws Exception {
        String tableName = "tbtsk_task_project_ntzy_statistic";
        List<DataField> fieldsList = this.getFieldsByTable(tableName);
        this.insertTmpl(connTool, fieldsList, tableName);
    }

    private void insertTmpl(SqlliteConnTool connTool, List<DataField> fieldsList, String tableName) throws Exception {
        String insert = "INSERT INTO \"public\".\"" + tableName + "\" (";
        for (int i = 0; i < fieldsList.size(); i++) {
            String field = fieldsList.get(i).getfFieldname();
            insert += "\"" + field + "\"";
            if (i != fieldsList.size()-1) {
                insert += ",";
            }
        }
        insert += ")";

        String sql = "select * from " + tableName;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<String> idList = new ArrayList<>();
        while (rs.next()) {
            String f_id = rs.getString("f_id");
            idList.add("'" + f_id + "'");
        }

        if (idList.isEmpty())
            return;
        Set<String> idSet = new HashSet<>();
        String idsql = "select f_id from " + tableName + " where f_id in (" + StringUtils.join(idList,",") + ")";
        List<Map<String, Object>> hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); i++) {
            idSet.add(hasIdList.get(i).get("f_id").toString());
        }

        String sql2 = "select * from " + tableName;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        while (rs2.next()) {
            String f_id = rs2.getString("f_id");
            if (idSet.contains(f_id)) {
                String updateSql = "UPDATE \"public\".\"" + tableName + "\" SET ";
                updateSql += this.getInsertSql(rs2, fieldsList, 1);
                updateSql += " WHERE \"f_id\"='" + f_id + "'";
                this.jdbcTemplate.update(updateSql);
            } else {
                String insertSql = insert + " VALUES (";
                insertSql += this.getInsertSql(rs2, fieldsList, 0);
                insertSql += ")";
                this.jdbcTemplate.update(insertSql);
            }
        }
    }

    private String getTypeSql(DataField fields) {
        if ("varchar".equals(fields.getfFieldtype())) {
            return " varchar(" + fields.getfLength() + ")";
        } else if ("text".equals(fields.getfFieldtype())) {
            return " text";
        } else if ("int4".equals(fields.getfFieldtype())) {
            return " int4";
        } else if ("geometry".equals(fields.getfFieldtype())) {
            return " geometry";
        } else if ("decimal".equals(fields.getfFieldtype())) {
            return " numeric(" + fields.getfLength() + "," + fields.getfPrecision()+ ")";
        } else if ("timestamp".equals(fields.getfFieldtype())) {
            return " timestamp";
        } else {
            return " varchar(100)";
        }
    }

    /**
     *
     * @param rs
     * @param fieldsList
     * @param type 1更新，0插入
     * @return
     * @throws SQLException
     */
    private String getInsertSql(ResultSet rs, List<DataField> fieldsList, Integer type) throws SQLException {
        String result = "";
        for (int i = 0; i < fieldsList.size(); i++) {
            DataField field = fieldsList.get(i);
            if (type == 1) {
                result += "\"" + field.getfFieldname() + "\"=";
            }
            result += this.getInsertValue(rs, field);
            if (i != fieldsList.size() - 1){
                result += ",";
            }
        }
        return result;
    }

    /**
     * sql语句插入方式构建value数据
     * @param rs
     * @param field
     * @return
     * @throws SQLException
     */
    private String getInsertValue(ResultSet rs, DataField field) throws SQLException {
        if ("special".equals(field.getfFieldtype())) {//特殊处理字段
            if ("f_serverpath".equals(field.getfFieldname())) {//tb_app_media内网导入，将地址的
                String path =rs.getString(field.getfFieldname());
                if (null == path) {
                    return "null";
                } else {
                    String[] pathArray = path.split("media");
                    if (pathArray.length !=2) {
                        return " '" + path + "'" ;
                    } else {
                        if ("true".equals(this.minioModel)) {
                            return " ''";
                          /*  return " '" + this.minIOService.getHeaderUrl() + "/media" + pathArray[1] + "'";*/
                        } else{
                            return " 'media" + pathArray[1] + "'";
                        }
                    }
                }
            } else {
                return "null";
            }
        } else if ("varchar".equals(field.getfFieldtype()) || "text".equals(field.getfFieldtype()) || "json".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfFieldname())) {
                return "null";
            } else {
                String value = rs.getString(field.getfFieldname());
                value = value.replace("'", "''");
                return " '" + value + "'";
            }
        } else if ("int2".equals(field.getfFieldtype()) || "int4".equals(field.getfFieldtype()) || "int8".equals(field.getfFieldtype()) ||
                "decimal".equals(field.getfFieldtype()) || "numeric".equals(field.getfFieldtype()) || "float8".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfFieldname())) {
                return "null";
            } else {
                return rs.getString(field.getfFieldname());
            }
        } else if ("geometry".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfFieldname())) {
                return "null";
            } else {
                //内网过滤掉SRID
                String wkt = rs.getString(field.getfFieldname());
                if("lan".equals(applicationType)){
                    wkt = wkt.replaceFirst("^(SRID|srid)=\\d*;","");
                }
                return "st_geomfromtext('" + rs.getString(field.getfFieldname()) + "')";//,4326
            }
        } else if ("date".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfFieldname())) {
                return "null";
            } else {
                return "to_date('" + rs.getString(field.getfFieldname()) + "','yyyy-MM-dd hh24:mi:ss')";
            }
        } else if ("timestamp".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfFieldname())) {
                return "null";
            } else {
                return "to_timestamp('" + rs.getString(field.getfFieldname()) + "','yyyy-MM-dd hh24:mi:ss')";
            }
        }  else if ("null".equals(field.getfFieldtype())) {
            return "null";
        } else {
            return " '" + rs.getString(field.getfFieldname()) + "'";
        }
    }

    /**
     * pg库数据表是否存在
     * @param tableName
     * @return
     */
    private boolean isTableExist(String tableName) {
        if(tableName.contains(".")){
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        String sql = "select count(*) as f_count from pg_class where relname = '" + tableName + "'";
        Map<String, Object> map = this.jdbcTemplate.queryForMap(sql);
        if (0 == Integer.valueOf(map.get("f_count").toString())) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * 判断sqlite表是否存在
     * @param tableName
     * @param connTool
     * @return
     * @throws SQLException
     */
    private boolean isSqliteTableExist(String tableName, SqlliteConnTool connTool) throws SQLException {
        String sql = "SELECT COUNT(*) as f_count FROM sqlite_master where type='table' and name='" + tableName + "'";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        while (rs.next()) {
            int count = rs.getInt("f_count");
            if (0 == count) {
                return false;
            } else {
                return true;
            }
        }
        return false;
    }

    private String createTableSql(String f_tablename, List<DataField> fieldsList) {
        String create = "CREATE TABLE \"public\".\"" + f_tablename + "\" (";
        for (int i = 0; i < fieldsList.size(); i++) {
            String field = fieldsList.get(i).getfFieldname();
            create += "\"" + field + "\"" + this.getTypeSql(fieldsList.get(i));
            if (i != fieldsList.size()-1) {
                create += ",";
            }
        }
        create += ")";
        return create;
    }

    /**
     *
     * @param fieldNames
     * @param types 注意，这里的type是数据库里的字段类型，不是实体类型，有部分实体类型是date，在数据库中是varchar
     *              具体类型参照getInsertValue方法
     * @return
     */
    private List<DataField> getFields(String[] fieldNames, String[] types) {
        List<DataField> result = new ArrayList<>();
        for (int i = 0; i < fieldNames.length; i++) {
            DataField temp = new DataField();
            temp.setfFieldname(fieldNames[i]);
            temp.setfFieldtype(types[i]);
            result.add(temp);
        }
        return result;
    }

    private List<DataField> getFieldsByTable(String tableName) {
        List<DataField> result = new ArrayList<>();
        List<Map<String, Object>> fieldList = this.getFields(tableName);
        for (int i = 0; i < fieldList.size(); i++) {
            Map<String, Object> obj = fieldList.get(i);
            String atttypid = obj.get("atttypid").toString();
            String fieldName = obj.get("attname").toString();
            String pgType = obj.get("typname").toString();
//            String pgType = DatabaseFieldType.getPgType(atttypid);
            DataField temp = new DataField();
            temp.setfFieldname(fieldName);
            temp.setfFieldtype(pgType);
            result.add(temp);
        }
        return result;
    }

    /**
     * 外网，如果是步移式选址项目，则自动下发任务，新增类型：监测监管任务、审批备案任务
     * @param connTool
     * @throws SQLException
     */
    private void assign(SqlliteConnTool connTool) throws SQLException {
        String sql = "select f_id,f_busicode,f_tableid from tbtsk_task_biz";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        Boolean flag = false;
        String taskId = "";
        String tableid = "";
        while (rs.next()) {
            String f_busicode = rs.getString("f_busicode");
            taskId = rs.getString("f_id");
            tableid = rs.getString("f_tableid");
            if (BusiType.Bysxz.equals(f_busicode) || BusiType.Spba.equals(f_busicode) || BusiType.Jcjg.equals(f_busicode)
                    || BusiType.PHJG.equals(f_busicode) || BusiType.JDJC.equals(f_busicode) || BusiType.JCPH.equals(f_busicode)) {
                flag = true;
                break;
            }
        }
        rs.close();
        if (!flag)
            return;

        String sql2 = "select f_tablename from tbtsk_objectinfo where f_id = '" + tableid + "'";
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        String datatable = "";
        while (rs2.next()) {
            datatable = rs2.getString("f_tablename");
        }
        rs2.close();
        String sql3 = "select * from " + datatable;
        ResultSetInfo result3 = connTool.doQuery(sql3);
        ResultSet rs3 = result3.getResultSet();
        while (rs3.next()) {
            String f_id = rs3.getString("f_id");
            String f_sendto = "";
            try {
                f_sendto = rs3.getString("f_sendto");
            } catch (Exception e) {
                return;
            }
            String regionCode = rs3.getString("f_xzqdm");
            this.assignTask(taskId, f_id, f_sendto, regionCode);
        }
        rs3.close();
    }

    private void assignTask(String taskId, String f_id, String f_sendto, String regionCode) {
        if (!StringUtils.isEmpty(f_id) && !StringUtils.isEmpty(f_sendto)) {
            JSONArray userarray = new JSONArray();
            if(f_sendto.contains(",")){
                String[] uids = f_sendto.split(",");
                Set<String> set = new HashSet<>();
                set.addAll( Arrays.asList(uids));
                set.forEach(item->{
                    Long userid;
                    if (item.length() == 11)
                        userid = this.getUserByPhone(item);
                    else {
                        userid = Long.valueOf(item);
                    }
                    if (null == userid) {
                        return;
                    }
                    userarray.add(userid);
                });
            }else {
                Long userid;
                if (f_sendto.length() == 11)
                    userid = this.getUserByPhone(f_sendto);
                else {
                    userid = Long.valueOf(f_sendto);
                }
                if (null == userid) {
                    return;
                }
                userarray.add(userid);
            }
            if(userarray.size()<=0){
                return;
            }

            //数据主键
            JSONArray tasks = new JSONArray();
            tasks.add(f_id);
            //下发给谁
            JSONArray orgs = new JSONArray();
            JSONObject object = new JSONObject();

            object.put("orgid", null);
            object.put("userids", userarray);
            orgs.add(object);
            //如果用户没有对应作业区，先添加权限
            userarray.forEach(userid->{
                this.addArea((Long)userid, regionCode, taskId);
            });
            /*this.addArea(userid, regionCode, taskId);*/
            this.taskAssignService.assignTask(101l, taskId, tasks, new JSONArray(), orgs);
        }
    }

    /**
     * 添加作业区
     * @param userid
     * @param regionCode
     * @param taskId
     */
    private void addArea(Long userid, String regionCode, String taskId) {
        List<TskRightArea> raList = this.tskRightAreaRepository.findByTaskIdAndUserIdAndXzqdm(taskId, String.valueOf(userid), regionCode);
        if (raList.isEmpty()) {
            TskRightArea area = new TskRightArea();
            area.setTaskId(taskId);
            area.setUserId(String.valueOf(userid));
            area.setXzqdm(regionCode);
            this.tskRightAreaRepository.save(area);
        }
    }

    private Long getUserByPhone(String phone) {
        List<LandUser> userlist = this.userRepository.queryAppUserByPhone(phone);
        if (userlist.isEmpty()) {
            return null;
        } else {
            return userlist.get(0).getId();
        }
    }

    private List<Map<String, Object>> getFields(String tableName) {
        if(tableName.contains(".")){
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        String attributeSql = "select t1.*,t2.typname from (select atttypid,attname from pg_attribute where attrelid = " +
                "(select oid from pg_class where relname = '" + tableName + "') and attname like 'f_%' ) t1 left join pg_type t2 on t1.atttypid = t2.oid;";
        return this.jdbcTemplate.queryForList(attributeSql);
    }
}
