package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportDcxsService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.*;

/**
 * FileName: ImportDcxsServiceImpl.java
 * Author:   leo
 * Date:     2021/11/3 15:09
 * Description:
 */
@Service
public class ImportDcxsServiceImpl implements ImportDcxsService {

    @Override
    public void importDcxsDB(String file) throws Exception {
        SqlliteConnTool connTool = null;
        try {
            connTool = new SqlliteConnTool(file);
            Map<String, List> structure = this.readSqliteStructure(connTool);
            List<TableDataDto> tableDataDtos = this.readSqliteTable(structure, connTool);

        }finally {
            connTool.Dispose();
        }
    }

    private List<TableDataDto> readSqliteTable(Map<String, List> structure, SqlliteConnTool connTool) throws Exception{
        List<TableDataDto> tableDataDtos = new ArrayList<>();

        String sql4 = "SELECT %s FROM %s";
        Iterator<Map.Entry<String, List>> iterator = structure.entrySet().iterator();
        while (iterator.hasNext()){

            Map.Entry<String, List> next = iterator.next();
            String tablename = next.getKey();
            List value = next.getValue();
            TableDataDto tableDataDto = new TableDataDto();
            String sql5 = String.format(sql4, StringUtils.join(value,","), tablename);
            ResultSetInfo resultSetInfo = connTool.doQuery(sql5);
            ResultSet resultSet = resultSetInfo.getResultSet();
            while (resultSet.next()){
                Map<String, Object> temp = new HashMap<>();
                for (Object field : value) {
                    temp.put(field.toString(), resultSet.getObject(field.toString()));
                }
                tableDataDto.getList().add(temp);
            }
            tableDataDto.setTablename(tablename);
            tableDataDtos.add(tableDataDto);

        }
        return tableDataDtos;

    }

    //读取SQLlite结构
    private Map<String, List> readSqliteStructure(SqlliteConnTool connTool) throws Exception{
        Map<String, List> structure = new HashMap<>();
        String sql1 = "SELECT name FROM sqlite_master WHERE type = 'table';";
        String sql2 = "pragma table_info ('%s');";
        ArrayList<String> tables = connTool.getTables();
        for (String table : tables) {
            String sql3 = String.format(sql2, table);
            ResultSetInfo resultSetInfo = connTool.doQuery(sql3);
            ResultSet resultSet = resultSetInfo.getResultSet();
            List<String> fields = new ArrayList<>();
            while (resultSet.next()){
                String name = resultSet.getString("name");
                fields.add(name);
            }
        }

        return structure;
    }
}

class TableDataDto implements Serializable {
    String tablename;

    List<Map<String, Object>> list;

    public TableDataDto() {
        this.list = new ArrayList<>();
    }

    public String getTablename() {
        return tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public List<Map<String, Object>> getList() {
        return list;
    }

    public void setList(List<Map<String, Object>> list) {
        this.list = list;
    }
}