package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.datatransfer.dto.EntriesParameter;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportExService;
import com.geoway.landteam.landcloud.service.thirddata.utils.HttpUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

import java.io.File;
import java.util.Map;


/**
 * Created by zhuyuchen on 2021/11/1.
 */
@Service
public class ImportExServiceImpl implements ImportExService {
    private GiLoger logger = GwLoger.getLoger(ImportExServiceImpl.class);


    /**
     * 内网接收外网接口请求
     * @param filePath
     * @throws Exception
     */
    public void importData(String filePath) throws Exception{
        String charset = (FileUtils.readFileToString(new File(filePath), "GBK"));
        EntriesParameter content = JSONObject.parseObject(charset, EntriesParameter.class);
        String loginUrl = content.getLoginUrl();
        HttpClient httpClient = HttpUtil.buildHttpClient(false);
        // GET请求
        HttpGet httpGet = new HttpGet(loginUrl);
        // 执行响应操作
        HttpResponse response = httpClient.execute(httpGet);
        httpGet.releaseConnection();
        String value = null;
        String cookie = "";
        String data = null;
        Header[] headers = response.getHeaders("Set-Cookie");
        for (int i = 0; i < headers.length; i++) {//取出所有的cookie值
            value = headers[i].getValue();
            cookie+=value + ";";
        }
        if (content.getType().equals("get")){   //get请求
            HttpGet method = new HttpGet(content.getUrl());
            method.setHeader("Cookie",cookie);
            HttpResponse response1 = httpClient.execute(method);
            data = EntityUtils.toString(response1.getEntity());
            method.releaseConnection();
        }else if (content.getType().equals("jsonpost")){   //数据为json的post请求
            HttpPost method = new HttpPost(content.getUrl());
            method.setHeader("Cookie",cookie);
            if (StringUtils.isNotBlank(content.getRequestbody())) {
                // 参数实体
                StringEntity entity = new StringEntity(content.getRequestbody(),"UTF-8");//解决中文乱码问题
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json;charset=utf-8");
                method.setEntity(entity);
            }
            HttpResponse response1 = httpClient.execute(method);
            data = EntityUtils.toString(response1.getEntity());
            method.releaseConnection();
        }else {             //form-data   数据post请求
            String param = "";
            JSONObject jsonObject = JSONObject.parseObject(content.getRequestbody());
            if (null != jsonObject && !jsonObject.isEmpty()){
                for (Map.Entry entry : jsonObject.entrySet()) {
                    param += "&"+entry.getKey()+"="+entry.getValue();
                }
            }
            StringEntity httpEntity = new StringEntity(param, ContentType.create("application/x-www-form-urlencoded", "utf-8"));
            HttpPost post = new HttpPost(content.getUrl());
            post.setEntity(httpEntity);
            post.setHeader("Authorization", "Basic YWRtaW46Z2Vvc2VydmVy");//设置通用请求头
            post.addHeader("Cookie",cookie);
            data = HttpUtil.executeRequest(post,null);
        }
        if (StringUtils.isBlank(data)){
            this.logger.error("接口参数返回错误");
        }else {
            this.logger.info("返回数据:"+data);
        }


    }


}
