package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ParamType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.UpdateType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ValueType;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportJsonService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ImportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by licong on 2021/9/3.
 */
@Service
public class ImportJsonServiceImpl implements ImportJsonService {
    private GiLoger logger = GwLoger.getLoger(ImportJsonServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    /**
     * 处理json文件
     * @param filePath
     */
    @Override
    public void readJson(String filePath) throws Exception {
        List<String> jsonList = ImportDataUtils.readTxtFile(filePath);
        JSONArray array = JSONArray.parseArray(jsonList.get(0));
        if (this.containsSqlInjection(array.toString())) {
            this.logger.error("发现有sql注入问题" + array.toString());
            return;
        }
        for (int i = 0; i < array.size(); i++) {
            List<Object> params = new ArrayList<Object>();
            JSONObject object = array.getJSONObject(i);
            String tableName = object.getString("table");
            JSONArray dataArray = object.getJSONArray("data");
            JSONArray paramArray = object.getJSONArray("param");
            Integer type = object.getInteger("type");
            String sql = "";
            if (UpdateType.ADD == type) {//123增删改
                sql += "INSERT INTO " + tableName + " VALUES(";
            } else if (UpdateType.DEL == type) {
                sql += "DELETE FROM " + tableName;
            } else if (UpdateType.UPDATE == type) {
                sql += "UPDATE " + tableName + " SET ";
            }
            for (int j = 0; j < dataArray.size(); j++) {//更新语句，delete没有
                JSONObject dataObject = dataArray.getJSONObject(j);
                String key = dataObject.getString("key");
                String value = dataObject.getString("value");
                Integer valueType = dataObject.getInteger("valueType");
                if (1 == type) {
                    sql += " ? ";
                } else {
                    sql += key + " = ? ";
                }

                if (j != dataArray.size() -1) {
                    sql += " , ";
                }
                params.add(this.getInsertValue2(valueType, value));
            }
            if (1 == type) {
                sql += ")";
            }
            sql += " WHERE 1=1 ";
            if  (null != paramArray && paramArray.size() != 0) {//条件语句，insert没有
                for (int m = 0; m < paramArray.size(); m++) {
                    JSONObject dataObject = paramArray.getJSONObject(m);
                    String key = dataObject.getString("key");
                    Object value = dataObject.get("value");
                    Integer valueType = dataObject.getInteger("valueType");
                    Integer paramType = dataObject.getInteger("paramType");
                    if (ParamType.TYPE_IN == paramType){
                        sql += " and " + key + " in (" + this.getINsql((String) value) + ")";
                    } else {
                        sql += " and " + key +  this.getOperation(paramType) + "?";
                        params.add(this.getInsertValue2(valueType, value));
                    }
                }
            }
            this.jdbcTemplate.update(sql, params.toArray());
        }
    }

    /**
     * sql语句插入方式构建value数据
     * @return
     */
    private Object getInsertValue2(Integer type, Object value){
        if (ValueType.TYPE_STRING == type) {//varchar\text
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return value.toString();
            }
        } else if (ValueType.TYPE_INT == type) {//int4
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return ImportDataUtils.toInteger(value);
            }
        } else if (ValueType.TYPE_GEOMETRY == type) {//geometry
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return ImportDataUtils.toGeometry(value);//,4326
            }
        } else if (ValueType.TYPE_DATE == type) {//date
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return ImportDataUtils.toDate(value);
            }
        } else if (ValueType.TYPE_TIMESTAMP == type) {//timestamp
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return ImportDataUtils.toTimestamp(value);
            }
        } else if (ValueType.TYPE_NUMBER == type) {//decimal\numeric\float8
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return ImportDataUtils.toDouble(value);
            }
        } else if (ValueType.TYPE_LONG == type) {//
            if (null == value || "null".equals(value)) {
                return null;
            } else {
                return ImportDataUtils.toLong(value);
            }
        } else {
            return value;
        }
    }

    private String getOperation(Integer paramType) {
        if (ParamType.TYPE_EQ == paramType) {
            return " = ";
        } else if (ParamType.TYPE_NE == paramType) {
            return " != ";
        } else if (ParamType.TYPE_LT == paramType) {
            return " < ";
        } else if (ParamType.TYPE_LE == paramType) {
            return " <= ";
        } else if (ParamType.TYPE_GT == paramType) {
            return " > ";
        } else if (ParamType.TYPE_GE == paramType) {
            return " >= ";
        } else if (ParamType.TYPE_IN == paramType) {
            return " in ";
        } else {
            return " = ";
        }
    }

    private String getINsql(String data) {
         String[] array = data.split(",");
         String result = "";
         for (int i = 0; i < array.length; i++) {
             result += "'" + array[i] + "'";
             if (i != array.length - 1) {
                 result += ",";
             }
         }
         return result;
    }

    /**
     * 监测sql注入
     * @param obj
     * @return
     */
    public boolean containsSqlInjection(Object obj) {
        Pattern pattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|')");
        Matcher matcher = pattern.matcher(obj.toString().toLowerCase());
        return matcher.find();
    }
}
