package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.http.HttpUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.datatransfer.constants.BusiType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportMessageService;
import com.geoway.landteam.landcloud.service.thirddata.utils.SendMessage;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created by licong on 2021/9/3.
 */
@Service
public class ImportMessageServiceImpl implements ImportMessageService {
   /* @Value("#{imeSettings['project.minioModel']}")*/
    @Value("${project.minioModel:}")
    protected String minioModel;
   /* @Value("#{imeSettings['project.mediaUrlPrefix']}")*/
    @Value("${project.mediaUrlPrefix}")
    protected String mediaUrlPrefix;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TskTaskBizRepository bizDao;
    @Autowired
    private DataBizService dataBizService;
  /*  @Autowired
    private LedgerKJTCQueryService ledgerKJTCQueryService;
    @Autowired
    private PhjgKJTCQueryService phjgKJTCQueryService;*/
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
   /* @Autowired
    private CQService cqService;*/
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private LogService logService;
   /* @Autowired
    private JcjgService jcjgService;*/
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
   /* @Autowired
    private MinIOService minIOService;*/
    @Autowired
    private TbtskObjectinfoRepository tbtskObjectinfoDao;

    @Override
    public void sendMessage(SqlliteConnTool connTool) throws Exception {
        String sql3 = "select * from tbtsk_task_biz";
        ResultSetInfo result3 = connTool.doQuery(sql3);
        ResultSet rs3 = result3.getResultSet();
        while (rs3.next()) {
            String f_busicode = rs3.getString("f_busicode");
            if (BusiType.Bysxz.equals(f_busicode)) {
                this.sendBysxzMessage(connTool);
                break;
            } else if (BusiType.Spba.equals(f_busicode)) {
                this.sendSpbaMessage(connTool);
            } else if (BusiType.Jcjg.equals(f_busicode)) {
                this.saveJcjgMessage(connTool);
            } else if (BusiType.PHJG.equals(f_busicode)) {
                this.savePhjgMessage(connTool);
            }
//            else {//通用接口
//                this.sendUniversalMessage(connTool);
//            }
            //通用接口
            this.sendUniversalMessage(connTool);
        }
    }

    /**
     * 步移式选址消息推送
     * @param connTool
     * @throws SQLException
     * @throws IOException
     * @throws ParseException
     */
    private void sendBysxzMessage(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tablename = "";
        while (rs.next()) {
            f_tablename = rs.getString("f_tablename");
            break;
        }

        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        rs2.next();
        JSONObject geojson = this.createGeojson(rs2);
        JSONObject obj = new JSONObject();
        obj.put("bjbh", rs2.getString("f_bjbh"));
        obj.put("feature", geojson);

        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(ApiNameType.bysxzSendMessage[0], ApiNameType.bysxzSendMessage[1]);
        JSONObject config = JSONObject.parseObject(applicationApi.getSqlfilterstr());
        String url = config.getString("url");
//        Map<String, Object> map = new HashMap<>();
//        map.put("appId", config.getString("appId"));
//        map.put("template", config.getString("template"));
//        map.put("messageContent", resultArray.toString());
//        HttpHeaders headers = new HttpHeaders();
//        headers.add("Content-Type", "application/json;charset=UTF-8");
//        HttpEntity<String> httpEntity = new HttpEntity<>(JSONObject.toJSONString(map), headers);
//        RestTemplate restTemplate = new RestTemplate();
////        this.logger.fatal("发送消息：" + JSONObject.toJSONString(map));
//        ResponseEntity<String> res = restTemplate.postForEntity(url, httpEntity, String.class);
//        String result5 = res.getBody().toString();
//        //记录日志
//        map.put("result", result5);
//        this.logService.saveLog(LogType.sendBysxzMessage, JSONObject.toJSONString(map));
        Thread thread = new Thread(()->{
            String sendResult = SendMessage.SendXxzxMessage(config.getString("appId"), config.getString("template"), obj.toString(), url);
            this.logService.saveLog(LogType.sendBysxzMessage, sendResult);
        });
        threadPoolTaskExecutor.execute(thread);
    }

    private void sendSpbaMessage(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tablename = "";
        while (rs.next()) {
            f_tablename = rs.getString("f_tablename");
            break;
        }
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        List<String> xmbhList = new ArrayList<>();
        while (rs2.next()) {//这里多条数据按一条发送消息
            xmbhList.add(rs2.getString("f_xmbh"));
        }
        if (!xmbhList.isEmpty()) {
            for (int i = 0; i < xmbhList.size(); i++) {
                String xmbh = xmbhList.get(i);
                if (!StringUtils.isEmpty(xmbh) && this.taskResouceService.hasComplete(xmbh)) {
                   /* this.cqService.PostSpba(xmbh);*/
                }
            }
        }

    }

    /**
     * 更新oracle数据状态
     * @param connTool
     * @throws SQLException
     */
    private void saveJcjgMessage(SqlliteConnTool connTool) throws Exception {

        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tableid = "";
        String f_tablename = "";
        while (rs.next()) {
            f_tableid = rs.getString("f_tableid");
            f_tablename = rs.getString("f_tablename");
            break;
        }
        List<TbtskApplicationApi> apiList = this.tbtskApplicationApiDao.queryByTableid(f_tableid);
        Boolean jgtask = !apiList.isEmpty();

        TbtskApplicationApi api = null;
        String projecttype = "1";
        if(jgtask){
            api = apiList.get(0);
            if (api.getApiname().equals(ApiNameType.assginLsyd[1])) {
                projecttype = "2";
            }
        }
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        String spotIds ="";
        while (rs2.next()) {
            String f_id = rs2.getString("f_id");
            spotIds += f_id + ",";
            if(jgtask) {
               /* this.ledgerKJTCQueryService.changeStatus(projecttype, f_id, "4", true);*/
            }
        }

        String bizSql = "select * from tbtsk_task_biz";
        ResultSetInfo bizResult = connTool.doQuery(bizSql);
        ResultSet bizRs = bizResult.getResultSet();
        String bizid = "";
        while(bizRs.next()){
            bizid = bizRs.getString("f_id");
        }
        //更新工作状态
        TbtskApplicationApi zgApi = tbtskApplicationApiDao.queryApplicationApi("JCJG","gdzyjczg");
        String zgBizId = zgApi != null ?zgApi.getTableid():"";
        if(!zgBizId.equals(bizid)&&!jgtask){
            dataBizService.updateBySql(f_tablename,"f_gzzt = '2'","f_id in ('" + spotIds.replaceAll(",","','") + "')");
           /* this.jcjgService.updateGzzt(f_tablename,spotIds,"2",null);*/
        }
//        else{
//            dataBizService.updateBySql(f_tablename,"f_gzzt = '8'","f_id in('" + spotIds.replaceAll(",","','") + "')");
//            //认为来自同一条任务去单条进行查询提升效率
//            List<Map> tasktemp = dataBizService.queryDataBySql("select f_task_id from " + f_tablename + " where f_id ='" + spotIds.split(",")[0] + "'");
//            //更新原图斑
//            if(tasktemp!=null&&tasktemp.size()>0){
//                String taskId = (String) tasktemp.get(0).get("f_task_id");
//                TbtskObjectinfo orginTask = tskTaskBizService.findTableByTaskId(taskId);
//                dataBizService.updateBySql(orginTask.getfTablename(), " f_gzzt='8'","f_id in('" + spotIds.replaceAll(",","','") + "')");
//                //最后同步工作状态
//                this.jcjgService.updateGzzt(orginTask.getfTablename(),spotIds,"8",null);
//            }
//            this.jcjgService.updateGzzt(f_tablename,spotIds,"8",null);
//        }
    }

    /**
     * 更新oracle数据状态
     * @param connTool
     * @throws SQLException
     */
    private void savePhjgMessage(SqlliteConnTool connTool) throws SQLException {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tableid = "";
        String f_tablename = "";
        while (rs.next()) {
            f_tableid = rs.getString("f_tableid");
            f_tablename = rs.getString("f_tablename");
            break;
        }
        List<TbtskApplicationApi> apiList = this.tbtskApplicationApiDao.queryByTableid(f_tableid);
        if (apiList.isEmpty())
            return;
        TbtskApplicationApi api = apiList.get(0);
        TskTaskBiz tbTaskBiz = bizDao.findByTableId(api.getTableid());
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        List<String> tbIds = new ArrayList<>();
        while (rs2.next()) {
            String f_id = rs2.getString("f_id");
            tbIds.add(f_id);
        }

       /* this.phjgKJTCQueryService.submit2oneMap(tbTaskBiz.getId(), StringUtils.join(tbIds, ","));*/
    }

    private JSONObject createGeojson(ResultSet rs2) throws  Exception {
        JSONObject result = new JSONObject();
        Geometry geometry = WKTUtil.wktToGeom(rs2.getString("f_shape").replace("SRID=4490;",""));
        StringWriter writer = new StringWriter();
        GeometryJSON g = new GeometryJSON();
        g.write(geometry, writer);
        String obj = writer.toString();
        result.put("geometry", JSONObject.parse(obj));

        JSONObject properties = new JSONObject();
        String[] array = {"f_tbmc","f_tbbh","f_tbmj","f_xzqdm","f_xzqmc","f_czmz","f_bjbh","f_xmmz","f_xmfzr",
                "f_bjsj","f_njsgm","f_nydmj","f_sqlx","f_lxr", "f_lxrdh","f_sfzhm","f_ydhxsfqd","f_bz","f_xzqmc1","f_committime"};
        for (int i = 0; i < array.length; i++) {
            properties.put(array[i], rs2.getString(array[i]));
        }
        String submitUser = this.getSubmitUser( rs2.getString("f_sendto"));
        properties.put("f_submitUser", submitUser);
        result.put("properties", properties);
        result.put("type", "Feature");
        return  result;
    }

    private String getSubmitUser(String phone) {
        if (StringUtils.isEmpty(phone))
            return "";
        String sql = "select f_rname from tbsys_user where f_phonemobile = '" + phone + "' limit 1";
        try {
            Map<String, Object> map = this.jdbcTemplate.queryForMap(sql);
            return (String) map.get("f_rname");
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * 通用推送结果接口
     * @param connTool
     */
    private boolean sendUniversalMessage(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_task_biz";//查询任务相关数据，db中只能包含一个任务对应信息
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String parentTableid = "";
        while (rs.next()) {
            parentTableid = rs.getString("f_tableid");
        }
        if (StringUtils.isEmpty(parentTableid))
            return false;
        TbtskObjectinfo parentInfo = this.tbtskObjectinfoDao.gwSearchByPK(parentTableid);
        if (null == parentInfo)
            return false;
        String parentTablename = parentInfo.getfTablename();
        String childTableid = "";
        String childTablename = "";
        List<TbtskObjectinfo> childList = this.tbtskObjectinfoDao.queryAllByParentId(parentTableid);
        if (!childList.isEmpty()) {
            childTableid = childList.get(0).getfId();
            childTablename = childList.get(0).getfTablename();
        }
        //是否有相关配置
        List<TbtskApplicationApi> apiList = this.tbtskApplicationApiDao.queryByTableOrAssign(parentTableid);
        if (apiList.isEmpty())
            return false;
        TbtskApplicationApi api = apiList.get(0);
        String send = api.getSend();
        if (StringUtils.isEmpty(send))//是否需要推送
            return false;
        JSONObject sendConfig = JSONObject.parseObject(send);
        String configTableId = api.getTableid();//查询关联数据需要使用，部分数据有多次外业的情况下，外网推送的任务objectinfo对应着api表的assigntotask字段
        Map<String, String> parentMapping = this.getFieldMapping(configTableId);
        if (null == parentMapping)
            return false;
        JSONArray sendArray = this.sendData(connTool, parentTablename, childTableid, childTablename, parentMapping, sendConfig);
        for (int i = 0; i < sendArray.size(); i++) {
            JSONObject sendObj = sendArray.getJSONObject(i);
            this.sendMessageByConfig(sendConfig, sendObj);
        }
        return true;
    }

    private Map<String, String> getFieldMapping(String tableid){
        Map<String, String> mapping = null;
        try {
            mapping = this.taskResouceService.getFiledMap(tableid, "1");
        } catch (Exception e) {
            //没有映射不处理
            return null;
        }
        return mapping;
    }

    private JSONArray sendData(SqlliteConnTool connTool, String parentTablename, String childTableid, String childTablename,
                               Map<String, String> fieldMapping, JSONObject sendConfig) throws SQLException {
        JSONArray resultArray = new JSONArray();
        String sql = "select * from " + parentTablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        while (rs.next()) {
            JSONObject obj = this.getSendData(connTool, rs, fieldMapping, sendConfig);
            if (StringUtils.isEmpty(childTableid)) {//有子表
                List<TbtskApplicationApi> apiList = this.tbtskApplicationApiDao.queryByTableOrAssign(childTableid);
                if (apiList.isEmpty())
                    continue;
                TbtskApplicationApi api = apiList.get(0);
                String configTableId = api.getTableid();//查询关联数据需要使用，部分数据有多次外业的情况下，外网推送的任务objectinfo对应着api表的assigntotask字段
                Map<String, String> childMapping = this.getFieldMapping(configTableId);
                if (null == childMapping)
                    continue;
                JSONArray childObj = this.sendData(connTool, childTablename, null, null, childMapping, sendConfig);
                obj.put("children", childObj);
            }
            resultArray.add(obj);
        }
        return resultArray;
    }

    /**
     * 生成结果json数据
     * @param connTool
     * @param rs
     * @param fieldMapping
     * @param sendConfig
     * @return
     * @throws SQLException
     */
    private JSONObject getSendData(SqlliteConnTool connTool, ResultSet rs, Map<String, String> fieldMapping, JSONObject sendConfig)  throws SQLException {
        JSONObject result = new JSONObject();
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            result.put(entry.getValue(), rs.getString(entry.getKey()));
        }
        if (sendConfig.containsKey("hasShp") && sendConfig.getBoolean("hasShp")) {//是否返回shp数据
            String shpType = sendConfig.getString("shpType");
            if ("wkt".equals(shpType)) {
                result.put("shape", rs.getString("f_shape"));
            }
        }
        if (sendConfig.containsKey("hasMedia") && sendConfig.getBoolean("hasMedia")) {//是否返回照片数据
            String f_id = rs.getString("f_id");
            JSONArray mediaArray = this.getMediaArray(connTool, f_id, sendConfig);
            result.put("media", mediaArray);
        }
        return result;
    }

    /**
     * 生成结果照片数据
     * @param connTool
     * @param f_id
     * @param sendConfig
     * @return
     * @throws SQLException
     */
    private JSONArray getMediaArray(SqlliteConnTool connTool, String f_id, JSONObject sendConfig) throws SQLException {//返回数据相同
        JSONArray result = new JSONArray();
        String mediaSql = "select * from tb_app_media where f_galleryid = '" + f_id + "'";
        ResultSetInfo medisInfo = connTool.doQuery(mediaSql);
        ResultSet rsMedia = medisInfo.getResultSet();
        String[] fields = sendConfig.getString("mediaFields").split(",");//需要返回的字段配置，包含f_
        while (rsMedia.next()) {
            JSONObject obj = new JSONObject();
            for (int i = 0; i < fields.length; i++) {
                String fieldname = fields[i];
                if ("f_serverpath".equals(fieldname)) {//返回内网地址，代码同ImportDbServiceImpl getInsertValue方法
                    String path = rsMedia.getString(fieldname);
                    String[] pathArray = path.split("media");
                    String resultPath = "";
                    if (pathArray.length !=2) {
                        resultPath = path ;
                    } else {
                        if ("true".equals(this.minioModel)) {
                          /*  resultPath = this.minIOService.getHeaderUrl() + "/gtdcy" + "/media" + pathArray[1];*/
                        } else {
                            resultPath = this.mediaUrlPrefix + "/media" + pathArray[1];
                        }
                    }
                    obj.put("serverpath", resultPath);
                } else {
                    obj.put(fieldname.split("f_")[1], rsMedia.getString(fieldname));
                }
            }
            result.add(obj);
        }
        return result;
    }

    public void sendMessageByConfig(JSONObject sendConfig, JSONObject sendObj){
        JSONObject logData = new JSONObject();
        String url = sendConfig.getString("sendurl");
        String type = sendConfig.getString("sendtype");
        logData.put("send", sendObj);
        if ("post".equals(type)) {
            String result = null;//raw方式
            try {
                result = HttpUtil.JsonPostInvoke(url, sendObj.toJSONString());
            } catch (Exception e) {
                result = e.getMessage();
            }
            logData.put("result", result);
        }
        this.logService.saveLog(LogType.send_message, logData.toString());
    }
}
