package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.servface.datacq.BackDataService;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportTxtService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ImportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by licong on 2021/9/3.
 */
@Service
public class ImportTxtServiceImpl implements ImportTxtService {
    private GiLoger logger = GwLoger.getLoger(ImportTxtServiceImpl.class);
   /* @Value("#{imeSettings['project.applicationType']}")*/
    @Value("${project.applicationType}")
    protected String applicationType;
    /*@Autowired
    private CQService cqService;*/
    @Autowired
    private BackDataService backDataService;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private TskTaskBizService tskTaskBizService;
   /* @Autowired
    private SsnydService ssnydService;*/
    @Autowired
    private LogService logService;

    /**
     * 处理txt文件
     * @param filePath
     */
    @Override
    public void readTxt(String filePath) throws Exception {
        List<String> messageList = ImportDataUtils.readTxtFile(filePath);
        if (messageList.isEmpty()) {
            return;
        }
        String interfaceName = messageList.get(0);
        if (InterfaceType.backProject.equals(interfaceName)) {
            this.logger.info("处理backProject接口");
            this.reviewProjectLan(messageList);
        } else if (InterfaceType.deleteTask.equals(interfaceName)) {
            this.logger.info("处理deleteTask接口");
            this.deleteByTaskId(messageList);
        } else if ("sendTaskWhole".equals(interfaceName)) {
            this.logger.info("处理sendTaskWhole接口");
            this.assignTask(messageList, true);
        } else if ("sendTask".equals(interfaceName)) {
            this.logger.info("处理sendTask接口");
            this.assignTask(messageList, false);
        } else if (InterfaceType.submitProject.equals(interfaceName)) {
            this.logger.info("处理submitProject接口");
           /* if (this.cqService != null) {
                this.cqService.PostProjectDataThread(messageList.get(1));
            }*/
        } else if (InterfaceType.backLan.equals(interfaceName)) {
            this.logger.info("处理backLan接口");
            this.backLan(messageList);
        } else if (InterfaceType.sendUpdateJbnt.equals(interfaceName)) {
            this.logger.info("处理sendUpdateJbnt接口");
            this.sendUpdateJbnt(messageList);
        } else if (InterfaceType.sendSsnydResult.equals(interfaceName)) {
            this.logger.info("处理sendSsnydResult接口");
            this.sendSsnydResult(messageList);
        } else if (InterfaceType.sendUpdateSsnyd.equals(interfaceName)) {
            this.sendUpdateSsnyd(messageList);
        } else if (InterfaceType.backItem.equals(interfaceName)) {
            this.backItem(messageList);
        }
    }

    /**
     * 基本农田项目导入项目审核消息，外网
     * @throws Exception
     */
    @Transactional
    public void reviewProjectLan(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("项目审核接口参数获取异常");
        } else if ("lan".equals(this.applicationType)) {
            this.logger.error("调用接口异常，这里是外网处理接口");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String bizId = object.getString("bizId");
        String message = object.getString("message");
        String checkId = object.getString("checkId");
        String checkStatus = object.getString("checkStatus");
        TskTaskBiz newbiz = this.backDataService.reviewProject(bizId, message, checkId, checkStatus);
        if (null != newbiz) {
            this.taskResouceService.saveCheckMessage(message, newbiz.getId());
        }
    }

    /**
     * 任务删除
     * @param messageList
     * @throws Exception
     */
    private void deleteByTaskId(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("任务下发接口参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String taskId = object.getString("taskId");
        Long userId = object.getLong("userId");//暂未使用
        Boolean sync =  object.getBoolean("sync");
        String wyid =  object.getString("wyid");
        if(!"lan".equals(this.applicationType) || sync == null || !sync || StringUtils.isEmpty(wyid)) {
//            this.tskTaskBizService.deleteByTaskId(taskId);//物理删除
            this.tskTaskBizService.delByTaskId(taskId);//逻辑删除
        }else{
           /* this.cqService.sendDeleteMessage(wyid);*/
        }
    }

    /**
     * 任务下发
     * @param messageList
     * @param isWhole
     */
    private void assignTask(List<String> messageList, Boolean isWhole) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("任务下发接口参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        Long userId = object.getLong("userId");
//        this.taskService.assignTask(object, isWhole, userId);
    }

    private void backLan(List<String> messageList) {
        if (messageList.size() < 2) {
            this.logger.error("内网回退接口参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String oldBizId = object.getString("oldBizId");
        String newBizId = object.getString("newBizId");
        String newProjectId = object.getString("newProjectId");

        this.logService.saveLog(LogType.backLan, object.toString());
        this.backDataService.backLanThread(oldBizId, newBizId, newProjectId);
    }

    private void sendUpdateJbnt(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("外网更新数据参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject(message);
        this.taskResouceService.updateProject(null, obj);
    }

    private void sendSsnydResult(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("外网更新数据参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject(message);
       /* this.cqService.sendSsnydResult(obj.getString("data"));*/
    }

    private void sendUpdateSsnyd(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("外网更新数据参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject(message);
       /* this.ssnydService.sendMessage(obj);*/
    }

    private void backItem(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("外网更新数据参数获取异常");
        }
        JSONObject object = JSONObject.parseObject(messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject(message);
        String bizId = obj.getString("bizId");
        String tbids = obj.getString("tbids");
        String reason = obj.getString("reason");
        /*this.tskTaskBizService.backItem(bizId, tbids, reason);*/
    }
}
