package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.pub.constants.ApiDataType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportZbphDataService;
import com.geoway.landteam.landcloud.service.thirddata.utils.SendMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

import java.sql.ResultSet;
import java.util.Map;

/**
 * Created by licong on 2021/3/18.
 */
@Service
public class ImportZbphDataServiceImpl implements ImportZbphDataService {
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private LogService logService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    @Override
    public void importZbphDb(String file) throws Exception {
        SqlliteConnTool connTool = null;
        try {
            connTool = new SqlliteConnTool(file);
            //导入ZBPH_XMJBXX
            this.insertJbxx(connTool);
            this.insertJyxq(connTool);
            this.insertZbsy(connTool);
        } finally {
            connTool.Dispose();
        }
    }

    /**
     * 保存基本信息，直接插入数据
     */
    private void insertJbxx(SqlliteConnTool connTool) throws Exception {
        String namespace = ApiNameType.zbphImportData1[0];
        String apiname = ApiNameType.zbphImportData1[1];
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        String tableName = "ZBPH_XMJBXX";
        JSONArray array = this.saveZbphData(connTool, applicationApi, tableName);
        JSONObject config = JSONObject.parseObject(applicationApi.getSqlfilterstr());

        Thread thread = new Thread(()->{
            for (int i = 0; i < array.size();i++){
                JSONObject obj = array.getJSONObject(i);
                String sendResult = SendMessage.SendXxzxMessage(config.getString("appId"), config.getString("template"), obj.toString(), config.getString("url"));
                this.logService.saveLog(LogType.sendXzgdMessage, sendResult);
            }
        });
        threadPoolTaskExecutor.execute(thread);
    }

    /**
     * 保存交易详情，直接插入数据
     * @param connTool
     * @throws Exception
     */
    private void insertJyxq(SqlliteConnTool connTool) throws Exception{
        String namespace = ApiNameType.zbphImportData2[0];
        String apiname = ApiNameType.zbphImportData2[1];
        String tableName = "ZBPH_JYXQB";
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        this.saveZbphData(connTool, applicationApi, tableName);
    }

    /**
     * 保存指标剩余，删除原有数据，保存新数据
     * @param connTool
     * @throws Exception
     */
    private void insertZbsy(SqlliteConnTool connTool) throws Exception{
        String namespace = ApiNameType.zbphImportData3[0];
        String apiname = ApiNameType.zbphImportData3[1];
        String tableName = "ZBPH_SYZB";
        TbtskApplicationApi applicationApi = tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        this.truncateTable( applicationApi);
        this.saveZbphData(connTool, applicationApi, tableName);
    }

    private void truncateTable(TbtskApplicationApi applicationApi) {
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String sql = "TRUNCATE " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    private JSONArray saveZbphData(SqlliteConnTool connTool, TbtskApplicationApi applicationApi, String tableName) throws Exception {
        if (applicationApi == null) {
            throw new Exception("获取关联配置失败");
        }
        String tableid = applicationApi.getTableid();
        Map<String, String> mapping = this.taskResouceService.getFiledMap(tableid);
        String sql2 = "select * from " + tableName;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        JSONArray result = new JSONArray();
        while (rs2.next()) {
            JSONObject object = new JSONObject();
            for (Map.Entry<String, String> entry: mapping.entrySet()) {
                object.put(entry.getValue(), rs2.getObject(entry.getValue()));
            }
            this.taskResouceService.saveData(object, applicationApi, ApiDataType.Zbph);
            result.add(object);
        }
        return result;
    }
}
