package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskRejectRecord;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/7/19
 * @Description
 **/
@Component(DbResolver.PREFIX + "ba003")
public class WpzfApproveDbResolver  extends  AbstractWpzfDbResolver{
    private GiLoger logger = GwLoger.getLoger(WpzfApproveDbResolver.class);
    protected String getConfigPrefix(){
        return "ba003";
    }

    @Override
    public void resolve(SqlliteConnTool connTool) throws Exception {

        String tbbhSql = "select tbbh from dkinfo";
        ResultSetInfo gzlyResult = connTool.doQuery(tbbhSql);
        ResultSet tbbhRs = gzlyResult.getResultSet();
        tbbhRs.next();
        String tbbh = tbbhRs.getString("tbbh");
        if(StringUtils.isNotBlank(tbbh)){
            tbbh = tbbh.trim();
        }else {
            throw  new RuntimeException("缺少图斑编号");
        }
        //以 “-”和数字结尾的图斑编号认为是分割的图斑
        String regx = "-\\d+$";
        Pattern pattern = Pattern.compile(regx);
        Matcher matcher = pattern.matcher(tbbh);
        boolean isChild = matcher.find();
        //TODO 改成链式解析，用链表结构 组织可配置的解析模块
        //必填
        insertTable(connTool,"dkinfo","tbbh",getConfigPrefix() + ".dkinfo",2,isChild);
        insertTable(connTool,"dktb_hccg","tbbsm",getConfigPrefix() + ".dktb_hccg",2,isChild);

        //选填
        try {
            insertTable(connTool,"xzdc_hccg","tbbsm",getConfigPrefix() + ".xzdc_hccg",2,isChild);
        }catch (Exception e){
            logger.warn("SKIP INVALID TABLE");
        }

        ExchangeParam param = new ExchangeParam(jdbcTemplate,exchangeFieldRelDao, objectTableNameService);
        param.init("dkinfo","tbbsm",getConfigPrefix() + ".dktb_hccg",2);
        this.updateSystemInfo(connTool,param,isChild);

        //插入审核信息
        try {
            insertApproveRecord(connTool,"dktb_audit",getConfigPrefix() + ".audit",isChild);
            insertApproveRecord(connTool,"xzdc_audit",getConfigPrefix() + ".audit",isChild);
        }catch (Exception e){
            logger.warn("审核信息插入失败");
        }
        try {
            insertPwinfo(connTool,"dktb_pwinfo");
        }catch (Exception e){
            logger.warn("批文插入失败");
        }
    }

    protected void insertApproveRecord(SqlliteConnTool connTool,String tablename,String config,boolean isChild) throws Exception {
        //load data
        String sql = "select * from " + tablename ;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<JSONObject> aduitList = new ArrayList<>();
        String tbbsm = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            String bsm = rs.getString("tbbsm");
            tbbsm = rs.getString("tbbsm");
            String shr = rs.getString("shr");
            String shlx = rs.getString("shlx");
            String shsj = rs.getString("shsj");
            String shyj = rs.getString("shyj");
            Integer node = rs.getInt("nodeid");
            JSONObject aduitRecord = new JSONObject();
            aduitRecord.put("tbbsm",bsm);
            aduitRecord.put("shr",shr);
            aduitRecord.put("shlx",shlx);
            aduitRecord.put("shyj",shyj);
            Date date = sdf.parse(shsj);
            aduitRecord.put("shsj",date);
            aduitRecord.put("nodeid",node);
            aduitList.add(aduitRecord);
        }
        if(aduitList.isEmpty())
            return;

        //load Configuration
        TbExchangeFieldRel rel =  tbExchangeFieldRelDao.getConfig(config);
        String taskid = rel.getObjectid();
        String toTable = objectTableNameService.getTablename(taskid,2);
        String childTable = objectTableNameService.getChildTablename(taskid,2);

        //将bsm转为图斑id
        String tbidSql = "";
        if(!isChild){
            tbidSql = String.format("select f_id from %s where f_dkbsm = '%s'",toTable,tbbsm);
        }else {
            tbidSql = String.format("select f_id from %s where f_dkbsm = '%s'",childTable,tbbsm);
        }
        String tbid = Optional.ofNullable(tbidSql)
                .map(jdbcTemplate::queryForList)
                .filter(e -> !e.isEmpty())
                .map(e -> e.get(0))
                .map(e -> (String)e.get("f_id"))
                .orElseThrow(RuntimeException::new);

        //记录按时间升序排序
        aduitList =  aduitList.stream()
                .sorted(Comparator.comparingDouble(e -> ((Date)e.getOrDefault("shsj",new Date(0))).getTime()))
                .collect(Collectors.toList());
        TbtskApproveRecord lastRecord = saveAduitRecords(aduitList, sdf, taskid, tbid);

        //最新一条是通过,更新状态
        //最后一条一定是县级通过的，市级不走这个接口（用ba004），不通过不会给我们推送
        if(lastRecord != null){
            Integer option = lastRecord.getOption();
            if(option == 1){
                String updateSql = "";
                if(!isChild ){
                    updateSql = String.format("UPDATE %s SET  f_review_stage = 95 ,f_status = 10 WHERE f_id ='%s'",toTable,tbid);
                }else {
                    updateSql = String.format("UPDATE %s SET  f_review_stage = 95 ,f_status = 10 WHERE f_id ='%s'",childTable,tbid);
                }
                this.jdbcTemplate.update(updateSql);
            }
        }
    }

    private TbtskApproveRecord saveAduitRecords(List<JSONObject> aduitList, SimpleDateFormat sdf, String taskid, String tbid) {
        //保存审核记录
        List<TbtskApproveRecord> approveRecords = new ArrayList<>();
        TbtskApproveRecord lastRecord = null;
        int revokecount = 0;
        for(JSONObject aduit: aduitList){
            Date shsj = aduit.getDate("shsj");
            //上下容差1s检测重复
            Date toleStasrt = DateUtils.addSeconds(shsj,-1);
            Date toleEnd = DateUtils.addSeconds(shsj,1);
            String shlx = aduit.getString("shlx");
            int revokeFlag = "退回修改".equals(shlx)?2:1;
            int node = aduit.getIntValue("nodeid");
            int countApproved ;
            if (revokeFlag == 2){//reject
                revokecount += 1;
                //统计重复的
                countApproved = rejectRecordRepository.countByTaskidAndTbidAndTimerange(taskid,tbid,sdf.format(toleStasrt),sdf.format(toleEnd));
                if(countApproved < 1){
                    TbtskRejectRecord record = new TbtskRejectRecord();
                    record.setId(UUID.randomUUID().toString());
                    record.setTaskid(taskid);
                    record.setTbid(tbid);
                    record.setRejectTime(shsj);
                    record.setUserName(aduit.getString("shr"));
                    if(node == 1){
                        record.setSourceStage(93);
                        record.setStepName("县级审核");
                        record.setTargetStage(90);
                    }else {
                        record.setSourceStage(95);
                        record.setStepName("市级审核");
                        record.setTargetStage(93);
                    }
                    record.setRemark(aduit.getString("shyj"));
                    rejectRecordRepository.save(record);
                }
            }else{//approve
                //统计重复的
                countApproved = approveRecordRepository.countByTaskidAndTbidAndTimerange(taskid,tbid,sdf.format(toleStasrt),sdf.format(toleEnd));
                if(countApproved < 1){
                    TbtskApproveRecord record = new TbtskApproveRecord();
                    record.setId(UUID.randomUUID().toString());
                    record.setTaskid(taskid);
                    record.setTbid(tbid);
                    record.setApproveTime(shsj);
                    record.setApproveUser(aduit.getString("shr"));
                    if(node ==1 ){
                        record.setStepindex(0);
                        record.setStepname("县级审核");
                        record.setNextstep(1);
                    }else{
                        record.setStepindex(1);
                        record.setStepname("市级审核");
                        record.setNextstep(2);
                    }
                    record.setStatus(1);
                    record.setOption(revokeFlag);
                    record.setRemark(aduit.getString("shyj"));
                    record.setIsRevoked(revokecount);
                    record.setRejectCount(revokecount);
                    approveRecords.add(record);
                    lastRecord = record;
                }
            }
        }
        approveRecordRepository.saveAll(approveRecords);
        return lastRecord;
    }

    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, ExchangeParam param,boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = isChild?param.getToChildTable():param.getToTable();

        String sql = String.format("select %s from %s",primary,fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<String> idList = new ArrayList<>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty())
            return ;
        Set<String> idSet = new HashSet<>();
        //查找对应数据库中的id
        String idsql = String.format("select %s from %s where %s in ('%s')",myPrimary,toTbale,myPrimary, StringUtils.join(idList,"','"));
        List<Map<String, Object>> hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); i++) {
            idSet.add(hasIdList.get(i).get(myPrimary).toString());
        }

        String gzlySql = "select gzly from paraminfo";
        ResultSetInfo gzlyResult = connTool.doQuery(gzlySql);
        ResultSet gzlyRs = gzlyResult.getResultSet();
        gzlyRs.next();
        String gzly = gzlyRs.getString("gzly");

        String shapeSql = "select shape from dkinfo";
        ResultSetInfo shapeResult = connTool.doQuery(shapeSql);
        ResultSet shapeRs = shapeResult.getResultSet();
        shapeRs.next();
        String shape = shapeRs.getString("shape");
        Long date = System.currentTimeMillis();

        String updateSql = String.format("UPDATE %s SET  f_status = 1 ,f_xzqdmcity = left(f_xzqdmcity,4)||'00',f_xzqdmsys = f_xzqdm||'000000', f_createtime = %s ,f_userid = 101 , f_gzly = '%s',f_shape = st_geomfromtext('%s')  WHERE %s in ('%s')",toTbale,date,gzly,shape,myPrimary,String.join("','",idSet));
        this.jdbcTemplate.update(updateSql);
    }

}
