package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.datatransfer.DirectoryResolver;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

import java.io.File;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

/**
 * @Author Waves
 * @Date 2023/8/17
 * @Description
 **/
@Component(DirectoryResolver.PREFIX + "wpzf_tbfj")
public class WpzfAttachDirectoryResolver extends AbstractWpzfDirectoryResolver {
    @Override
    protected String getConfigKey( AttachFileParam param) {
        return "tbfj";
    }

    @Override
    protected String getAttachTableName( AttachFileParam param) {
        if("ba006".equals(getPrefix(param))){
            return "wtcz_tbfj";
        }
        return "tbfj";
    }
    @Override
    protected String queryFileInfoSql(AttachFileParam param, String filename){
        return "select * from " + getAttachTableName(param) + " where fjurl ='"+ filename + "';";
    }
    @Override
    protected void customedMediaField(AppMedia media,ResultSet rs) throws Exception{
        String user = rs.getString("scry");
        media.setUsername(user);
        media.setDeviceSource(2);
    }
}
