package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/7/21
 * @Description
 **/
@Component(DbResolver.PREFIX + "ba001")
public class WpzfClueDbResolver extends AbstractWpzfDbResolver {
    private GiLoger logger = GwLoger.getLoger(WpzfClueDbResolver.class);
    private static final String SOURCE_IMPORT = "-import-record";
    protected String getConfigPrefix(){
        return "ba001.";
    }
    protected String getConfigPrimary(){
        return "wpzftb";
    }

    protected String getConfigChief(){
        return "wpzftb_thpwinfo";
    }

    @Override
    public void resolve(SqlliteConnTool connTool) throws Exception {
        insertTable(connTool,getConfigPrimary(),"tbbsm",getConfigPrefix() + getConfigPrimary(),1);
        try {
            //可选表通过try插入
            insertTable(connTool,getConfigChief(),"tbbsm",getConfigPrefix() + getConfigChief(),1);
        }catch (RuntimeException e){
            logger.warn("SKIP INVALID TABLE");
        }
        //重构出来的奇怪写法
        ExchangeParam param = new ExchangeParam(jdbcTemplate,exchangeFieldRelDao, objectTableNameService);
        param.init(getConfigPrimary(),"tbbsm",getConfigPrefix() + getConfigPrimary(),1);
        this.updateSystemInfo(connTool,param,false);
    }



    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, ExchangeParam param,boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = param.getToTable();
        String objectid = param.getObjectid();
        String sql = String.format("select %s from %s",primary,fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<String> idList = new ArrayList<>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty())
            return ;
        Map<String,String>  metaMap = new HashMap<>();
        //查找对应数据库中的id
        String idsql = String.format("select f_xfsj,%s from %s where %s in ('%s')",myPrimary,toTbale,myPrimary, StringUtils.join(idList,"','"));

        List<Map<String, Object>> exitedIdList = this.jdbcTemplate.queryForList(idsql);//fid->xfsj
        for (int i = 0; i < exitedIdList.size(); i++) {
            Map<String, Object> xs = exitedIdList.get(i);
            metaMap.put(xs.get(myPrimary).toString(),(String) xs.get("f_xfsj"));
        }
        Long date = System.currentTimeMillis();
        String updateSql = String.format("UPDATE %s SET  f_status = 0 , f_createtime = %s ,f_userid = 101 , f_sourceid = '%s' WHERE %s in ('%s')",toTbale,date,objectid,myPrimary,String.join("','",metaMap.keySet()));
        this.jdbcTemplate.update(updateSql);

        //更新批次Id
        Map<String,String> recordIdMap = metaMap.entrySet()//fid->recordid
                .stream()
                .collect(Collectors.toMap(Map.Entry::getKey, e -> parseRecordId(e.getValue(),objectid)));
        StringBuilder sb = new StringBuilder();

        //TODO 为防止大事务后面可以改成分批插入
        for(Map.Entry<String,String> entry : recordIdMap.entrySet()){
            sb.append(String.format("UPDATE %s SET f_import_recordid = '%s'  WHERE f_id = '%s';",toTbale,entry.getValue(),entry.getKey()));
        }
        if(sb.length() > 0){
            jdbcTemplate.update(sb.toString());
        }
        //刷新批次统计值
        recordIdMap.entrySet()
                .stream()
                .map(Map.Entry::getValue)
                .forEach(jcClueImportRecordService::updateImportRecordStatistics);
    }

    /**
     * 根据下发时间和线索id,创建批次并返回批次id,批次已存在时直接返回批次id
     * @param xfsj 下发时间
     * @param sourceid 线索id
     * @return
     */
    private String parseRecordId(String xfsj, String sourceid) {
         String result = "";
        try{
            if(redisTemplate.opsForHash().hasKey(sourceid+SOURCE_IMPORT,xfsj)){
                result = (String) redisTemplate.opsForHash().get(sourceid+SOURCE_IMPORT,xfsj);
            }else{
                String name = transferDatePartern(xfsj, "wpzfClueFrom", "wpzfClueTo");
                JcClueImportRecord record = jcClueImportRecordMapper.selectBySourceNameAndSourceId(name,sourceid);
                if(record == null){
                    SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
                    Date date = new Date();
                    record = new JcClueImportRecord();
                    record.setfId(UUID.randomUUID().toString());
                    record.setfName(name);
                    record.setfSourceid(sourceid);
                    record.setfCreatetime(date);
                    record.setfJcsj(sdf.format(date));
                    jcClueImportRecordMapper.insert(record);
                }
                result = record.getfId();
                redisTemplate.opsForHash().put(sourceid+SOURCE_IMPORT,xfsj,result);
                redisTemplate.expire(sourceid+SOURCE_IMPORT,10, TimeUnit.MINUTES);
            }
        }catch (Exception e){
            logger.warn(e);
        }
        return result;
    }

    /**
     * 将时间串从from模式转换为to模式
     * @param sj
     * @param from
     * @param to
     * @return
     * @throws ParseException
     */
    private String transferDatePartern(String sj, String from, String to) throws ParseException {
        JSONObject parten = Optional.of("TimePartern")
                .map(sysConfigService::findToJson)
                .orElseGet(JSONObject::new);
        String xfsjParten = parten.getString(from);
        String importParten = parten.getString(to);
        SimpleDateFormat sdfFrom = new SimpleDateFormat(xfsjParten);
        SimpleDateFormat sdfTo = new SimpleDateFormat(importParten);
        Date date = sdfFrom.parse(sj);
        return sdfTo.format(date);
    }

}
