package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.datatransfer.DirectoryResolver;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

import java.io.File;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author Waves
 * @Date 2023/8/17
 * @Description
 **/
@Component(DirectoryResolver.PREFIX + "wpzf_hcfj")
public class WpzfMediaDirectoryResolver extends AbstractWpzfDirectoryResolver{
    @Override
    protected String getConfigKey( AttachFileParam param) {
        return "hcfj";
    }

    @Override
    //对方屎一样的设计，明明同样功能非得设计不同名称的表，内容形式没有一个统一的
    protected String getAttachTableName( AttachFileParam param) {
        if("ba006".equals(getPrefix(param))){
            return "wtcz_hcfj";
        }
        return "hcfj";
    }
    @Override
    protected String queryFileInfoSql(AttachFileParam param, String filename){
        return "select * from " + getAttachTableName(param) + " where fjmc ='"+ filename + "';";
    }
    @Override
    protected void customedMediaField(AppMedia media,ResultSet rs) throws Exception{
        String user = rs.getString("psry");
        media.setUsername(user);
        Double lon = rs.getDouble("x");
        media.setLon(lon);
        Double lat = rs.getDouble("y");
        media.setLat(lat);
        String azimuth = rs.getString("azimuth");
        media.setAzimuth(azimuth);
        String jym = rs.getString("jym");
        media.setJym(jym);
        Double fjdx = rs.getDouble("fjdx");
        media.setMediasize(fjdx);
        String pitch = rs.getString("pitch");
        media.setJym(pitch);
        Integer lysb = rs.getInt("lysb");
        media.setDeviceSource(lysb);
    }
}
