package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/7/19
 * @Description
 **/
@Component(DbResolver.PREFIX + "ba004")
public class WpzfRevokeDbResolver extends  AbstractWpzfDbResolver{
    @Override
    public void resolve(SqlliteConnTool connTool) throws Exception {

        insertApproveRecord(connTool,"dkinfo","ba004.audit");
    }
    protected void insertApproveRecord(SqlliteConnTool connTool,String tablename,String config) throws Exception {

        String sql = "select * from " + tablename ;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<JSONObject> aduitList = new ArrayList<>();
        String tbbsm = "";
        while (rs.next()) {
            String bsm = rs.getString("tbbsm");
            tbbsm = rs.getString("tbbsm");
            String shr = rs.getString("shr");
            String shlx = rs.getString("shlx");
            String shsj = rs.getString("shsj");
            String shyj = rs.getString("shyj");
            JSONObject aduitRecord = new JSONObject();
            aduitRecord.put("tbbsm",bsm);
            aduitRecord.put("shr",shr);
            aduitRecord.put("shlx",shlx);
            aduitRecord.put("shyj",shyj);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(shsj);
            aduitRecord.put("shsj",date);
            aduitList.add(aduitRecord);
        }
        if(aduitList.isEmpty())
            return;
        //按时间排序
        aduitList =  aduitList.stream()
                .sorted(Comparator.comparingDouble(e -> ((Date)e.getOrDefault("shsj",new Date(0))).getTime()))
                .collect(Collectors.toList());

        TbExchangeFieldRel rel =  tbExchangeFieldRelDao.getConfig(config);
        String taskid = rel.getObjectid();
        String toTable = objectTableNameService.getTablename(taskid,2);

        String uniqueKey = "f_tbbsm";
        String wpzfid = Optional.ofNullable("wpzf")
                .map(sysConfigService::findOne)
                .map(SysConfig::getValue)
                .orElse("");
        if(wpzfid.equals(taskid)){
            uniqueKey = "f_dkbsm";
        }
        //将bsm转为图斑id
        String tbidSql = String.format("select f_id from %s where %s = '%s'",toTable,uniqueKey,tbbsm);
        String tbid = Optional.ofNullable(tbidSql)
                .map(jdbcTemplate::queryForList)
                .filter(e -> !e.isEmpty())
                .map(e -> e.get(0))
                .map(e -> (String)e.get("f_id"))
                .orElseThrow(RuntimeException::new);
        //保存审核记录
        for(JSONObject aduit: aduitList){
            String shlx = aduit.getString("shlx");
            String shyj = aduit.getString("shyj");
            String username = aduit.getString("shr");
            Date shsj = aduit.getDate("shsj");
            tbtskFlowService.reject(taskid,tbid,null,null,shyj,shlx,username,"市级审核","县级审核",shsj,null);
        }
    }
}
