package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.pub.enm.ByteOperator;
import com.geoway.landteam.customtask.pub.entity.ImageCaptureDef;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.repository.pub.ImageCaptureDefRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.service.util.stepper.IStepParam;
import com.geoway.landteam.customtask.service.util.stepper.Stepper;
import com.geoway.landteam.customtask.service.util.stepper.StepperBuilder;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskImageCaptureService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbSyncStatusService;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.JinAoGeoJsonUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/8/2
 * @Description
 **/

@Component(DbResolver.PREFIX + "ba002")
public class WpzfSplitDbResolver extends AbstractWpzfDbResolver{

    GiLoger logger = GwLoger.getLoger(WpzfSplitDbResolver.class);

    protected TbtskFieldsRepository fieldsDao;
    protected MTbSyncStatusService mTbSyncStatusService;
    protected MTaskImageCaptureService mTaskImageCaptureService;
    protected ImageCaptureDefRepository imageCaptureDefRepository;
    private Set<String> customedFields = new HashSet<String>(){{
        add("f_id");
        add("f_shape");
        add("f_splitedid");
        add("f_issplitted");
        add("f_mergeid");
        add("f_ismultipart");
        add("f_pid");
    }};
    @Autowired
    public void setFieldsDao(TbtskFieldsRepository fieldsDao){
        this.fieldsDao = fieldsDao;
    }

    @Autowired
    public void setmTbSyncStatusService(MTbSyncStatusService mTbSyncStatusService) {
        this.mTbSyncStatusService = mTbSyncStatusService;
    }

    @Autowired
    public void setmTaskImageCaptureService(MTaskImageCaptureService mTaskImageCaptureService) {
        this.mTaskImageCaptureService = mTaskImageCaptureService;
    }

    @Autowired
    public void setImageCaptureDefRepository(ImageCaptureDefRepository imageCaptureDefRepository) {
        this.imageCaptureDefRepository = imageCaptureDefRepository;
    }

    @Override
    public void resolve(SqlliteConnTool connTool) throws Exception {
        //resolve paraminfo
        List<SplitParam> params = SplitParam.create(connTool);
        Map<String,List<SplitParam>> data = params.stream().collect(Collectors.groupingBy(SplitParam::getJcbh));
        for(Map.Entry<String,List<SplitParam>> entry : data.entrySet()){
            String jctbbh = entry.getKey();
            List<SplitParam> splitData = entry.getValue();
            insertSplitedSpotToChild(splitData,jctbbh);
        }
    }

    protected void insertSplitedSpotToChild(List<SplitParam> dataList,String jctbbh) throws Exception {

        TbExchangeFieldRel rel =  tbExchangeFieldRelDao.getConfig("ba002.dkinfo");
        String objectid = rel.getObjectid();
        String primary = rel.getInFieldName();
        String oriTable = objectTableNameService.getTablename(objectid,2);
        String childTable = objectTableNameService.getChildTablename(objectid,2);

        List<TbtskFields>  fields =  fieldsDao.getTbtskFieldsByTableName(oriTable);

        List<String> fieldList = fields.stream()
                .sorted(Comparator.comparing(TbtskFields::getfId))
                .filter(e -> !customedFields.contains(e.getfFieldname()) )
                .map(TbtskFields::getfFieldname)
                .collect(Collectors.toList());
        String fieldtable = String.join(",",fieldList) ;
        List<String> idList = new ArrayList<>();
        String tbbsm = "";
        boolean  sfcf = false;
        for(SplitParam data:dataList){
            if(sfcf = data.isSfcf()){
                //TODO 区分二次拆分
                Geometry shape = null;
                try {
                    shape = JinAoGeoJsonUtil.rings2Geometry(data.getShape());
                }catch (Exception e){
                    logger.error("无效的分割图形",e);
                }
                if(shape == null){
                    continue;
                }
                tbbsm = data.getTbbsm();
                //以 “-”和数字结尾的图斑编号认为是分割的图斑
                String regx = "-\\d+$";
                boolean isChild = Pattern.compile(regx).matcher(tbbsm).find();
                String sourceTable = isChild ? childTable : oriTable;
                //复制属性信息
                String uuid = UUID.randomUUID().toString();
                String sql = String.format("insert into %s( %s ,f_id,f_splitedid) select %s,'%s',f_id from %s where %s = '%s';",childTable,fieldtable,fieldtable,uuid,oriTable,primary,jctbbh);
                jdbcTemplate.update(sql);
                idList.add(uuid);
                //插入图形信息
                String tbbh = data.getTbbh();
                String updateSql = String.format("update %s set f_tbbh = '%s' ,f_shape = st_geomfromtext('%s'),f_dkbsm = '%s' where f_id = '%s';",childTable,tbbh,shape,tbbsm,uuid);
                jdbcTemplate.update(updateSql);
            }else{
                //TODO 区分取消拆分
            }
        }
        //修改母图斑属性
        String updateMainTable = String.format("update %s set f_issplitted = 1,f_dkbsm = '%s' where %s = '%s'",oriTable,tbbsm,primary,jctbbh);
        jdbcTemplate.update(updateMainTable);
        //拆分完自动截图
        ImageCaptureDef  captureDef = imageCaptureDefRepository.findById("3")
                .orElseThrow(()-> new RuntimeException("无效的截图任务类型"));
        //定制状态掩码
        CaptureParam param = new CaptureParam();
        param.setCaptureDef(captureDef);
        param.setTableName(childTable);
        param.setTaskId(objectid);
        param.setMask(MTbSyncStatusService.SYNC_CAPTURE_JA);
        StepperBuilder<String,CaptureParam> builder = StepperBuilder.create(this::capture)
                .step(captureDef.getPackgeSize())
                .param(param)
                .continueWhenException(true);
        Stepper.run(idList,builder);
    }

    private void startAtlasComputing(List<String> batchList,IStepParam param){
//        String
    }

    private void capture( List<String> batchList,CaptureParam param) {
        String taskId = param.getTaskId();
        String tableName = param.getTableName();
        ImageCaptureDef captureDef = param.getCaptureDef();
        Integer mask = param.getMask();
        mTaskImageCaptureService.startImageCapture(tableName, String.join(",", batchList), captureDef);
        mTbSyncStatusService.changeStatus(2, taskId, batchList, mask, ByteOperator.ADD);
    }
    static private class SplitParam{
        private String xzqdm;
        private String jcbh;
        private String tbbsm;
        private boolean sfcf;
        private String shape;
        private String tbbh;
        private double lat;
        private double lon;

        private SplitParam(){}

        public static List<SplitParam> create(SqlliteConnTool connTool) throws Exception {
            List<SplitParam> paramList = new ArrayList<>();
            String sql = "SELECT a.tbbsm,xzqdm,sfcf,jcbh,tbbh,shape,longitude,latitude FROM paraminfo a LEFT JOIN dkinfo b on a.tbbsm = b.tbbsm;";
            ResultSetInfo result = connTool.doQuery(sql);
            ResultSet rs = result.getResultSet();
            while(rs.next()){
                SplitParam  param = new SplitParam();
                param.tbbsm = rs.getString("tbbsm");
                param.sfcf = "Y".equals(rs.getString("sfcf"));
                param.xzqdm = rs.getString("xzqdm");
                param.jcbh = rs.getString("jcbh");
                param.tbbh = rs.getString("tbbh");
                param.shape = rs.getString("shape");
                param.lon = rs.getDouble("longitude");
                param.lat = rs.getDouble("latitude");
                paramList.add(param);
            }
            return paramList;
        }

        public String getXzqdm() {
            return xzqdm;
        }

        public String getJcbh() {
            return jcbh;
        }

        public String getTbbsm() {
            return tbbsm;
        }

        public boolean isSfcf() {
            return sfcf;
        }

        public String getShape() {
            return shape;
        }

        public String getTbbh() {
            return tbbh;
        }

        public double getLat() {
            return lat;
        }

        public double getLon() {
            return lon;
        }
    }

    private static class CaptureParam implements IStepParam{
        String taskId;
        String tableName;
        ImageCaptureDef captureDef;
        Integer mask;

        public String getTaskId() {
            return taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTableName() {
            return tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public ImageCaptureDef getCaptureDef() {
            return captureDef;
        }

        public void setCaptureDef(ImageCaptureDef captureDef) {
            this.captureDef = captureDef;
        }

        public Integer getMask() {
            return mask;
        }

        public void setMask(Integer mask) {
            this.mask = mask;
        }

    }

    private static class ComputingParam implements IStepParam{

    }
}
