package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskRejectRecord;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/8/2
 * @Description
 **/
@Component(DbResolver.PREFIX + "ba006")
public class WpzfWtzgDbResolver extends  AbstractWpzfDbResolver{
    GiLoger logger = GwLoger.getLoger(WpzfWtzgDbResolver.class);

    protected String getConfigPrefix(){
        return "ba006.";
    }
    protected String getConfigPrimary(){
        return "wtcz_hccg";
    }
    @Override
    public void resolve(SqlliteConnTool connTool) throws Exception {

        insertTable(connTool,getConfigPrimary(),"tbbsm",getConfigPrefix() + getConfigPrimary(),2);
        //选填
        try {
            insertTable(connTool,"wtcz_dkinfo","tbbsm",getConfigPrefix() + "wtcz_dkinfo",2);
        }catch (Exception e){
            logger.warn("SKIP INVALID TABLE");
        }
        ExchangeParam param = new ExchangeParam(jdbcTemplate,exchangeFieldRelDao, objectTableNameService);
        param.init("wtcz_hccg","tbbsm",getConfigPrefix() + "wtcz_hccg",2);
        this.updateSystemInfo(connTool,param,false);
        //resolve dkinfo表
        try {
            insertApproveRecord(connTool,"wtcz_audit",getConfigPrefix() + "audit");
        }catch (Exception e){
            logger.warn("审核信息插入失败");
        }

        try {
            insertPwinfo(connTool,"wtcz_pwinfo");
        }catch (Exception e){
            logger.warn("批文插入失败");
        }
    }
    protected void insertApproveRecord(SqlliteConnTool connTool,String tablename,String config) throws Exception {

        //load data
        String sql = "select * from " + tablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<JSONObject> aduitList = new ArrayList<>();
        String tbbsm = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            String bsm = rs.getString("tbbsm");
            tbbsm = rs.getString("tbbsm");
            String shr = rs.getString("shr");
            String shlx = rs.getString("shlx");
            String shsj = rs.getString("shsj");
            String shyj = rs.getString("shyj");
            JSONObject aduitRecord = new JSONObject();
            aduitRecord.put("tbbsm", bsm);
            aduitRecord.put("shr", shr);
            aduitRecord.put("shlx", shlx);
            aduitRecord.put("shyj", shyj);
            Date date = sdf.parse(shsj);
            aduitRecord.put("shsj", date);
            aduitList.add(aduitRecord);
        }
        if (aduitList.isEmpty())
            return;
        //按时间排序
        aduitList = aduitList.stream()
                .sorted(Comparator.comparingDouble(e -> ((Date) e.getOrDefault("shsj", new Date())).getTime()))
                .collect(Collectors.toList());
        int revokecount = 0;

        TbExchangeFieldRel rel = tbExchangeFieldRelDao.getConfig(config);
        String taskid = rel.getObjectid();
        String toTable = "";

        toTable = objectTableNameService.getTablename(taskid, 2);

        //将bsm转为图斑id
        String tbidSql = String.format("select f_id from %s where f_tbbsm = '%s'", toTable, tbbsm);

        String tbid = Optional.ofNullable(tbidSql)
                .map(jdbcTemplate::queryForList)
                .filter(e -> !e.isEmpty())
                .map(e -> e.get(0))
                .map(e -> (String) e.get("f_id"))
                .orElseThrow(RuntimeException::new);
        List<TbtskApproveRecord> approveRecords = new ArrayList<>();
        //保存审核记录
        for (JSONObject aduit : aduitList) {
            Date shsj = aduit.getDate("shsj");
            //上下容差1s
            Date toleStasrt = DateUtils.addSeconds(shsj, -1);
            Date toleEnd = DateUtils.addSeconds(shsj, 1);
            String shlx = aduit.getString("shlx");
            int revokeFlag = "退回修改".equals(shlx) ? 2 : 1;
            int countApproved;
            //统计已经插入的
            if (revokeFlag == 2) {
                revokecount += 1;
                countApproved = rejectRecordRepository.countByTaskidAndTbidAndTimerange(taskid, tbid, sdf.format(toleStasrt), sdf.format(toleEnd));
                if (countApproved < 1) {
                    TbtskRejectRecord record = new TbtskRejectRecord();
                    record.setId(UUID.randomUUID().toString());
                    record.setTaskid(taskid);
                    record.setTbid(tbid);
                    record.setRejectTime(shsj);
                    record.setUserName(aduit.getString("shr"));
                    record.setSourceStage(95);
                    record.setStepName("市级审核");
                    record.setTargetStage(93);
                    record.setRemark(aduit.getString("shyj"));
                    rejectRecordRepository.save(record);
                }
            } else {
                countApproved = approveRecordRepository.countByTaskidAndTbidAndTimerange(taskid, tbid, sdf.format(toleStasrt), sdf.format(toleEnd));
                if (countApproved < 1) {
                    TbtskApproveRecord record = new TbtskApproveRecord();
                    record.setId(UUID.randomUUID().toString());
                    record.setTaskid(taskid);
                    record.setTbid(tbid);
                    record.setApproveTime(shsj);
                    record.setApproveUser(aduit.getString("shr"));
                    record.setStepindex(0);
                    record.setStepname("县级审核");
                    record.setOption(revokeFlag);
                    record.setNextstep(1);
                    record.setRemark(aduit.getString("shyj"));
                    record.setIsRevoked(revokecount);
                    record.setRejectCount(revokecount);
                }
            }
        }
        //最新一条是通过,更新状态
        if (approveRecords.size() > 0) {
            Integer option = approveRecords.get(approveRecords.size() - 1).getOption();
            if (option == 1) {
                String updateSql = String.format("UPDATE %s SET  f_review_stage = 95 ,f_status = 10 WHERE f_id ='%s'", toTable, tbid);
                this.jdbcTemplate.update(updateSql);
            }
            approveRecordRepository.saveAll(approveRecords);
        }
    }
    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, ExchangeParam param,boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = param.getToTable();

        String sql = String.format("select %s from %s",primary,fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<String> idList = new ArrayList<>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty())
            return ;
        Set<String> idSet = new HashSet<>();
        //查找对应数据库中的id
        String idsql = String.format("select %s from %s where %s in ('%s')",myPrimary,toTbale,myPrimary, StringUtils.join(idList,"','"));
        List<Map<String, Object>> hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); i++) {
            idSet.add(hasIdList.get(i).get(myPrimary).toString());
        }

        String gzlySql = "select gzly from paraminfo";
        ResultSetInfo gzlyResult = connTool.doQuery(gzlySql);
        ResultSet gzlyRs = gzlyResult.getResultSet();
        gzlyRs.next();
        String gzly = gzlyRs.getString("gzly");
        Long date = System.currentTimeMillis();

        String updateSql = String.format("UPDATE %s as tb SET  f_status = 1 ,f_xzqdmsys = tb.f_xzqdm||'000000', f_createtime = %s ,f_userid = 101 , f_gzly = '%s' ,f_ssxzq = r.f_xzqmc " +
                " from tb_region as r WHERE tb.f_xzqdm = r.f_xzqdm and tb.%s in ('%s')",toTbale,date,gzly,myPrimary,String.join("','",idSet));
        this.jdbcTemplate.update(updateSql);
    }
}
