package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.datacq.dto.DataField;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.geoway.landteam.landcloud.service.util.hdfs.Result;
import com.geoway.landteam.landcloud.service.util.hdfs.Try;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * @Author Waves
 * @Date 2024/3/02
 * @Description
 **/
@Component(DbResolver.PREFIX + "ba007")
public class WpzfWtzgSyncDbResolver extends AbstractWpzfDbResolver{
    GiLoger loger = GwLoger.getLoger(this.getClass());

    protected String getConfigPrefix(){
        return "ba007.";
    }

    @Override
    public void resolve(SqlliteConnTool connTool) throws Exception {

        String iswtczSql = "select iswtcz from paraminfo";
        ResultSetInfo gzlyResult = connTool.doQuery(iswtczSql);
        ResultSet iswtczRs = gzlyResult.getResultSet();
        iswtczRs.next();
        Boolean iswtcz = "Y".equals(iswtczRs.getString("iswtcz"));
        ExchangeParam param = new ExchangeParam(jdbcTemplate,exchangeFieldRelDao, objectTableNameService);
        param.init("wtcz_dkinfo","tbbsm",getConfigPrefix() + "wtcz_dkinfo",2);
        if(iswtcz){
            insertTable(connTool,"wtcz_dkinfo","tbbsm",getConfigPrefix() + "wtcz_dkinfo",2);
            this.updateSystemInfo(connTool,param,false);
        }else{

            String fromTable = param.getFromTable();
            String primary = param.getPrimary();
            String myPrimary = param.getPgPrimary();
            String toTbale = param.getToTable();
            List<DataField> fieldsList = param.getFields();

            //查找db中的id
            String sql = "select * from " + fromTable;
            ResultSetInfo result = connTool.doQuery(sql);
            ResultSet rs = result.getResultSet();
            List<String> idList = new ArrayList<>();
            while (rs.next()) {
                String idvalue = rs.getString(primary);
                idList.add(idvalue);
            }
            if (idList.isEmpty())
                return;
            //查找对应数据库中的id
            String deleteSql = String.format("delete from %s where %s in ('%s')",toTbale,myPrimary, StringUtils.join(idList,"','"));
            jdbcTemplate.update(deleteSql);
        }
    }
    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, ExchangeParam param,boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = param.getToTable();

        String sql = String.format("select %s from %s",primary,fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<String> idList = new ArrayList<>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty())
            return ;
        Set<String> idSet = new HashSet<>();
        //查找对应数据库中的id
        String idsql = String.format("select %s from %s where %s in ('%s')",myPrimary,toTbale,myPrimary, StringUtils.join(idList,"','"));
        List<Map<String, Object>> hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); i++) {
            idSet.add(hasIdList.get(i).get(myPrimary).toString());
        }

        String gzlySql = "select gzly from paraminfo";
        ResultSetInfo gzlyResult = connTool.doQuery(gzlySql);
        ResultSet gzlyRs = gzlyResult.getResultSet();
        gzlyRs.next();
        String gzly = gzlyRs.getString("gzly");
        Long date = System.currentTimeMillis();

        String updateSql = String.format("UPDATE %s as tb SET  f_status = 1 ,f_xzqdmsys = tb.f_xzqdm||'000000', f_createtime = %s ,f_userid = 101 , f_gzly = '%s' ,f_ssxzq = r.f_xzqmc " +
                " from tb_region as r WHERE tb.f_xzqdm = r.f_xzqdm and tb.%s in ('%s')",toTbale,date,gzly,myPrimary,String.join("','",idSet));
        this.jdbcTemplate.update(updateSql);
    }
}
