package com.geoway.landteam.landcloud.service.datatransfer.support;

/**
 * Created by licong on 2021/4/22.
 */
public class DatabaseFieldType {

    /**
     * 获取pg字段类型,pg系统表字段 类型映射关系
     * @param atttypid
     * @return
     */
    public static String getPgType(String atttypid){
        switch (atttypid) {
            case "17":
                return "bytea";
            case "20":
                return "int8";
            case "21":
                return "int2";
            case "23":
                return "int4";
            case "25":
                return "text";
            case "114":
                return "json";
            case "701":
                return "float8";
            case "1043":
                return "varchar";
            case "1082":
                return "date";
            case "1114":
                return "timestamp";
            case "1700":
                return "numeric";
            case "310686":
                return "geometry";
            case "479130":
                return "geometry";
        }
        return "";
    }

    /**
     * 获取sqlite字段类型
     * @param type pg字段类型
     * @return
     */
    public static String getSqliteType(String type){
        switch (type) {
            case "bytea":
                return "bytea";
            case "int8":
                return "int8";
            case "int2":
                return "int2";
            case "int4":
                return "int4";
            case "text":
                return "text";
            case "json":
                return "json";
            case "float8":
                return "float8";
            case "varchar":
                return "varchar";
            case "date":
                return "date";
            case "timestamp":
                return "timestamp";
            case "numeric":
                return "numeric";
            case "geometry":
                return "geometry";
        }
        return "";
    }

}
