package com.geoway.landteam.landcloud.service.datatransfer.support;

import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.core.io.ClassPathResource;

import java.io.*;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;

/**
 * 工作平台相关数据导出工具类
 * Created by licong on 2021/3/19.
 */
public class ExportDataUtils {

    /**
     * 拷贝DB模板文件
     *
     * @param destDbFileDir 目标db文件路径
     * @return db文件路径
     */
    public static String copyDataBaseFile(String destDbFileDir, String template, String name) throws IOException {
        String destFileName = "";
        String srcFileName = "";
        if (StringUtils.isEmpty(name))
            name = "meta.db";
        try {
            FileUtil.creatDirectoryIfNotExist(destDbFileDir);
            ClassPathResource meta = new ClassPathResource("/static/"+template);
            InputStream inputStream = meta.getInputStream();
            destFileName = new StringBuilder()
                    .append(destDbFileDir)
                    .append(File.separator)
                    .append(name)
                    .toString();
            FileUtils.copyInputStreamToFile(inputStream, new File(destFileName));
        } catch (IOException e) {
            throw e;
        }
        return destFileName;
    }

    /**
     * 关闭数据库连接
     *
     * @param connPool
     * @param conn
     * @param ps
     */
    public static void closeConn(SqlliteConnTool connPool, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }

        if (connPool != null) {
            try {
                connPool.Dispose();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 创建insert sql字段名String
     * @param fields
     * @return
     */
    public static String getInsertFields(String[] fields) {
        String result = "";
        for (int i = 0; i < fields.length; i++) {
            result += "'" + fields[i] + "'";
            if (i != fields.length - 1) {
                result += ",";
            }
        }
        return result;
    }

    /**
     * 创建？
     * @param fields
     * @return
     */
    public static String getQuestionMark(String[] fields) {
        String result = "";
        for (int i = 0; i < fields.length; i++) {
            result += "?";
            if (i != fields.length - 1) {
                result += ",";
            }
        }
        return result;
    }

    /**
     *
     * @param pre
     * @param map
     * @param key
     * @param index
     * @throws SQLException
     */
    public static void setStringData(PreparedStatement pre, Map<String, Object> map, String key, int index) throws SQLException {
        if (null == map.get(key)) {
            pre.setString(index, null);
        } else {
            String val = map.get(key).toString();
            if("f_shape".equals(key)){
                val = val.replaceAll("^SRID=\\d{1,4};","");
            }
            pre.setString(index,val);
        }
    }

    /**
     * 复制文件
     * @param filename
     * @param fileParentPath
     * @param toPath
     * @throws IOException
     */
    public static void copyFileToSubmit(String filename, String fileParentPath, String toPath) throws IOException {
        String inFile = new StringBuilder()
                .append(fileParentPath)
                .append(File.separator)
                .append(filename)
                .toString();
        File in = new File(inFile);
        String outFile = new StringBuilder()
                .append(toPath)
                .append(File.separator)
                .append(filename)
                .toString();
        File out = new File(outFile);
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        copyFileUsingFileStreams(in, out);
    }

    public static void copyFileUsingFileStreams(File in, File out) throws IOException {
        InputStream input = null;
        OutputStream output = null;
        try {
            input = new FileInputStream(in);
            output = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int bytesRead;
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        } finally {
            input.close();
            output.close();
        }
    }
}
