package com.geoway.landteam.landcloud.service.datatransfer.support;

import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.locationtech.jts.geom.Geometry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by licong on 2021/9/3.
 */
public class ImportDataUtils {

    private  static GiLoger logger = GwLoger.getLoger(ImportDataUtils.class);
    public static List<String> readTxtFile(String filePath) throws Exception {
        try {
            List<String> result = new ArrayList<>();
            String encoding = "UTF-8";
            File file=new File(filePath);
            if(file.isFile() && file.exists()){ //判断文件是否存在
                InputStreamReader read = new InputStreamReader(
                        new FileInputStream(file),encoding);//考虑到编码格式
                BufferedReader bufferedReader = new BufferedReader(read);
                String lineTxt = null;
                while((lineTxt = bufferedReader.readLine()) != null){
                    result.add(lineTxt);
                }
                read.close();
            }else{
                throw new Exception("找不到指定的txt文件");
            }
            return result;
        } catch (Exception e) {
            throw e;
        }
    }

    public static Date toDate(Object obj) {
        if (null == obj) {
            return null;
        } else {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return format.parse(obj.toString());
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static Integer toInteger(Object obj){
        if (null == obj) {
            return null;
        } else {
            try {
                return Integer.valueOf(obj.toString());
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static Long toLong(Object obj){
        if (null == obj) {
            return null;
        } else {
            try {
                return Long.valueOf(obj.toString());
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static Double toDouble(Object obj){
        if (null == obj) {
            return null;
        } else {
            try {
                return Double.valueOf(obj.toString());
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static Timestamp toTimestamp(Object obj){
        if (null == obj) {
            return null;
        } else {
            try {
                return new Timestamp(Long.valueOf(obj.toString()));
            } catch (Exception e) {
                return null;
            }
        }
    }

    public static Geometry toGeometry(Object obj) {
        if (null == obj) {
            return null;
        } else {
            try {
                return WKTUtil.wktToGeom(obj.toString());
            } catch (Exception e) {
                return null;
            }
        }
    }
}
