package com.geoway.landteam.landcloud.service.filestorage;

import com.geoway.landteam.landcloud.servface.filestorage.FileStorageService;
import com.geoway.landteam.platform.filestorage.GwSdkContent;
import com.geoway.landteam.platform.filestorage.api.GwFileControlApi;
import com.geoway.landteam.platform.filestorage.model.GSdkFileInfoApo;
import com.geoway.landteam.platform.filestorage.spring.SpringSdkMultipartFile;
import com.gw.base.Gw;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.platform.apps.config
 * @date 2023/5/11 17:19
 */

@Component
public class FileSdkConfig implements ApplicationRunner, FileStorageService {


    @Value("${gw.filestorage.server_url}")
    private String serverUrl;

    @Value("${gw.filestorage.app_id}")
    private String appId;

    @Value("${gw.filestorage.bucket_name}")
    private String bucketName;

    @Autowired
    GwFileControlApi gwFileControlApi;

    @Override
    public void run(ApplicationArguments args) throws Exception {
        GwSdkContent.serverUrl = serverUrl;
        GwSdkContent.appid = appId;

        Gw.log.info("文件存储初始化信息：serverUrl:{}",serverUrl);
        Gw.log.info("文件存储初始化信息：appId:{}",appId);
        Gw.log.info("文件存储初始化信息：bucketName:{}",bucketName);

    }

    @Override
    public String saveFile(MultipartFile file, String path) {
        GSdkFileInfoApo upload = gwFileControlApi.upload(new SpringSdkMultipartFile(file), bucketName, path);
        return upload.getUrl();
    }

    @Override
    public String saveFile(File file, String path) {
        GSdkFileInfoApo upload = gwFileControlApi.upload(file, bucketName, path);
        return upload.getUrl();
    }

    @Override
    public String generatePresignedUrlByUrl(String url) {
        return gwFileControlApi.generatePresignedUrlByUrl(url, 3600L, "GET");
    }

}
