package com.geoway.landteam.landcloud.service.formatConversion;

import com.alibaba.fastjson.JSONArray;
import com.geoway.landteam.landcloud.service.formatConversion.utils.AsyncHandler;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

/**
 * Created by yecongwang on 2020/7/12.
 */
public class FileConversionService {

    /**
     * 获取到请求当中的multipartFile
     * @param request
     * @param rules
     * @param redisTemplate
     * @param username
     * @param downloadPath 系统的默认存储路径
     */
    public static void getTargetFiles(HttpServletRequest request, JSONArray rules, RedisTemplate redisTemplate, String username, String downloadPath){
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()){
                List<MultipartFile> files =  multiRequest.getFiles(iter.next());
                AsyncHandler asy = new AsyncHandler(files.size());
                for(int i=0;i<files.size();i++){
                    try{
                        if(files.get(i).getInputStream() != null){
                            asy.call(files.get(i),rules.getJSONObject(i),redisTemplate,username,downloadPath);
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                asy.shutDown(); //关闭线程池
            }
        }
    }

}
