package com.geoway.landteam.landcloud.service.formatConversion;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.*;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Gson2ShpService {
    private Logger log = Logger.getLogger(this.getClass().toGenericString());
    private String rootPath = null;

    public Gson2ShpService(String downloadPath){
        this.rootPath = downloadPath;
    }

    public  String startExchange(MultipartFile mulFile){
        String filename = mulFile.getOriginalFilename();
        String dirPath = this.rootPath+"gson2shp\\shp\\"+filename.substring(0,filename.indexOf("."));
        String gsonPath = this.rootPath+"gson2shp\\gson";
        GeometryJSON geojson = new GeometryJSON();
        File gsonFile = MulFileUtil.getFileFromMultipartFile(mulFile,".geojson",gsonPath);
        String shpPath = dirPath+"\\"+  filename.substring(0,filename.indexOf("."))+".shp";
        File dir = new File(dirPath);
        try{
            if(!dir.exists()){
                dir.mkdirs();
            }
            String geojsonStr = MulFileUtil.readJson(gsonFile.getAbsolutePath()).replaceAll(" ","");
            Map<String, Object> geojsonMap = JSONObject.parseObject(geojsonStr, Map.class);
            List<Map> features = (List<Map>) geojsonMap.get("features");
            Map<String,Object> crsMap = (Map<String,Object>) geojsonMap.get("crs");
            Map geojsonExemple = features.get(0);
            String geojsonType = ((Map) geojsonExemple.get("geometry")).get("type").toString();
            Map<String, String> mapFields = (Map<String, String>) geojsonExemple.get("properties");
            System.out.println(features.size());
            Class<?> geoType = null;
            switch(geojsonType){
                case "Point":
                    geoType = Point.class;
                    break;
                case "MultiPoint":
                    geoType = MultiPoint.class;
                    break;
                case "LineString":
                    geoType = LineString.class;
                    break;
                case "MultiLineString":
                    geoType = MultiLineString.class;
                    break;
                case "Polygon":
                    geoType = Polygon.class;
                    break;
                case "MultiPolygon":
                    geoType = MultiPolygon.class;
                    break;
            }
            //创建shape文件对象
            File file = new File(shpPath);
            Map<String, Serializable> params = new HashMap<String, Serializable>();
            params.put( ShapefileDataStoreFactory.URLP.key, file.toURI().toURL() );
            ShapefileDataStore ds = (ShapefileDataStore) new ShapefileDataStoreFactory().createNewDataStore(params);
            //获取crs
            String EPSG = ((Map<String,String>)crsMap.get("properties")).get("crs").toLowerCase();
            String crs = "EPSG:4490";//默认的坐标系
            String rex = "epsg.*([1-9]*?)";
            Pattern pattern = Pattern.compile(rex);
            Matcher matcher = pattern.matcher(EPSG);
            if(matcher.find()){
                crs = "EPSG:"+matcher.group().replaceAll("[^0-9]","");
            }
            //定义图形信息和属性信息
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setCRS(CRS.decode(crs));
            tb.setName("shapefile");
            tb.add("the_geom", geoType);
            tb.setDefaultGeometry("the_geom");
            Map<String,String> newField = fieldMapRule(mapFields);
            if(newField == null){
                log.warning("属性不存在");
                ds.dispose();
                return null;
            }
            for (String key : newField.keySet()) {
                tb.add(key, String.class);
            }
            ds.setCharset(Charset.forName("GBK"));
            ds.createSchema(tb.buildFeatureType());
            //设置Writer
            FeatureWriter<SimpleFeatureType, SimpleFeature> writer = ds.
                    getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            //设置每个地块的geometry
            for(int i=0,len=features.size();i<len;i++){
                Map oneGeojson = features.get(i);
                Map<String,String> attributes = (Map<String, String>) oneGeojson.get("properties");
                String strFeature = JSONObject.toJSONString(oneGeojson);
                Reader reader = new StringReader(strFeature);
                SimpleFeature feature = writer.next();

                switch(geojsonType){
                    case "Point":
                        feature.setAttribute("the_geom",geojson.readPoint(reader));
                        break;
                    case "MultiPoint":
                        feature.setAttribute("the_geom",geojson.readMultiPoint(reader));
                        break;
                    case "LineString":
                        feature.setAttribute("the_geom",geojson.readLine(reader));
                        break;
                    case "MultiLineString":
                        feature.setAttribute("the_geom",geojson.readMultiLine(reader));
                        break;
                    case "Polygon":
                        feature.setAttribute("the_geom",geojson.readPolygon(reader));
                        break;
                    case "MultiPolygon":
                        feature.setAttribute("the_geom",geojson.readMultiPolygon(reader));
                        break;
                }
                for (Map.Entry<String,String> field : fieldMapRule(attributes).entrySet()) {
                    feature.setAttribute(field.getKey(),field.getValue());
                }
                writer.write();
            }
            writer.close();
            ds.dispose();
            return dirPath;
        }
        catch(Exception e){
            log.warning("文件写入有误！");
            FileUtil.deleteFileAndDir(dir);
            e.printStackTrace();
            return null;
        }finally {
            FileUtil.deleteFileAndDir(new File(gsonPath));
        }
    }

    /**
     * 定义匹配规则，提取出属性信息,需要自定义
     * @param properties
     * @return
     */
    private  Map<String,String> fieldMapRule(Map<String,String> properties){
        Map<String,String> newFields = new HashMap<>();
        String[] rule = {"JZDSL","ZMJ","DKMC","XMMC","LX","SJTFH","DLMC"};
        String rex1 = "界址点数量,总面积,地块名称,项目名称,类型,涉及图幅号,地类名称";
        String rex2 = "JZDSL,ZMJ,DKMC,XMMC,LX,SJTFH,DLMC";
        int format = 0;
        if(format == 0){
            if(StrUtil.haveAttribute(rex1,properties)){
                format = 1;
            }
        }
        if(format == 0){
            if(StrUtil.haveAttribute(rex2,properties)){
                format = 2;
            }
        }
        switch (format){
            case 1:{
                String[] rexArr = rex1.split(",");
                for (int i=0;i<rexArr.length;i++){
                    newFields.put(rule[i],properties.get(rexArr[i]));
                }
            }break;
            case 2:{
                String[] rexArr = rex2.split(",");
                for (int i=0;i<rexArr.length;i++){
                    newFields.put(rule[i],properties.get(rexArr[i]));
                }
            }break;
            default:
                log.warning("需要先定义该属性的匹配规则！");return null;
        }
        return newFields;
    }

}