package com.geoway.landteam.landcloud.service.formatConversion;

import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class Shp2GsonService {

    private String rootPath = null;

    public Shp2GsonService(String downloadPath){
        this.rootPath = downloadPath;
    }
    /**
     * shp转换为Geojson
     * @param mulFile zip压缩包
     * @return
     */
    public  String startExchange(MultipartFile mulFile){
        String filename = mulFile.getOriginalFilename();
        String dirPath = this.rootPath+"shp2gson\\gson";
        String zipPath = this.rootPath+"shp2gson\\shp";
        String jsonPath = dirPath+"\\"+ filename.substring(0,filename.indexOf(".")) + ".geojson";
        FeatureJSON featureJson = new FeatureJSON();
        File zipFile = MulFileUtil.getFileFromMultipartFile(mulFile, ".zip",zipPath);
        File[] files = ZipUtil1s.unZip(zipFile, zipPath);
        if (files == null) {
            return null;
        }
        String zipDirFileName = zipPath +File.separator + FilenameUtils.getBaseName(zipFile.getName());;
        File zipDirFile = new File(zipDirFileName);
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");
        File shpFile = new File(shpFileList.get(0));
        try{
            File dir = new File(dirPath);
            if(!dir.exists()){
                dir.mkdirs();  //创建存放gson文件夹
            }
            BufferedWriter out =new BufferedWriter(new OutputStreamWriter(new FileOutputStream(jsonPath),"UTF-8"));
            ShapefileDataStore shpDataStore = null;
            shpDataStore = new ShapefileDataStore(shpFile.toURI().toURL());

            // 设置编码,防止中文乱码
            shpDataStore.setCharset(Charset.forName("gbk"));
            String typeName = shpDataStore.getTypeNames()[0];
            SimpleFeatureSource featureSource = null;
            featureSource =  shpDataStore.getFeatureSource (typeName);
            //获取CRS
            int crsId = 4490; //默认坐标系
            String crsData = CRS.toSRS(shpDataStore.getSchema().getCoordinateReferenceSystem());
            if(crsData.toLowerCase().contains("epsg")){
                crsId = Integer.parseInt(crsData.toLowerCase().replaceAll("[^0-9]",""));
            }else {
                Map<String,String> crsDataMap = StrUtil.splitCrsData(crsData);
                crsId = StrUtil.getCrsId(crsDataMap);
            }
            //拼接gson
            out.write("{\"type\": \"FeatureCollection\",\"crs\": {\"type\":\"name\",\"properties\":{\"crs\":\"EPSG:"+crsId+"\"}},");
            out.write("\"features\": [");
            SimpleFeatureCollection result = featureSource.getFeatures();
            SimpleFeatureIterator itertor = result.features();

            int count = 1;
            while (itertor.hasNext()) {
                SimpleFeature feature = itertor.next();
                StringWriter writer = new StringWriter();
                featureJson.writeFeature(feature, writer);
                out.write(writer.toString());
                if (count != result.size() ){
                    out.write( ",");
                }
                count ++;
            }
            out.write( "]}");
            itertor.close();
            out.flush();
            out.close();
            return jsonPath;
        }
        catch(Exception e){
            e.printStackTrace();
            return null;
        }finally {
            FileUtil.deleteFileAndDir(new File(zipPath));
        }

    }


}