package com.geoway.landteam.landcloud.service.formatConversion;



import com.alibaba.fastjson.JSONArray;
import com.geoway.landteam.customtask.service.util.ZipUtils;
import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ShapeOprate;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by yecongwang on 2020/7/15.
 */
public class Shp2TxtService {
    private Logger log = Logger.getLogger(this.getClass().toGenericString());
    private String rootPath = null;
    public Shp2TxtService(String downloadPath){
        this.rootPath = downloadPath;
    }
    public  String startExchange(MultipartFile shapeFile, String fileNum) {
        String shpDir = this.rootPath+"shp2txt\\shp";
        String txtDir = this.rootPath+"shp2txt\\txt";
        File shpFile = null;
        File zipFile = MulFileUtil.getFileFromMultipartFile(shapeFile, ".zip",shpDir);
        File[] files = ZipUtil1s.unZip(zipFile, shpDir);
        if (files == null) {
            return null;
        }
        List<Geometry> geoms = null;
        //存取转为txt需要的信息
        List<Map> fields=null;
        JSONArray muTiPolygonList = new JSONArray();
        Map<String,String> headData = null;
        // 解压文件夹名称
        String zipDirFileName = shpDir +File.separator + FilenameUtils.getBaseName(zipFile.getName());;
        File zipDirFile = new File(zipDirFileName);

        //获取prj文件
        List<String> prjFileList = FileUtil.findFiles(zipDirFileName, "*.prj");
        if (prjFileList != null && prjFileList.size() > 0) {
            headData = readPRJ(prjFileList.get(0));
        }
        // 获取shp文件
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");
        ShapeOprate shapeOprate = new ShapeOprate();
        if (shpFileList != null && shpFileList.size() > 0) {
            geoms = shapeOprate.readShp(shpFileList.get(0));
            try{
                muTiPolygonList =  getMuTiPolygon(geoms);

            }catch (Exception e){
                e.printStackTrace();
                return null;
            }
        }
        //获取dbf文件
        List<String> dbfFileList = FileUtil.findFiles(zipDirFileName, "*.dbf");
        if (dbfFileList != null && dbfFileList.size() > 0) {
            fields = MulFileUtil.readDBF(dbfFileList.get(0));
        }
        Map<String,String> field = fields.get(0);
        for(Map.Entry<String,String> head:field.entrySet()){
            switch (head.getKey()){
                case "GSBB":headData.put("格式版本号",head.getValue());break;
                case "SJCSDW":headData.put("数据产生单位",head.getValue());break;
                case "SJCSRQ":headData.put("数据产生日期",head.getValue());break;
                default:break;
            }
        }
        String success = createTxt(headData,fields,muTiPolygonList,txtDir,shapeFile.getOriginalFilename(),fileNum);
        // 删除解压文件夹
        FileUtil.deleteFileAndDir(new File(shpDir));
        return  success;
    }

    /**
     * 将muTiPolygon序列化
     * @param geoStr
     * @return
     */
    private static JSONArray muTi2single(String geoStr){
        JSONArray muTiPolygonList = new JSONArray();
        String rex = "\\([^(]*[^)]\\)";
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(geoStr);
        while (matcher.find()){
            if(matcher.group().contains(")), ((")){
                muTi2single(matcher.group());
            }else {
                String tem = "["+matcher.group().replaceAll("\\(|\\)","")+"]";
               /* muTiPolygonList.addAll(new JSONArray(tem));*/
                muTiPolygonList.addAll(JSONArray.parseArray(tem));
            }
        }
        return muTiPolygonList;
    }

    /**
     * 将mulTiPolygon序列化
     * @param geometries
     * @return
     */
    private static JSONArray getMuTiPolygon(List<Geometry> geometries){
        JSONArray muTiPolygonList = new JSONArray();
        for(Geometry geo:geometries){
            if(geo!=null && !"".equals(geo.toString().replaceAll(" ",""))){
                String geoStr = geo.toString();
               /* muTiPolygonList.put(muTi2single(geoStr));*/
                muTiPolygonList.addAll(muTi2single(geoStr));
            }
        }
        return muTiPolygonList;
    }

    /**
     * 读取.prj文件
     * @param path
     * @return
     */
    private static Map<String, String> readPRJ(String path){
        String wkt=null;
        Map<String,String> headData = new HashMap<>();
        List<String> unitList = new ArrayList<>();
        try{
            File fin = new File(path);
            FileInputStream fis = new FileInputStream(fin);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            String line = null;
            while ((line = br.readLine()) != null) {
                wkt = line;
            }
            br.close();
            fis.close();
            String rex = "(UNIT\\[[^]]*])";
            Pattern pattern = Pattern.compile(rex);
            Matcher matcher = pattern.matcher(wkt);
            while (matcher.find()){
                unitList.add(matcher.group());
            }
            String head = CRS.parseWKT(wkt).getName().toString().toLowerCase();
            boolean is3Degree = true;
            String daiHao = null;
            if(unitList.size()>0){
                String measure = unitList.get(0);
                headData.put("计量单位",measure.substring(measure.indexOf("\"")+1,measure.lastIndexOf("\"")));
            }
            if(head.contains("2000")){
                headData.put("坐标系","2000国家大地坐标系");
            }
            if(head.contains("gauss") || head.contains("kruger") || head.contains("gk")){
                headData.put("投影类型","高斯克吕格");
                String degreeRex = "3.*degree";
                Pattern degreePt = Pattern.compile(degreeRex);
                Matcher degreeMc = degreePt.matcher(head);
                if(degreeMc.find()){
                    headData.put("几度分带","3");
                }else {
                    headData.put("几度分带","6");
                    is3Degree = false;
                }

                if(head.contains("zone")){
                    daiHao = head.split("zone")[1].replaceAll("[^1-9]","");
                }else if(head.contains("cm")) {
                    int longitude = Integer.parseInt(head.split("cm")[1].replaceAll("[^1-9]",""));
                    if(is3Degree){
                        daiHao = Math.floor(longitude/3)+"";
                    }else {
                        daiHao = Math.floor((longitude+3)/6)+"";
                    }
                }
                headData.put("带号",daiHao);
            }
        }catch (IOException e){
            System.out.println(e);
        } catch (FactoryException e) {
            e.printStackTrace();
        }
        return headData;
    }

    /**
     * 获取要转换的txt数量
     * @param fieldList txt的地块坐标属性集合
     * @return
     */
    private List<String> getTxtNum(List<List<String>> fieldList){
        int index = fieldList.get(0).get(0) == null?4:0;
        List<String> symbolList = new ArrayList<>();
        List<String> identical = new ArrayList<>();
        for(int i=0;i<fieldList.size();i++){
            symbolList.add(fieldList.get(i).get(index));
        }
        for(String symbol:symbolList){
            if(!identical.contains(symbol)){
               identical.add(symbol);
            }
        }
        return identical;
    }

    /**
     * 排列属性顺序，此处需要定义属性规则
     * @param field
     * @return
     */
    private  List<String> checkOrder(Map<String,String> field){
        List<String> fieldList = new ArrayList<>();
        String rex = ",,,,,,,";
        String rex1 = ",JZDSL,ZMJ,DKMC,XMMC,LX,SJTFH,DLMC"; //定义自己的匹配规则
        String rex2 = "电子监管号,界址点数量,总面积,地块名称,项目名称,类型,涉及图幅号,地类名称";
        String rex3 = ",,,ZLDWMC,XMMC,,,";
        int format = 0;
        if(format == 0){
            if(StrUtil.haveAttribute(rex1,field)){
                format = 1;
            }
        }
        if(format == 0){
            if(StrUtil.haveAttribute(rex2,field)){
                format = 2;
            }
        }
        if(format == 0){
            if(StrUtil.haveAttribute(rex3,field)){
                format = 3;
            }
        }
//        if(format == 0){
//            //自定义其他的格式进行排序转换
//        }
        switch (format){
            case 1:{
                for(String attr:rex1.split(",")){
                    fieldList.add(field.get(attr));
                }
            }break;
            case 2:{
                for(String attr:rex2.split(",")){
                    fieldList.add(field.get(attr));
                }
            }break;
            case 3:{
                for(String attr:rex3.split(",")){
                    if("".equals(attr) || null==attr){
                        fieldList.add(attr);
                    }else{
                        fieldList.add(field.get(attr));
                    }
                }
            }break;
            default:{
                for(String attr:rex.split(",")){
                    if("".equals(attr) || null==attr){
                        fieldList.add(attr);
                    }else{
                        fieldList.add(field.get(attr));
                    }
                }
            }break;
        }
        return fieldList;
    }

    /**
     * 创建txt文件
     * @param headData
     * @param fields
     * @param muTiPolygonList
     * @param txtDir
     * @param filename
     * @param fileNum
     * @return
     */
    private  String createTxt(Map<String,String> headData,List<Map> fields,JSONArray muTiPolygonList,String txtDir,String filename,String fileNum) {
        List<List<String>> fieldList = new ArrayList<>();
        for(int i=0;i<fields.size();i++){
            if(checkOrder(fields.get(i)) != null){
                fieldList.add(checkOrder(fields.get(i)));
            }else {
                return null;
            }
        }
        String filePath = txtDir+"\\"+filename.substring(0,filename.indexOf("."))+"_"+fileNum;
        if("multiple".equals(fileNum)){
            List<String> identical = getTxtNum(fieldList);
            for(String symbol:identical){
                if(null == writeFile(headData,fieldList,muTiPolygonList,txtDir,filename,symbol,fileNum)){
                    filePath = null;
                    break;
                }
            }
        }else {
            if(null == writeFile(headData,fieldList,muTiPolygonList,txtDir,filename,null,fileNum)){
                filePath = null;
            }
        }
        return filePath;
    }

    /**
     * 写入txt各项内容
     * @param headData 头部属性描述
     * @param fieldList 地块坐标属性集合
     * @param muTiPolygonList
     * @param txtDir
     * @param filename
     * @param symbol 电子监管号或者项目名称，拆分文件
     * @param fileNum 转换为单/多个文件的标志
     * @return
     */
    private String writeFile(Map<String,String> headData,List<List<String>> fieldList,JSONArray muTiPolygonList,String txtDir,String filename,String symbol,String fileNum){
        FileOutputStream fos = null;
        BufferedWriter writer = null;
        String fileDir = txtDir+"\\"+filename.substring(0,filename.indexOf("."))+"_"+fileNum;
        String txt = fileDir+"\\"+filename.substring(0,filename.indexOf("."))+(symbol==null?"":"_"+symbol)+".txt";
        try{
            File dir = new File(fileDir);
            if(!dir.exists()){
                dir.mkdirs();
            }
            File file = new File(txt);
            fos = new FileOutputStream(file);
            OutputStreamWriter osw = new OutputStreamWriter(fos,"UTF-8");
            writer=new BufferedWriter(osw);
            writer.write("[属性描述]\n");
            for(Map.Entry<String,String> head:headData.entrySet()){
                writer.write(head.getKey()+"="+head.getValue()+"\n");
            }

//            System.setProperty("org.geotools.referencing.forceXY", "true");
            writer.write("[地块坐标]\n");
            for(int i=0;i<fieldList.size();i++) {
                List<String> fieldListOrder = fieldList.get(i);
                boolean write = false;
                if (fieldListOrder == null) {
                    writer.close();
                    fos.close();
                    FileUtil.deleteFileAndDir(dir);
                    return null;
                }
                if ("multiple".equals(fileNum)) {
                    if (fieldListOrder.contains(symbol)) {
                        write = true;
                    }
                } else {
                    write = true;
                }
                if (write) {
                    if (muTiPolygonList.get(i) != null) {
                        JSONArray mulTiPolygon = muTiPolygonList.getJSONArray(i);
                        for (int m = 0; m < mulTiPolygon.size(); m++) {
                            JSONArray polygon = mulTiPolygon.getJSONArray(m);
                            Geometry geometry = StrUtil.wktToGeometry(getWkt(polygon),StrUtil.getCrsId(headData));
                            if(Double.parseDouble(polygon.getString(0).split(" ")[0])<180){ //判断是不是经纬度
                                try{
                                    MathTransform transform = CRS.findMathTransform(CRS.decode("EPSG:4490"),CRS.decode("EPSG:"+StrUtil.epsgForArea(geometry)));
                                    geometry = JTS.transform(geometry,transform);
                                } catch (FactoryException e) {
                                    e.printStackTrace();
                                } catch (TransformException e) {
                                    e.printStackTrace();
                                }
                            }
                            double squareMArea = geometry.getArea();
                            double squareKMArea = Double.parseDouble(String.format("%.4f",squareMArea/10000));//换算为平方千米
                            int jzd = polygon.size();
                            writer.write(jzd + ",");
                            writer.write(squareKMArea + ",");
                            for (int n = 3; n < fieldListOrder.size(); n++) {
                                String tem = fieldListOrder.get(n)==null?"":fieldListOrder.get(n);
                                writer.write(tem + ",");
                            }
                            writer.write("@\n");
                            for (int l = 0; l < polygon.size(); l++) {
                                String[] point = polygon.get(l).toString().split(" ");
                                if (l == polygon.size() - 1) {
                                    writer.write("J1," + 1 + "," + point[1] + "," + point[0] + "\n");
                                    break;
                                }
                                writer.write("J" + (l + 1) + "," + 1 + "," + point[1] + "," + point[0] + "\n");
                            }
                        }
                    } else {
                        writer.close();
                        fos.close();
                        FileUtil.deleteFileAndDir(dir);
                        return null;
                    }
                }
            }
            writer.flush();
            writer.close();
            fos.close();
            return txt;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
    private static String getWkt(JSONArray polygon) {
        String wkt = "MULTIPOLYGON (";
        wkt += "((";
        for(int j=0;j<polygon.size();j++){
            String[] point = polygon.getString(j).split(" ");
            wkt += point[0] + " " + point[1] + ",";
        }
        wkt = wkt.substring(0, wkt.lastIndexOf(","));
        wkt += "))";
        wkt += ")";
        return wkt;
    }

}
