package com.geoway.landteam.landcloud.service.formatConversion;

import com.geoway.landteam.customtask.service.util.ZipUtils;
import com.geoway.landteam.landcloud.service.formatConversion.utils.FieldEntity;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ZipUtil1s;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.*;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * FileName: TransformShpService.java
 * Author:   dengmingdong
 * Date:     2020.07.18 18:21
 * Description: shapefile坐标系转换
 */

public class TransformShpService {

    String uploadDir;
    String downloadDir;
    RedisTemplate redisTemplate=null;
    public TransformShpService(String uploadDir, RedisTemplate redisTemplate, String downloadDir) {
        this.uploadDir = uploadDir;
        this.redisTemplate = redisTemplate;
        this.downloadDir = downloadDir;
    }

    /**
     * 将MultipartFile转成File
     *
     * @param belt 用户选定的需要设置的分度带值
     * @param sign 判断是查询文件信息还是进行文件转换的标志
     * @return
     */
    //取出shape文件
    public List<Integer> parsingShapeFile(HttpServletRequest request,String belt,String trans_rule) throws IOException {

        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        List<Integer>belts=new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                List<MultipartFile> shapeFile =  multiRequest.getFiles(iter.next());
                String[] target=belt.split(",");
                String[] trans_rules=trans_rule.split(",");
                for (int i = 0;i < shapeFile.size();i++){
                    if (shapeFile.get(i) != null) {
                        String fileName = shapeFile.get(i).getOriginalFilename();
                        if (fileName.endsWith(".zip")) {
//                             Todo  shapefile解析
                            belts.add(this.shapeFile(shapeFile.get(i),fileName,target[i],trans_rules[i]));
                        }
                    }
                }
            }
        }
        return belts;
    }

    /**
     * 解析zip文件读取其中的.shp文件
     *
     * @param fileName 压缩包文件名
     * @return
     */
    public Integer shapeFile(MultipartFile shapeFile, String fileName, String belt, String trans_rule) throws IOException {
        File zipFile = getFileFromMultipartFile(shapeFile, ".zip");
        File[] files = ZipUtil1s.unZip(zipFile, this.uploadDir);
        if (files == null) {
        }
        // 解压文件夹名称
        String zipDirFileName = this.uploadDir +File.separator + FilenameUtils.getBaseName(zipFile.getName());
        File zipDirFile = new File(zipDirFileName);
        // 获取shp文件
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");
        if(shpFileList.isEmpty()){
            System.out.println("没有shp文件");
            return 0;
        }else{
            for (int i=0;i<shpFileList.size();i++){
                String fileShp = shpFileList.get(i).toString();
                fileShp=fileShp.replaceAll("\\\\","\\\\\\\\");
                shpFileList.set(i,fileShp);
            }
            filePaths.clear();
            Integer theBelt=shpInfo(shpFileList,fileName,belt,trans_rule);
            FileUtil.deleteFileAndDir(zipDirFile);
            return theBelt;
        }
    }

    /**
     * 建立临时文件
     *
     * @param file
     * @return
     */
    private File getFileFromMultipartFile(MultipartFile file, String suffix) {
        File f = null;
        InputStream is = null;
        OutputStream os = null;
        File dir = new File(this.uploadDir + "/tmp");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            f = File.createTempFile(UUID.randomUUID().toString(), suffix, dir);
            is = file.getInputStream();
            os = new FileOutputStream(f);
            IOUtils.copy(is, os);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                os.close();
                is.close();
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
        return f;
    }

    private List<String> filePaths = new ArrayList<>();

    /**
     * 读取shp信息，建立字段集合和对应的属性值集合，返回转换完的EpsgCode
     *
     * @param shpFilePath 需要传给转换方法的.shp路径
     * @param zipName     需要传给写入文件方法的.zip文件名
     * @return
     */
    public Integer shpInfo(List<String> shpFilePath, String zipName, String belt,String trans_rule) throws IOException {

        Integer tarEpsg = 0;
        for (int i = 0; i < shpFilePath.size(); i++) {
            //遍历shp集合
            ShapefileDataStore dataStore = buildDataStore(shpFilePath.get(i));
            long startTime = System.currentTimeMillis();
            //加载文件
            File file = new File(shpFilePath.get(i));
            if (file == null) {
            }
            //通过store获取featurecollection
            FileDataStore store = FileDataStoreFinder.getDataStore(file);
            SimpleFeatureSource featureSource = store.getFeatureSource();
            SimpleFeatureCollection simpleFeatureCollection = featureSource.getFeatures();
            SimpleFeatureIterator itertor = simpleFeatureCollection.features();

            //遍历featurecollection
            //属性值集合
            List<List<Object>> datarows = new ArrayList<>();
            //属性字段集合
            List<FieldEntity> fields = new ArrayList<>();
            List<Integer> equalEpsg = new ArrayList<>();
            Integer finalEpsg = 0;
            while (itertor.hasNext()) {
                Map<String, Object> data = new HashMap<String, Object>();
                SimpleFeature feature = itertor.next();
                Collection<Property> p = feature.getProperties();
                Iterator<Property> it = p.iterator();
                //遍历feature的properties
                List<FieldEntity> field = new ArrayList<>();
                List<Object> datarow = new ArrayList<>();
                Integer geoNum = 0;
                while (it.hasNext()) {
                    //遍历属性字段
                    Property pro = it.next();
                    String name = pro.getName().toString();
                    name = name.equals("the_geom") ? "wkt" : name;
                    FieldEntity fieldEntity = new FieldEntity(pro.getName().toString(), pro.getValue().getClass());
                    field.add(geoNum, fieldEntity);
                    data.put(name, pro.getValue());
                    if (name == "wkt") {
                        if (geoNum == 0) {
                            finalEpsg = StrUtil.getEpsg((Geometry) pro.getValue(), belt);
                        }
                        Geometry transgeo = null;
                        try {
                            //通过wkt和targetEpsg得到转换规则
                            String wkt = dataStore.getSchema().getCoordinateReferenceSystem().toWKT();
//                                System.out.println("-------------"+wkt);
                            CoordinateReferenceSystem crsTarget = CRS.decode("EPSG:" + finalEpsg.toString());
                            CoordinateReferenceSystem crsSource = CRS.parseWKT(wkt);
                            // 投影转换
                            MathTransform transform = CRS.findMathTransform(crsSource, crsTarget, true);
                            transgeo = JTS.transform((Geometry) pro.getValue(), transform);

                        } catch (UnsupportedOperationException e) {
                            e.printStackTrace();
                        } catch (IOException e) {
                            e.printStackTrace();
                        } catch (FactoryException e) {
                            e.printStackTrace();
                        } catch (TransformException e) {
                            e.printStackTrace();
                        }
                        datarow.add(transgeo);
                    } else {
                        datarow.add(pro.getValue());
                    }
                    geoNum++;
                }
                fields = field;

                datarows.add(datarow);
            }
            itertor.close();
            File tempFile = new File(shpFilePath.get(i).trim());
            String fileName = tempFile.getName();

//            filePaths.add("D:\\convert\\" + fileName);
            filePaths.add(downloadDir + "\\"+fileName);
            Boolean readyOut = (i == shpFilePath.size() - 1);
//            this.write("D:\\convert\\" + fileName, fields, datarows, zipName, finalEpsg, readyOut,trans_rule);
            this.write(downloadDir +"\\"+ fileName, fields, datarows, zipName, finalEpsg, readyOut,trans_rule);
            long endTime = System.currentTimeMillis();
            System.out.println("当前程序耗时：" + (endTime - startTime) + "ms");

            tarEpsg = finalEpsg;
            dataStore.dispose();
        }
        return tarEpsg;
    }

    /**
     * 根据属性字段和对应的值写入文件中
     *
     * @param filepath   写入的路径
     * @param fields     属性字段及其类型集合
     * @param dataRows   属性值集合
     * @param zipName    传给压缩方法的压缩包文件名
     * @param targetCode 写入的目标EPSG
     * @param readyOut   当有多个.shp文件时，判断是否已经全部传入
     * @return
     */
    public void write(String filepath, List<FieldEntity> fields, List<List<Object>> dataRows, String zipName, Integer targetCode, Boolean readyOut,String trans_rule) {
        System.setProperty("org.geotools.referencing.forceXY", "true");
        if (filepath == null || fields == null || dataRows == null)
            return;
        if (dataRows.size() == 0) {
            System.out.println("未获取到属性值！");
        } else if (fields.size() != dataRows.get(0).size()) {
            return;
        }
        try {
            //创建shape文件对象
            File file = new File(filepath);
            Map<String, Serializable> params = new HashMap<String, Serializable>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore) new ShapefileDataStoreFactory().createNewDataStore(params);
            //定义图形信息和属性信息
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setCRS(DefaultGeographicCRS.WGS84);
            tb.setCRS(CRS.decode("EPSG:" + targetCode));
            tb.setName("shapefile");

            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            WKTReader wtkreader = new WKTReader(geometryFactory);
            tb.setDefaultGeometry("the_geom");
            for (int i = 0; i < fields.size(); i++) {
                if (fields.get(i).fieldName.equals("the_geom")) {
                    tb.add(fields.get(i).fieldName, fields.get(i).fieldType, CRS.decode("EPSG:" + targetCode));//设置字段
                } else {
                    tb.add(fields.get(i).fieldName, fields.get(i).fieldType);//设置字段
                }
            }
            SimpleFeatureType sft = tb.buildFeatureType();
            ds.createSchema(sft);
            ds.setCharset(Charset.forName("ISO-8859-1"));

            //设置Writer
            FeatureWriter<SimpleFeatureType, SimpleFeature> writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            //写下一条
            //遍历写入数据
            for (int index = 0; index < dataRows.size(); index++) {
                List<Object> row = dataRows.get(index);
                if (row != null && fields.size() == row.size()) {
                    SimpleFeature feature = writer.next();
                    for (int fIndex = 0; fIndex < row.size(); fIndex++) {
                        if (row.get(fIndex).getClass() == (fields.get(fIndex).fieldType)) {
                            feature.setAttribute(fields.get(fIndex).fieldName, row.get(fIndex));
                        } else if (fields.get(fIndex).fieldName.equals("the_geom") && row.get(fIndex).getClass() == String.class) {

                            String wkt = row.get(fIndex).toString();
                            Geometry geom = wtkreader.read(wkt);
                            if (fields.get(fIndex).fieldType == LineString.class) {
                                feature.setAttribute(fields.get(fIndex).fieldName, (LineString) geom);
                            } else if (fields.get(fIndex).fieldType == Polygon.class) {
                                feature.setAttribute(fields.get(fIndex).fieldName, (Polygon) geom);
                            } else if (fields.get(fIndex).fieldType == Point.class) {
                                feature.setAttribute(fields.get(fIndex).fieldName, (Point) geom);
                            } else if (fields.get(fIndex).fieldType == MultiPoint.class) {
                                feature.setAttribute(fields.get(fIndex).fieldName, (MultiPoint) geom);
                            } else if (fields.get(fIndex).fieldType == MultiLineString.class) {
                                feature.setAttribute(fields.get(fIndex).fieldName, (MultiLineString) geom);
                            } else if (fields.get(fIndex).fieldType == MultiPolygon.class) {
                                feature.setAttribute(fields.get(fIndex).fieldName, (MultiPolygon) geom);
                            }
                        }
                    }
                }
            }
            writer.write();
            writer.close();
            ds.dispose();

            //添加到压缩文件
            if (readyOut) {
                zipShapeFile(zipName,trans_rule);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 将写好的文件打包
     *
     * @param zipName 生成的压缩包文件名
     * @return
     */
    //压缩文件
    public void zipShapeFile(String zipName,String trans_rule) {
        try {
            List<String> shpFiles = new ArrayList<>();
            //输出路径
            String outRoot = "";
            //遍历shp列表，生成相关文件
            for (int i = 0; i < filePaths.size(); i++) {
                File shpFile = new File(filePaths.get(i));
                String shpRoot = shpFile.getParentFile().getPath(),
                        _shpName = shpFile.getName(),
                        shpName = _shpName.substring(0, _shpName.lastIndexOf("."));
                outRoot = shpRoot;
                shpFiles.add(shpRoot + File.separator + shpName + ".dbf");
                shpFiles.add(shpRoot + File.separator + shpName + ".prj");
                shpFiles.add(shpRoot + File.separator + shpName + ".shp");
                shpFiles.add(shpRoot + File.separator + shpName + ".shx");
            }
            //建立zip文件，并添加所有生成文件
            String zipPath = outRoot + File.separator + zipName;
            File zipFile = new File(zipPath);
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
            InputStream input = null;
            for (int j = 0; j < shpFiles.size(); j++) {
                File _file = new File(shpFiles.get(j));
                input = new FileInputStream(_file);
                zipOut.putNextEntry(new ZipEntry(_file.getName()));
                int temp = 0;
                while ((temp = input.read()) != -1) {
                    zipOut.write(temp);
                }
                input.close();
                _file.delete();
            }
            //删除生成的fix文件
            File fixFile = new File(outRoot);
            if (!fixFile.exists() || !fixFile.isDirectory()) { //不是目录
                return;
            }
            String[] tmpList = fixFile.list();
            if (tmpList != null) {
                for (String aTempList : tmpList) {
                    File tmpFile = new File(fixFile, aTempList);
                    if (tmpFile.isFile() && tmpFile.getName().endsWith(".fix")) {
                        tmpFile.delete();
                    }
                }
            }
            zipOut.close();
            redisTemplate.opsForList().rightPush("username",zipFile.getName()+"|"+trans_rule);
//            for(Object o :redisTemplate.opsForList().range("username",0,-1)){
//                System.out.println(o.toString()+"=========");
//            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 构建ShapeDataStore对象。
     *
     * @param shpFilePath shape文件路径。
     * @return
     */
    public static ShapefileDataStore buildDataStore(String shpFilePath) {
        ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
        try {
            ShapefileDataStore dataStore = (ShapefileDataStore) factory
                    .createDataStore(new File(shpFilePath).toURI().toURL());
            if (dataStore != null) {
                dataStore.setCharset(Charset.forName("UTF-8"));
            }
            return dataStore;
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

}